<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package WordPress
 * @subpackage FAQ_SAAS
 * @since FaqSaas 1.0
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
    <?php endif; ?>
    <?php wp_head(); ?>
</head>

<?php

    $args = array(
        'bg_color'   => '#fff',
        'bg_image'   => '',
        'bg_repeat'  => 'repeat-x',
        'bg_size'    => 'cover',
    );
    $body_bg = faqsaas_background_css( 'faqsaas_body_background', $args );
 ?>

<body <?php body_class(); ?> style="<?php echo esc_attr($body_bg); ?>">
<div id="page" class="site">
    <div class="site-inner">
        <a class="skip-link screen-reader-text" href="#content"><?php _e( 'Skip to content', 'faqsaas' ); ?></a>

        <?php



            $style = '';
            $choose_options = get_post_meta( get_the_ID(), '_choose_settings', true );
            $choose_options = $choose_options ? $choose_options : 'option_panel';
            $show_banner = 'true';
            $show_breadcrumbs = 'true';
            $banner_title = get_the_title();
            $image_url = '';
            $htmls = faqsaas_allowed_tags();

            extract(faqsaas_extract_option_data(array(
                'logo' => array(FAQSAAS_IMAGE.'new-logo.png', 'faqsaas_header_icon', 'url'),
                'page_title' => array('', 'faqsaas_landing_page_title'),
                'page_sub_title' => array('', 'faqsaas_landing_page_sub_title'),
                'search_placeholder' => array('Search Placeholder', 'faqsaas_search_placeholder'),
            )));


            if( is_page()  && $choose_options != 'option_panel' ) :

                extract(faqsaas_extract_page_meta_data(array(
                    'show_banner' => array('true', '_set_banner_as' ),
                    'image' => array('', '_banner_image' ),
                    'color' => array('true', '_page_color' ),
                    'banner_as' => array('true', '_set_banner_as' ),
                    'banner_title' => array( get_the_title(), '_show_page_title' ),
                    'page_title' => array('', '_faqsaas_page_title'),
                    'page_sub_title' => array('', '_faqsaas_page_subtitle'),
                )));

                if($image && $banner_as === 'image' ){
                    $image_url = wp_get_attachment_image_src( $image );
                }

                $args = array(
                    'bg_color'   => $color,
                    'bg_image'   => $image_url[0],
                    'bg_repeat'  => 'repeat-x',
                    'bg_size'    => 'cover',
                );

                $style = faqsaas_page_background( $args );

            else :

                extract(faqsaas_extract_option_data(array(
                    'show_banner' => array('true', 'faqsaas_show_banner' ),
                    'show_breadcrumbs' => array('true', 'faqsaas_show_breadcrubmbs'),
                    'logo' => array(FAQSAAS_IMAGE.'new-logo.png', 'faqsaas_header_icon', 'url'),
                    'page_title' => array('', 'faqsaas_landing_page_title'),
                    'page_sub_title' => array('', 'faqsaas_landing_page_sub_title'),
                    'search_placeholder' => array('Search Placeholder', 'faqsaas_search_placeholder'),
                )));

                $args = array(
                    'bg_color'   => 'transparent',
                    'bg_image'   => '',
                    'bg_repeat'  => 'repeat-x',
                    'bg_size'    => 'cover',
                );
                $style = faqsaas_background_css( 'faqsaas_banner_background', $args );

            endif;


            // Header background
            $args = array(
                'bg_color'   => '#fff',
                'bg_image'   => '',
                'bg_repeat'  => 'repeat-x',
                'bg_size'    => 'cover',
            );
            $header_bg = faqsaas_background_css( 'faqsaas_header_background', $args );

        ?>

        <header class="header" style="<?php echo esc_attr($style); ?>" >
            <nav class="navbar navbar-default"  style="<?php echo esc_attr($header_bg); ?>">
                <div class="container">
                    <div class="navbar-header">
                        <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1" aria-expanded="false">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                        <a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
                            <img src="<?php echo esc_url($logo); ?>" alt="<?php esc_html_e('logo', 'faqsaas'); ?>">
                        </a>
                    </div>

                    <!-- Collect the nav links, forms, and other content for toggling -->
                    <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
                        <?php
                            $defaults = array(
                                'theme_location'  => 'primary',
                                'menu'            => 'horizontal',
                                'container'       => '',
                                'container_class' => '',
                                'container_id'    => '',
                                'menu_class'      => 'menu',
                                'menu_id'         => '',
                                'echo'            => true,
                                'before'          => '',
                                'after'           => '',
                                'link_before'     => '',
                                'link_after'      => '',
                                'items_wrap'      => '<ul id="%1$s" class="nav navbar-nav navbar-right %2$s">%3$s</ul>',
                                'depth'           => 4,
                                'fallback_cb'     => 'faqsaas_nav_walker::fallback',
                                'walker'          => new faqsaas_nav_walker()
                            );

                            wp_nav_menu( $defaults );
                        ?>
                    </div><!-- /.navbar-collapse -->
                </div><!-- /.container-fluid -->
            </nav>


            <div class="header-banner">
                <h3><?php echo esc_attr( $page_title ); ?></h3>
                <?php echo wp_kses($page_sub_title, $htmls); ?>
                <form id="dwqa-search" class="dwqa-search">
                    <button class=" btn search-icon"><i class="fa fa-search"></i></button>
                    <input data-nonce="<?php echo wp_create_nonce( '_dwqa_filter_nonce' ) ?>" type="text" placeholder="<?php echo esc_attr($search_placeholder); ?>" name="qs" value="<?php echo isset( $_GET['qs'] ) ? esc_html( $_GET['qs'] ) : '' ?>">
                </form>
            </div>


        </header>


        <?php

            // Main Container background
            $args = array(
                'bg_color'   => '#fff',
                'bg_image'   => '',
                'bg_repeat'  => 'repeat-x',
                'bg_size'    => 'cover',
            );
            $container_bg = faqsaas_background_css( 'faqsaas_container_background', $args );

         ?>

        <div id="content" class="site-content" style="<?php echo esc_attr($container_bg); ?>">






