<?php
/**
 * Utility functions for theme usage
 *
 * Contains necessary functions for theme usage
 *
 * Wordpress 3.6+
 *
 * @package    faqsaas
 * @author     UOU Apps <info@uouapps.com>
 * @author     Ata Alqadi <ata.alqadi@gmail.com>
 * @link       http://themeforest.net/user/uouapps
 */
?>
<?php


/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 *
 * To override xxl_setup() in a child theme, add your own xxl_setup to your child theme's
 * functions.php file.
 *
 * @uses add_theme_support() To add support for post thumbnails and automatic feed links.
 * @uses register_nav_menus() To add support for navigation menus.
 * @uses add_custom_background() To add support for a custom background.
 * @uses add_editor_style() To style the visual editor.
 * @uses load_theme_textdomain() For translation/localization support.
 * @uses add_custom_image_header() To add support for a custom header.
 * @uses register_default_headers() To register the default custom header images provided with the theme.
 * @uses set_post_thumbnail_size() To set a custom post thumbnail size.
 *
 * @since faqsaas_THEME_NAME 1.0
 */


/* -------------------------------------------------------------------------
    END CASA COMMENT WALKER CLASS
------------------------------------------------------------------------- */



/*-------------------------------------------------------------------------
  START CONCIERGE CUSTOM PAGINATION
------------------------------------------------------------------------- */

function faqsaas_pagination($pages = '', $range = 2)
{
     $showitems = ($range * 2)+1;

     global $paged;
     if(empty($paged)) $paged = 1;

     if($pages == '')
     {
         global $wp_query;
         $pages = $wp_query->max_num_pages;
         if(!$pages)
         {
             $pages = 1;
         }
     }

     if(1 != $pages)
     {
         echo "<ul class='pagination'>";
         if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<li><a href='".get_pagenum_link(1)."'>&laquo;</a></li>";
         if($paged > 1 && $showitems < $pages) echo "<li><a href='".get_pagenum_link($paged - 1)."'>Previous</a></li>";

         for ($i=1; $i <= $pages; $i++)
         {
             if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))
             {
                 echo ($paged == $i)? "<li><a class='current'>".$i."</a></li>":"<li><a href='".get_pagenum_link($i)."' class='inactive' >".$i."</a></li>";
             }
         }

         if ($paged < $pages && $showitems < $pages) echo "<li><a href='".get_pagenum_link($paged + 1)."'>Next</a></li>";
         if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<li><a href='".get_pagenum_link($pages)."'>&raquo;</a></li>";
         echo "</ul>\n";
     }
}

/*-------------------------------------------------------------------------
  END CONCIERGE CUSTOM PAGINATION
------------------------------------------------------------------------- */



class faqsaas_nav_walker extends Walker_Nav_Menu{

    /**
     * Starts the list before the elements are added.
     *
     * @see Walker::start_lvl()
     *
     * @since 3.0.0
     *
     * @param string $output Passed by reference. Used to append additional content.
     * @param int    $depth  Depth of menu item. Used for padding.
     * @param array  $args   An array of arguments. @see wp_nav_menu()
     */
    function start_lvl( &$output, $depth = 0, $args = array() ) {
        $indent = str_repeat("\t", $depth);
        $output .= "\n$indent<ul class=\"dropdown-menu \">\n";
    }



    function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0){
        global $wp_query,$wpdb;
        $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

        $class_names = $value = '';

        $classes = empty( $item->classes ) ? array() : (array) $item->classes;

        $has_children = 0;
        if ( in_array('menu-item-has-children', $classes ) ){
            $has_children = 1;
        }

        if ( $has_children > 0 ){
            array_push( $classes, "dropdown" );
        }
        //current-menu-ancestor

        extract(faqsaas_extract_option_data(array(
            'highlighted_item' => array('', 'faqsaas_highlighted_menu' ),
        )));

        if($item->object_id == $highlighted_item){
            array_push( $classes, "faqsaas-highlight-item" );
        }

        if (in_array('current-menu-item', $classes, true) || in_array('current_page_item', $classes, true) || in_array('current-menu-ancestor', $classes, true) ) {
            $classes = array_diff($classes, array('current-menu-item', 'current_page_item', 'active'));

            array_push( $classes, "active" );
        }


        $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
        $class_names = ' class="'. esc_attr( $class_names ) . '"';



        $output .= $indent . '<li id="menu-item-'. $item->ID . '"' . $value . $class_names .'>';

        $attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
        $attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
        $attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';

        if($item->hash == 1){
          $attributes .= ' href="'.get_site_url().'/#'. esc_attr( $item->subtitle ).'"';
        }else{
          $attributes .= ! empty( $item->url )        ? ' href="'. esc_attr( $item->url) .'"' : '';
        }


        if ( $has_children > 0 )
        {
            $attributes .= ' class="dropdown-toggle"';
            $attributes .= ' data-toggle="dropdown"';
            $attributes .= ' role="button"';
            $attributes .= ' aria-haspopup="true"';
            $attributes .= ' aria-expanded="false"';
        }


        $item_output = $args->before;
        $item_output .= '<a'. $attributes .'>';
        $item_output .= $args->link_before .apply_filters( 'the_title', $item->title, $item->ID );
        $item_output .= $args->link_after;
        $item_output .= '</a>';
        $item_output .= $args->after;

        $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );

    }




    public static function fallback( $args ) {


        if ( current_user_can( 'manage_options' ) ) {

            extract( $args );

            $fb_output = null;

            if ( $container ) {
                $fb_output = '<' . $container;

                if ( $container_id )
                    $fb_output .= ' id="' . $container_id . '"';

                if ( $container_class )
                    $fb_output .= ' class="' . $container_class . '"';

                $fb_output .= '>';
            }

            $fb_output .= '<ul';

            if ( $menu_id )
                $fb_output .= ' id="' . $menu_id . '"';

            if ( $menu_class )
                $fb_output .= ' class="faqsaas-initial-menu ' . $menu_class . '"';

            $fb_output .= '>';
            $fb_output .= '<li class="faqsaas-initial-menu-item"><a href="' . admin_url( 'nav-menus.php' ) . '">Add a menu</a></li>';
            $fb_output .= '</ul>';

            if ( $container )
                $fb_output .= '</' . $container . '>';

            echo $fb_output;
        }
    }



}

/*-------------------------------------------------------------------------
  END CONCIERGE MAIN WALKER NAV LEFT MENU
------------------------------------------------------------------------- */


if( !function_exists('faqsaas_background_css') ) :

    /**
    * show copyright background image or color
    *
    * @since  1.0.0
    * @access public
    * @param  null
    * @return string
    */
    function faqsaas_background_css( $bg_key = null, $args = array() ){

        $defaults = array(
            'bg_color'   => '000',
            'bg_image'   => '',
            'bg_repeat'  => 'repeat-x',
            'bg_size'    => 'cover',
            'bg_position'=> 'center center',
            'bg_attach'  => 'scroll'
        );

        $args = wp_parse_args( $args, $defaults );

        extract(faqsaas_extract_option_data(array(
            'bg_color' => array( $args['bg_color'], $bg_key, 'background-color'),
            'bg_image' => array( $args['bg_image'], $bg_key, 'background-image'),
            'bg_repeat' => array( $args['bg_repeat'], $bg_key, 'background-repeat'),
            'bg_size' => array( $args['bg_size'], $bg_key, 'background-size'),
            'bg_pos' => array( $args['bg_position'], $bg_key, 'background-position'),
            'bg_attach' => array( $args['bg_attach'], $bg_key, 'background-attachment'),
        )));


        if($bg_image) :
            $style = "background-image: url($bg_image);
                    background-color: $bg_color;
                    background-repeat: $bg_repeat;
                    -webkit-background-size: $bg_size;
                    background-size: $bg_size;
                    background-position: $bg_pos;
                    background-attachment: $bg_attach;";
        else:
            $style = "
                    background-color: $bg_color;
                    background-repeat: $bg_repeat;
                    -webkit-background-size: $bg_size;
                    background-size: $bg_size;
                    background-position: $bg_pos;
                    background-attachment: $bg_attach;";
        endif;

        return $style;
    };

endif;





if(!function_exists('faqsaas_redux_option_data')) :

    /**
     * Enqueue css and js files
     *
     * @version 1.0.0
     * @since 1.0.0
     * @access public
     * @param string $key key name that will be checked
     * @param string $fallback default value
     * @return string
     */
    function faqsaas_redux_option_data($key, $fallback, $sub_key=''){
        global $faqsaas_option_data;
        $option_data = $faqsaas_option_data;

        if(!empty($sub_key)){
            if (isset($option_data[$key][$sub_key]) && !empty($option_data[$key][$sub_key])){
                return $option_data[$key][$sub_key];
            }
        }else{
            if (isset($option_data[$key]) && !empty($option_data[$key])){
                return $option_data[$key];
            }
        }
        return $fallback;
    }

endif;


if(!function_exists('faqsaas_extract_option_data')) :

    /**
     * Split options
     *
     *
     *
     * Call this function in following ways
     *
     * 1.  extract(
     *      faqsaas_extract_option_data(
     *          array(
     *            'Your_variable_name' = array ('default_value', 'main_ara_key', 'main_ara_sub_key'),
     *         )
     *      )
     *     );
     *
     *
     *
     * @version 1.0.1
     * @since 1.0.1
     * @var Array $helper
     * @access public
     */
    function faqsaas_extract_option_data($helper) {
        foreach ($helper as $option_key => $option_fallback) {
            if(is_array($option_fallback)){
                $fallback = $option_fallback[0];
                $main_key = array_key_exists(1, $option_fallback) ? $option_fallback[1] : '';
                $sub_key = array_key_exists(2, $option_fallback) ? $option_fallback[2] : '';
                $helper[$option_key] =  faqsaas_redux_option_data($main_key, $fallback, $sub_key);
            }else{
                $helper[$option_key] =  faqsaas_redux_option_data($option_key, $option_fallback, '');
            }
        }

        return $helper;
    }

endif;




if( !function_exists('faqsaas_page_background') ) :

    /**
    * show copyright background image or color
    *
    * @since  1.0.0
    * @access public
    * @param  null
    * @return string
    */
    function faqsaas_page_background( $args = array() ){

        $defaults = array(
            'bg_color'   => '#000',
            'bg_image'   => '',
            'bg_repeat'  => 'repeat-x',
            'bg_size'    => 'cover',
            'bg_position'=> 'center center',
            'bg_attach'  => 'scroll'
        );

        $args = wp_parse_args( $args, $defaults ) ;
        extract($args);

        $style = "background-image: url($bg_image) ; background-color: $bg_color; background-repeat: $bg_repeat; -webkit-background-size: $bg_size; background-size: $bg_size; background-position: $bg_position; background-attachment: $bg_attach;";

        return $style;
    };

endif;




if(!function_exists('faqsaas_page_meta_data')) :

    /**
     * Enqueue css and js files
     *
     * @version 1.0.0
     * @since 1.0.0
     * @access public
     * @param string $key key name that will be checked
     * @param string $fallback default value
     * @return string
     */
    function faqsaas_page_meta_data($key, $fallback, $sub_key=''){

        $meta_value = get_post_meta( get_the_ID(), $key, true);
        if(!empty($sub_key)){
            if (isset($meta_value) && !empty($meta_value)){
                return $meta_value;
            }
        }else{
            if (isset($meta_value) && !empty($meta_value)){
                return $meta_value;
            }
        }

        return $fallback;
    }

endif;


if(!function_exists('faqsaas_extract_page_meta_data')) :

    /**
     * Split options
     *
     *
     *
     * Call this function in following ways
     *
     * 1.  extract(
     *      faqsaas_extract_page_meta_data(
     *          array(
     *            'Your_variable_name' = array ('default_value', 'main_ara_key', 'main_ara_sub_key'),
     *         )
     *      )
     *     );
     *
     *
     *
     * @version 1.0.1
     * @since 1.0.1
     * @var Array $helper
     * @access public
     */
    function faqsaas_extract_page_meta_data($helper) {
        foreach ($helper as $option_key => $option_fallback) {
            if(is_array($option_fallback)){
                $fallback = $option_fallback[0];
                $main_key = array_key_exists(1, $option_fallback) ? $option_fallback[1] : '';
                $sub_key = array_key_exists(2, $option_fallback) ? $option_fallback[2] : '';
                $helper[$option_key] =  faqsaas_page_meta_data($main_key, $fallback, $sub_key);
            }else{
                $helper[$option_key] =  faqsaas_page_meta_data($option_key, $option_fallback, '');
            }
        }

        return $helper;
    }

endif;





class faqsaas_forum_menu extends Walker_Nav_Menu{

    /**
     * Starts the list before the elements are added.
     *
     * @see Walker::start_lvl()
     *
     * @since 3.0.0
     *
     * @param string $output Passed by reference. Used to append additional content.
     * @param int    $depth  Depth of menu item. Used for padding.
     * @param array  $args   An array of arguments. @see wp_nav_menu()
     */
    function start_lvl( &$output, $depth = 0, $args = array() ) {
        $indent = str_repeat("\t", $depth);
        $output .= "\n$indent<ul class=\"dropdown-menu \">\n";
    }



    function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0){


        global $wp_query,$wpdb;


        $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

        $class_names = $value = '';

        $classes = empty( $item->classes ) ? array() : (array) $item->classes;

        $key = '_menu_item_menu_item_parent';

        $has_children = $wpdb -> get_var( $wpdb->prepare("SELECT COUNT(meta_id) FROM {$wpdb->prefix}postmeta WHERE meta_key= %s AND meta_value= %d ", $key, $item->ID  ));


        if ( $has_children > 0 )
        {
            array_push( $classes, "dropdown" );
        }
        //current-menu-ancestor

        if (in_array('current-menu-item', $classes, true) || in_array('current_page_item', $classes, true) || in_array('current-menu-ancestor', $classes, true) ) {
            $classes = array_diff($classes, array('current-menu-item', 'current_page_item', 'active'));

            array_push( $classes, "active" );
        }


        $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
        $class_names = ' class="'. esc_attr( $class_names ) . '"';



        $output .= $indent . '<li id="menu-item-'. $item->ID . '"' . $value . $class_names .'>';

        $attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
        $attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
        $attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';

        if($item->hash == 1){
          $attributes .= ' href="'.get_site_url().'/#'. esc_attr( $item->subtitle ).'" id="menu-item-'. $item->ID . '" ';
        }else{
          $attributes .= ! empty( $item->url )        ? ' href="'. esc_attr( $item->url) .'"' : '';
        }


        $item_output = $args->before;
        $item_output .= '<a'. $attributes .'>';
        $item_output .= $args->link_before .apply_filters( 'the_title', $item->title, $item->ID );
        $item_output .= $args->link_after;
        $item_output .= '</a>';
        $item_output .= $args->after;

        $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );

    }




    public static function fallback( $args ) {


        if ( current_user_can( 'manage_options' ) ) {

            extract( $args );

            $fb_output = null;

            if ( $container ) {
                $fb_output = '<' . $container;

                if ( $container_id )
                    $fb_output .= ' id="' . $container_id . '"';

                if ( $container_class )
                    $fb_output .= ' class="' . $container_class . '"';

                $fb_output .= '>';
            }

            $fb_output .= '<ul';

            if ( $menu_id )
                $fb_output .= ' id="' . $menu_id . '"';

            if ( $menu_class )
                $fb_output .= ' class="container ' . $menu_class . '"';

            $fb_output .= '>';
            $fb_output .= '<li class="faqsaas-add-a-menu"><a href="' . admin_url( 'nav-menus.php' ) . '">Add a menu</a></li>';
            $fb_output .= '</ul>';

            if ( $container )
                $fb_output .= '</' . $container . '>';

            echo $fb_output;
        }
    }



}

/*-------------------------------------------------------------------------
  END CONCIERGE MAIN WALKER NAV LEFT MENU
------------------------------------------------------------------------- */





if( !function_exists('faqsaas_allowed_tags') ) :

    function faqsaas_allowed_tags(){
        $allowedtags = array(
            'a' => array( 'href' => array(), 'title' => array(), 'target' => array() ),
            'abbr' => array( 'title' => array() ), 'acronym' => array( 'title' => array() ),
            'code' => array(), 'pre' => array(), 'em' => array(), 'strong' => array(),
            'div' => array( 'class' => array() ), 'span' => array( 'class' => array() ),
            'p' => array(), 'ul' => array(), 'ol' => array(), 'li' => array(),
            'h1' => array(), 'h2' => array(), 'h3' => array(), 'h4' => array(), 'h5' => array(), 'h6' => array(),
            'img' => array( 'src' => array(), 'class' => array(), 'alt' => array() )
        );

      return $allowedtags;
    }

endif;


function faqsaas_nav_markup_template($template, $class){
    $template = '<nav class="navigation %1$s">
                        <h2 class="screen-reader-text">%2$s</h2>
                        <div class="nav-links">%3$s</div>
                </nav>';
    return $template;
}


add_filter('navigation_markup_template', 'faqsaas_nav_markup_template', 10, 2);
