<?php
 /**
  * Widget API: faqsaas_Contact_Widget class
  *
  * @package WordPress
  * @subpackage Widgets
  * @since 4.4.0
  */

 /**
  * Core class used to implement a Pages widget.
  *
  * @since 2.8.0
  *
  * @see WP_Widget
  */
 class Faqsaas_Contact_Widget extends WP_Widget {

     /**
      * Sets up the widgets name:  faqsaas Recent Posts
      */
     public function __construct() {
         $widget_ops = array(
             'classname' => 'faqsaas_company_info',
             'description' => 'FaqSaas Recent Posts Widgets for Footer Area',
         );
         parent::__construct( 'faqsaas_company_info', 'About FaqSaas', $widget_ops );
     }

     /**
      * Outputs the content of the widget
      *
      * @param array $args
      * @param array $instance
      */
     public function widget( $args, $instance ) {
         $title = apply_filters(
             'widget_title',
             empty( $instance['title'] ) ? '' : $instance['title'], $instance,
             $this->id_base
         );
         $email = apply_filters(
             'widget_title',
             empty( $instance['email'] ) ? '' : $instance['email'], $instance,
             $this->id_base
         );
         $phone = apply_filters(
             'widget_title',
             empty( $instance['phone'] ) ? '' : $instance['phone'], $instance,
             $this->id_base
         );
         $address = apply_filters(
             'widget_title',
             empty( $instance['address'] ) ? '' : $instance['address'], $instance,
             $this->id_base
         );
         $widget_text = ! empty( $instance['content'] ) ? $instance['content'] : '';
         $content = apply_filters( 'widget_text', $widget_text, $instance, $this );

         echo $args['before_widget'];
         if ( ! empty( $title ) ) {
             echo $args['before_title'] . $title . $args['after_title'];
         }
     ?>

         <ul class="contact-info has-bg-image contain">
            <li>
             <?php if ( ! empty( $instance['image'] ) ) { ?>
                 <a href="<?php echo esc_url(home_url( '/' )); ?>" class="logo"><img src="<?php echo esc_url($instance['image']); ?>" alt=""></a>
             <?php } ?>
            </li>

            <li>
                <i class="fa fa-map-marker"></i>
                <address> <?php echo !empty( $instance['filter'] ) ? wpautop( $address ) : $address; ?></address>
            </li>

            <li>
                <i class="fa fa-phone"></i>
                <a href="<?php echo !empty( $instance['filter'] ) ? $phone : $phone; ?>"><?php echo !empty( $instance['filter'] ) ? wpautop( $phone ) : $phone; ?></a>
            </li>

            <li>
                <i class="fa fa-envelope"></i>
                <a href="<?php echo !empty( $instance['filter'] ) ? $email : $email; ?>"><?php echo !empty( $instance['filter'] ) ? wpautop( $email ) : $email; ?></a>
            </li>

            <li class="description">
                <?php echo !empty( $instance['filter'] ) ? wpautop( $content ) : $content; ?>
            </li>
         </ul>



     <?php
         echo $args['after_widget'];
     }
     /**
      * Processing widget options on save
      *
      * @param array $new_instance The new options
      * @param array $old_instance The previous options
      */
     public function update( $new_instance, $old_instance ) {
         $instance = $old_instance;
         $instance['title']      = sanitize_text_field( $new_instance['title'] );
         $instance['email']      = sanitize_text_field( $new_instance['email'] );
         $instance['phone']      = sanitize_text_field( $new_instance['phone'] );
         $instance['address']    = sanitize_text_field( $new_instance['address'] );
         $instance['image']      = strip_tags($new_instance['image']);
         if ( current_user_can( 'unfiltered_html' ) ) {
             $instance['content'] = $new_instance['content'];
         } else {
             $instance['content'] = wp_kses_post( $new_instance['content'] );
         }
         $instance['filter'] = ! empty( $new_instance['filter'] );
         return $instance;
     }
     /**
      * Outputs the options form on admin
      *
      * @param array $instance The widget options
      */
     public function form( $instance ) {
         $instance = wp_parse_args(
             (array) $instance,
             array(
                 'title'     =>  '',
                 'content' =>    '',
                 'email'     =>  '',
                 'phone'     =>  '',
                 'address'   =>  ''
             )
         );
         $filter     = isset( $instance['filter'] ) ? $instance['filter'] : 0;
         $title      = sanitize_text_field( $instance['title'] );
         $content    = sanitize_text_field( $instance['content'] );
         $email      = sanitize_text_field( $instance['email'] );
         $phone      = sanitize_text_field( $instance['phone'] );
         $address    = sanitize_text_field( $instance['address'] );
         $image = '';
         if(isset($instance['image'])) {
           $image = $instance['image'];
         }
     ?>
         <p>
             <label for="<?php echo $this->get_field_id('title'); ?>">
                 <?php echo esc_html__('Title:','faqsaas'); ?>
             </label>
             <input
                 class="widefat"
                 id="<?php echo $this->get_field_id('title'); ?>"
                 name="<?php echo $this->get_field_name('title'); ?>"
                 type="text"
                 value="<?php echo esc_attr($title); ?>"
             />
         </p>
         <p>
             <label for="<?php echo $this->get_field_id('address'); ?>">
                 <?php echo esc_html__('Address:','faqsaas'); ?>
             </label>
             <input
                 class="widefat"
                 id="<?php echo $this->get_field_id('address'); ?>"
                 name="<?php echo $this->get_field_name('address'); ?>"
                 type="text"
                 value="<?php echo esc_attr($address); ?>"
             />
         </p>
         <p>
             <label for="<?php echo $this->get_field_id('email'); ?>">
                 <?php echo esc_html__('Email Address:','faqsaas'); ?>
             </label>
             <input
                 class="widefat"
                 id="<?php echo $this->get_field_id('email'); ?>"
                 name="<?php echo $this->get_field_name('email'); ?>"
                 type="text"
                 value="<?php echo esc_attr($email); ?>"
             />
         </p>
         <p>
             <label for="<?php echo $this->get_field_id('phone'); ?>">
                 <?php echo esc_html__('Phone/Cell Number:','faqsaas'); ?>
             </label>
             <input
                 class="widefat"
                 id="<?php echo $this->get_field_id('phone'); ?>"
                 name="<?php echo $this->get_field_name('phone'); ?>"
                 type="text"
                 value="<?php echo esc_attr($phone); ?>"
             />
         </p>
         <p>
             <label for="<?php echo $this->get_field_id( 'content' ); ?>">
                 <?php echo esc_html__( 'Content:','faqsaas' ); ?>
             </label>
             <textarea
                 class="widefat"
                 rows="10"
                 cols="10"
                 id="<?php echo $this->get_field_id('content'); ?>"
                 name="<?php echo $this->get_field_name('content'); ?>">
                 <?php echo esc_textarea( $instance['content'] ); ?>
             </textarea>
         </p>
         <p>
             <label for="<?php echo $this->get_field_name( 'image' ); ?>">
                 <?php echo esc_html_e( 'Image:', 'faqsaas' ); ?>
             </label>
             <input
                 name="<?php echo $this->get_field_name( 'image' ); ?>"
                 id="<?php echo $this->get_field_id( 'image' ); ?>"
                 class="widefat image_link"
                 type="text"
                 size="36"
                 value="<?php echo esc_url( $image ); ?>"
             />
           <input class="upload_image_button" type="button" value="Upload Image" />
         </p>
         <p>
             <input
                 id="<?php echo $this->get_field_id('filter'); ?>"
                 name="<?php echo $this->get_field_name('filter'); ?>"
                 type="checkbox"<?php checked( $filter ); ?>
             />
             &nbsp;
             <label for="<?php echo $this->get_field_id('filter'); ?>">
                 <?php echo esc_html_e('Automatically add paragraphs', 'faqsaas'); ?>
             </label>
         </p>
     <?php
     }

 }


 add_action('widgets_init', 'faqsaas_contact_widget');

 function faqsaas_contact_widget(){
     register_widget('Faqsaas_Contact_Widget');
 }


