<?php
/**
 * Widget API: Moticv_Categories class
 *
 * @package WordPress
 * @subpackage Widgets
 * @since 4.4.0
 */

/**
 * Core class used to implement a Pages widget.
 *
 * @since 2.8.0
 *
 * @see WP_Widget
 */
class Moticv_Categories extends WP_Widget {

    /**
     * Sets up the widgets name:  faqsaas Category Widget
     */
    public function __construct() {
        $widget_ops = array(
            'classname' => 'faqsaas_widget_categories',
            'description' => esc_html__( 'A list or dropdown of categories.','faqsaas' )
        );
        parent::__construct( 'faqsaas_widget_categories', esc_html__( 'FaqSaas Categories', 'faqsaas' ), $widget_ops );
    }
    /**
     * Outputs the content of the widget
     *
     * @param array $args
     * @param array $instance
     */
    public function widget( $args, $instance ) {
        static $first_dropdown = true;
        $title = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
        $view  = empty($instance['view_layer']) ? '' : $instance['view_layer'];
        $cat_number = !empty( $instance['number'] )  ? (int) $instance['number'] : 5;
        if ( !$cat_number )
            $cat_number = 5;

        echo $args['before_widget'];
        
        if ( $title ) {
            echo $args['before_title'] . esc_attr($title). $args['after_title'];
        } 
    ?>
      
        <div class="widget-categories">
            <ul class="tags-list">
                <?php
                    $categories = get_categories( array(
                        'orderby'   => 'name',
                        'order'         => $view,
                        'number'        => $cat_number,
                    ) );

                    foreach( $categories as $category ) {
                        echo '<li>
                                <a href="'. esc_url( get_category_link( $category->term_id ) ).'">'
                                    .esc_attr( $category->name ).
                                    '<span>('.$category->count.')</span>
                                </a>
                            </li> ';
                    } 
                ?>
            </ul>
        </div>
        
        <?php echo $args['after_widget'];

    }
    /**
     * Processing widget options on save
     *
     * @param array $new_instance The new options
     * @param array $old_instance The previous options
     */
    public function update( $new_instance, $old_instance ) {
        $instance                               = $old_instance;
        $instance['title']              = sanitize_text_field( $new_instance['title'] );
        $instance['number']             = (int) $new_instance['number'];
        $instance['view_layer']     = $new_instance['view_layer'];
        return $instance;
    }
    /**
     * Outputs the options form on admin
     *
     * @param array $instance The widget options
     */
    public function form( $instance ) {
        $instance           = wp_parse_args( (array) $instance, array( 'title' => '') );
        $title                  = sanitize_text_field( $instance['title'] );
        $cat_number     = !empty( $instance['number'] ) ? absint( $instance['number'] ) : 5;
        $view_layer         = isset( $instance['view_layer'] ) ? $instance['view_layer'] : '';
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">
                <?php echo esc_html_e( 'Title:', 'faqsaas' ); ?>
            </label>
            <input 
                class="widefat" 
                id="<?php echo $this->get_field_id('title'); ?>" 
                name="<?php echo $this->get_field_name('title'); ?>" 
                type="text" 
                value="<?php echo esc_attr( $title ); ?>" 
            />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('text'); ?>">
                <?php echo esc_html__( 'Choose Order :', 'faqsaas' ); ?>
              <select class='widefat' id="<?php echo $this->get_field_id('view_layer'); ?>"
                      name="<?php echo $this->get_field_name('view_layer'); ?>" type="text">
               <option value='ASC'<?php echo ($view_layer === 'ASC')?'selected':''; ?>>
                  <?php echo esc_html__( 'ASC order', 'faqsaas' ); ?>
                </option>
                <option value='DESC'<?php echo ($view_layer === 'DESC')?'selected':''; ?>>
                    <?php echo esc_html__( 'DESC order', 'faqsaas' ); ?>
                </option>
              </select>                
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id( 'number' ); ?>">
                <?php echo esc_html_e( 'Number of Category to show:', 'faqsaas' ); ?>
            </label>
            <input 
                class="tiny-text" 
                id="<?php echo $this->get_field_id('number'); ?>" 
                name="<?php echo $this->get_field_name('number'); ?>" 
                type="number" 
                step="1" 
                min="1" 
                value="<?php echo $cat_number;?>"
            />
        </p>
        <?php
    }
}

add_action('widgets_init', 'moticv_categories');

function moticv_categories(){

    register_widget('Moticv_Categories');

}




