<?php
/**
 * Include the TGM_Plugin_Activation class.
 */
require_once( get_template_directory() . '/framework/uoulib/class-tgm-plugin-activation.php');
add_action( 'tgmpa_register', 'moticv_theme_register_required_plugins' );

function moticv_theme_register_required_plugins() {

    /**
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     */
    $plugins = array(

        array(
            'name'      => 'Easy Twitter Feed Widget',
            'slug'      => 'easy-twitter-feed-widget',
            'required'  => true,
        ),

        array(
            'name'               => 'FaqSaas Demo Importer',
            'slug'               => 'faqsaas-demo-importer',
            'source'             => get_stylesheet_directory() . '/framework/ext/plugins/faqsaas-demo-importer.zip',
            'required'           => true,
            'version'            => '',
            'force_activation'   => false,
            'external_url'       => '',
        ),

        array(
            'name'               => 'FaqSaas Plugin',
            'slug'               => 'faqsaas-plugin',
            'source'             => get_stylesheet_directory() . '/framework/ext/plugins/faqsaas-plugin.zip',
            'required'           => true,
            'version'            => '',
            'force_activation'   => false,
            'external_url'       => '',
        ),

        array(
            'name'               => 'Memberships Pro',
            'slug'               => 'paid-memberships-pro',
            'source'             => get_stylesheet_directory() . '/framework/ext/plugins/paid-memberships-pro.zip',
            'required'           => true,
            'version'            => '',
            'force_activation'   => false,
            'external_url'       => '',
        ),

        array(
            'name'               => 'DW Questions & Answers',
            'slug'               => 'dw-question-answer',
            'source'             => get_stylesheet_directory() . '/framework/ext/plugins/dw-question-answer.zip',
            'required'           => true,
            'version'            => '',
            'force_activation'   => false,
            'external_url'       => '',
        ),

    );



    $config = array(
        'id'           => 'xxlpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '',                      // Default absolute path to pre-packaged plugins.
        'menu'         => 'xxlpa-install-plugins', // Menu slug.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => true,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
        'strings'      => array(
            'page_title'                      => esc_html__( 'Install Required Plugins', 'faqsaas' ),
            'menu_title'                      => esc_html__( 'Install Plugins', 'faqsaas' ),
            'installing'                      => esc_html__( 'Installing Plugin: %s', 'faqsaas' ), // %s = plugin name.
            'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'faqsaas' ),
            'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'faqsaas' ), // %1$s = plugin name(s).
            'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'faqsaas' ), // %1$s = plugin name(s).
            'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'faqsaas' ), // %1$s = plugin name(s).
            'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'faqsaas' ), // %1$s = plugin name(s).
            'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'faqsaas' ), // %1$s = plugin name(s).
            'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'faqsaas' ), // %1$s = plugin name(s).
            'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'faqsaas' ), // %1$s = plugin name(s).
            'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'faqsaas' ), // %1$s = plugin name(s).
            'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'faqsaas' ),
            'activate_link'                   => _n_noop( 'Begin activating plugin', 'Begin activating plugins', 'faqsaas' ),
            'return'                          => esc_html__( 'Return to Required Plugins Installer', 'faqsaas' ),
            'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'faqsaas' ),
            'complete'                        => esc_html__( 'All plugins installed and activated successfully. %s', 'faqsaas' ), // %s = dashboard link.
            'nag_type'                        => 'updated' // Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
        )
    );

    tgmpa( $plugins, $config );
}