<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after
 *
 * @package WordPress
 * @subpackage FAQ_SAAS
 * @since FaqSaas 1.0
 */
?>
        </div><!-- container -->
    </div><!-- .site-content -->

        <?php

            // Footer background
            $args = array(
                'bg_color'   => '#1a1a1a',
                'bg_image'   => '',
                'bg_repeat'  => 'repeat-x',
                'bg_size'    => 'cover',
            );
            $footer_bg = faqsaas_background_css( 'faqsaas_footer_background', $args );

            // Copyright background
            $args = array(
                'bg_color'   => '#000',
                'bg_image'   => '',
                'bg_repeat'  => 'repeat-x',
                'bg_size'    => 'cover',
            );
            $copyright_bg = faqsaas_background_css( 'faqsaas_copyright_background', $args );

            $htmls = faqsaas_allowed_tags();
            extract(faqsaas_extract_option_data(array(
                'show_copyright' => array('yes', 'faqsaas_show_copyright'),
                'copyright_text' => array('', 'faqsaas_copyright_text'),
            )));

         ?>

        <footer> <!-- custom footer start herer -->
            <div class="uou-block-4e secondary" style="<?php echo esc_attr($footer_bg); ?>">
                <div class="container">
                    <div class="row">
                        <?php
                            if(is_active_sidebar('footer_widgets')) :
                                dynamic_sidebar('footer_widgets');
                            endif;
                         ?>
                    </div>
                </div>
            </div> <!-- end .uou-block-4e -->

            <?php if($show_copyright && $show_copyright === 'yes' ) : ?>
                <div class="rights" style="<?php echo esc_attr($copyright_bg); ?>">
                    <p> <?php echo wp_kses($copyright_text, $htmls); ?> </p>
                </div>
            <?php endif; ?>

        </footer>

	</div><!-- .site-inner -->
</div><!-- .site -->

<?php wp_footer(); ?>
</body>
</html>
