<?php

/**
 * Theme options /Header
 *
 * @package vamtam/f7
 */


if ( VamtamElementorBridge::is_elementor_pro_active() ) {
	return [];
}

return array(

	array(
		'label'       => esc_html__( 'Header Height', 'f7' ),
		'description' => esc_html__( 'This is the area above the slider. Includes the height of the menu for two line header layouts.', 'f7' ),
		'id'          => 'header-height',
		'type'        => 'number',
		'compiler'    => true,
		'transport'   => 'postMessage',
		'input_attrs' => array(
			'min' => 30,
			'max' => 300,
		),
	),

	array(
		'label'       => esc_html__( 'Header Background', 'f7' ),
		'description' => esc_html__( 'If you want to use an image as a background, enabling the cover button will resize and crop the image so that it will always fit the browser window on any resolution.', 'f7' ),
		'id'          => 'header-background',
		'type'        => 'background',
		'compiler'    => true,
		'transport'   => 'postMessage',
		'show'        => array(
			'background-position' => false,
		),
	),

	array(
		'label'     => esc_html__( 'Page Title Background', 'f7' ),
		'id'        => 'page-title-background',
		'type'      => 'background',
		'compiler'  => true,
		'transport' => 'postMessage',
		'show'      => array(
			'background-attachment' => false,
			'background-position'   => false,
		),
	),
);


