<?php
$post_id = get_the_ID();
$theme_video_meta = get_post_meta($post_id, 'theme_postvideo_options', true);

$video_type = '';
$video_url  = '';

// Determine video type and URL
if (!empty($theme_video_meta['youtubtextm'])) {
    $video_type = 'youtube';
    $video_url  = $theme_video_meta['youtubtextm'];
} elseif (!empty($theme_video_meta['venomtextm'])) {
    $video_type = 'vimeo';
    $video_url  = $theme_video_meta['venomtextm'];
} elseif (!empty($theme_video_meta['selftextm'])) {
    $video_type = 'self';
    $video_url  = $theme_video_meta['selftextm'];
}

$video_url = esc_url($video_url);

$hover_enabled = true;

// Single page hover off, but Elementor editor/preview hover on
if (is_singular() ) {
    $hover_enabled = true;
}

// Single page hover off, but Elementor editor/preview hover on
if (is_single() ) {
    $hover_enabled = false;
}

?>

<?php if($video_type && errin_is_activated()): ?>

    <?php if($video_type === 'youtube'): ?>
        <div class="plyr__video-embed video-container youtube-player" data-hover-play="<?php echo $hover_enabled ? 'true' : 'false'; ?>">
            <iframe 
                src="<?php echo $video_url; ?>" 
                allowfullscreen 
                allow="autoplay; encrypted-media" 
                referrerpolicy="no-referrer"
                sandbox="allow-scripts allow-same-origin allow-popups"
            ></iframe>
        </div>

    <?php elseif($video_type === 'vimeo'): ?>
        <div class="plyr__video-embed video-container vimeo-player" data-hover-play="<?php echo $hover_enabled ? 'true' : 'false'; ?>">
            <iframe 
                src="<?php echo $video_url; ?>" 
                allowfullscreen 
                allow="autoplay; encrypted-media"
                referrerpolicy="no-referrer"
                sandbox="allow-scripts allow-same-origin allow-popups"
            ></iframe>
        </div>

    <?php elseif($video_type === 'self'): ?>
        <video class="video-container html5-player" muted playsinline preload="auto" data-hover-play="<?php echo $hover_enabled ? 'true' : 'false'; ?>">
            <source src="<?php echo $video_url; ?>" type="video/mp4">
        </video>
    <?php endif; ?>

<?php else: ?>
    <a href="<?php the_permalink(); ?>" class="home-top-thumbnail-one">
        <img src="<?php echo esc_url(get_the_post_thumbnail_url($post_id, 'full')); ?>" alt="<?php the_title_attribute(); ?>">
    </a>
<?php endif; ?>
