<?php
$format = get_post_format();
$theme_audio_meta = get_post_meta(get_the_ID(), 'theme_postaudio_options', true);
$cat = get_the_category();

if(!empty($theme_audio_meta && errin_is_activated())){
    if ( ! empty( $cat ) ) {
        foreach ( $cat as $category ) {
            $meta = get_term_meta( $category->term_id, 'errin', true );

            if ( ! empty( $meta['cat-color'] ) ) {
                $cat_color = $meta['cat-color'];
            }
            // class name will be without #
            $cat_class = 'audio-cat-' . ltrim( $cat_color, '#' );
            if ( empty( $cat_color ) ) {
        $cat_color = '#2c5475'; // default color (you can change this)
    }

            break; // only first category color used
        }
    }
    ?>
    <style>
        .<?php echo esc_attr( $cat_class ); ?> .plyr.plyr--audio .plyr__controls__item.plyr__control[data-plyr="play"] {
            display: block;
            background: <?php echo esc_attr( $cat_color ); ?>;
            border: 1px solid <?php echo esc_attr( $cat_color ); ?>;
            color: #fff;
        }
        .<?php echo esc_attr( $cat_class ); ?> .plyr.plyr--audio .plyr__controls__item.plyr__control[data-plyr="play"]:hover {
            background: transparent;
            color: <?php echo esc_attr( $cat_color ); ?>;
        }
    </style>
<?php
} ?>


<?php
if(!empty($theme_audio_meta && errin_is_activated())){
?>

<div class="player-container <?php echo esc_attr( $cat_class ); ?>">

    <div class="errin-audio__text-wrapper">

        <img src="https://seussblog.files.wordpress.com/2013/03/143056e8473127ab6a665773884132bc.jp" class="cover-art" alt="Cover Art" id="coverArt">

        <div class="track-info">
            <h2 id="trackTitle">Select a track</h2>
            <p id="trackArtist">-</p>
        </div>
    </div>


    <audio id="player" controls></audio>

    <ul class="playlist" id="playlist">
        <?php if (is_array($theme_audio_meta['opt-repeater-2'] ?? null)) : ?>
            <?php foreach ($theme_audio_meta['opt-repeater-2'] as $index => $item) :
                $title  = $item['audio_title']  ?? 'Untitled Track';
                $artist = $item['audio_artist'] ?? 'Unknown Artist';
                $audio  = $item['audio_text']   ?? '';
                $image  = $item['audio_link']   ?? '';
                ?>
                <li class="playlist-item"
                    data-id="<?php echo esc_attr($index); ?>"
                    data-image="<?php echo esc_url($image); ?>"
                    data-audio="<?php echo esc_url($audio); ?>">
                    <span class="track-title"><?php echo esc_html($title); ?></span>
                    <span class="artist"><?php echo __('By ','errin'); echo esc_html($artist); ?></span>
                </li>
            <?php endforeach; ?>
        <?php else : ?>
            <li>No audio data available.</li>
        <?php endif; ?>
    </ul>
</div>
<?php
}else{
    if (has_post_thumbnail() && !post_password_required()) : ?>
        <div class="post-featured-image">
            <?php if(errin_is_activated()) { ?>
                <img class="img-fluid" src="<?php echo esc_url(get_the_post_thumbnail_url()); ?>" alt="<?php the_title_attribute(); ?>">
            <?php } else { ?>
                <img src="<?php echo esc_url(get_the_post_thumbnail_url(null, 'full')); ?>" alt="<?php the_title_attribute(); ?>">
            <?php } ?>
        </div>
    <?php endif;
}
    ?>