<div class="main-content-inner">

    <?php while (have_posts()) : the_post(); ?>
        <div class="blog_post_layout_two_inner">
            <div <?php post_class('blog_post_layout_two'); ?>>

                <div class="latest-post-thumbnail-wrap">
                    <?php
                    $post_format = get_post_format();
                    if ($post_format === 'video') {
                        require ERRIN_THEME_DIR . '/template-parts/single/post-video.php';
                    } elseif ($post_format === 'audio') {
                        require ERRIN_THEME_DIR . '/template-parts/single/post-audio.php';
                    } elseif (errin_is_activated()) { ?>
                        <?php if (has_post_thumbnail()) { ?>
                            <a href="<?php the_permalink(); ?>" class="latest-post-block-thumbnail">
                                <img class="img-fluid" src="<?php echo esc_url(get_the_post_thumbnail_url()); ?>"
                                     alt="<?php the_title_attribute(); ?>">
                            </a>
                        <?php } ?>
                    <?php } else {
                        if (has_post_thumbnail()) {
                            ?>
                            <a href="<?php the_permalink(); ?>" class="latest-post-block-thumbnail">
                                <img src="<?php echo esc_attr(esc_url(get_the_post_thumbnail_url(null, 'full'))); ?>"
                                     alt="<?php the_title_attribute(); ?>">
                            </a>
                            <?php
                        }
                        ?>
                    <?php } ?>

                </div>

                <div class="blog_post_layout_two_content <?php if (has_post_thumbnail()) {
                    echo "has-featured-blog";
                } else {
                    echo "no-featured-blog";
                } ?>">

                    <div class="htbc_category">
                        <?php require ERRIN_THEME_DIR . '/template-parts/cat-color.php'; ?>
                    </div>
                    <h3 class="post-title">
                        <a href="<?php echo esc_url(get_the_permalink()); ?>"><?php echo get_the_title(); ?></a>
                    </h3>

                    <div class="post-single-custom-meta">
                        <div class="post-author-name">
                            <?php printf('%1$s<a href="%2$s">%3$s</a>',
                                get_avatar(get_the_author_meta('ID'), 32),
                                esc_url(get_author_posts_url(get_the_author_meta('ID'))),
                                get_the_author()
                            ); ?>

                        </div>
                        <div class="blog_details__Date">
                            <?php echo esc_html(get_the_date('F j, Y')); ?>
                        </div>
                        <div class="post-comment-count">
                            <i class="icon-messages-11"></i>
                            <?php echo get_comments_number(get_the_ID()); ?>
                        </div>
                    </div>

                    <div class="post-excerpt-box">
                        <p><?php echo esc_html(wp_trim_words(get_the_excerpt(), 16, '')); ?></p>
                    </div>


                </div>

            </div>

        </div>

    <?php endwhile; ?>

</div>