<?php
/*
 * Theme Options
 * @package Errin
 * @since 1.0.0
 * */

if (!defined('ABSPATH')) {
    exit(); // exit if access directly
}

if (class_exists('CSF')) {

    //
    // Set a unique slug-like ID
    $prefix = 'errin';

    //
    // Create options
    CSF::createOptions($prefix . '_theme_options', array(
        'menu_title' => esc_html__('Theme Option', 'errin'),
        'menu_slug' => 'errin-theme-option',
        'menu_type' => 'menu',
        'enqueue_webfont' => true,
        'show_footer' => false,
        'framework_title' => esc_html__('Errin Theme Options', 'errin'),
        'menu_capability' => 'manage_options',
        'menu_icon' => 'dashicons-welcome-widgets-menus',
        'menu_position' => null,
        'menu_hidden' => false,
        'menu_position' => '3',
        // menu extras
        'show_bar_menu' => true,
        'show_sub_menu' => true,
        'show_in_network' => true,
        'show_in_customizer' => false,

        'show_search' => true,
        'show_reset_all' => true,
        'show_reset_section' => true,
        'show_footer' => true,
        'show_all_options' => true,
        'show_form_warning' => true,
        'sticky_header' => true,
        'save_defaults' => true,
        'ajax_save' => true,

        // admin bar menu settings
        'admin_bar_menu_icon' => 'dashicons-list-view',
        'admin_bar_menu_priority' => 80,

        // footer
        'footer_text' => '',
        'footer_after' => '',
        'footer_credit' => '. Exclusive Options by itindeed',

        // database model
        'database' => '', // options, transient, theme_mod, network
        'transient_time' => 0,

        // contextual help
        'contextual_help' => array(),
        'contextual_help_sidebar' => '',

        // typography options
        'enqueue_webfont' => true,
        'async_webfont' => false,

        // others
        'output_css' => true,

        // theme and wrapper classname
        'theme' => 'dark',
        'class' => '',

        // external default values
        'defaults' => array(),
    ));

    //
    // Create a section
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('General', 'errin'),
        'icon' => 'fa fa-wrench',
        'fields' => array(

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Site Logo', 'errin') . '</h3>',
            ),

            array(
                'id' => 'theme_logo',
                'title' => esc_html__('Main Logo', 'errin'),
                'type' => 'media',
                'library' => 'image',
                'desc' => esc_html__('Upload Your Static Logo Image on Header Static', 'errin')
            ),


            array(
                'id' => 'logo_width',
                'type' => 'slider',
                'title' => esc_html__('Set Logo Width', 'errin'),
                'min' => 0,
                'max' => 300,
                'step' => 1,
                'unit' => 'px',
                'default' => 145,
                'desc' => esc_html__('Set Logo Width in px. Default Width 184px.', 'errin'),
                'output' => array(".theme-logo img"),
            ),


            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Preloader', 'errin') . '</h3>'
            ),


            array(
                'id' => 'preloader_enable',
                'title' => esc_html__('Enable Preloader', 'errin'),
                'type' => 'switcher',
                'desc' => esc_html__('Enable or Disable Preloader', 'errin'),
                'default' => true,
            ),

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Back Top Options', 'errin') . '</h3>'
            ),


            array(
                'id' => 'back_top_enable',
                'title' => esc_html__('Scroll Top Button', 'errin'),
                'type' => 'switcher',
                'desc' => esc_html__('Enable or Disable scroll button', 'errin'),
                'default' => true,
            ),

        )
    ));
    /*-------------------------------------------------------
        ** Entire Site Global Layout Option
      --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Layout', 'errin'),
        'id' => 'box_layout',
        'icon' => 'fa fa-th-large',
        'fields' => array(
            array(
                'id'    => 'select_layout',
                'type'  => 'switcher',
                'title' => 'Select Box Layout',
                'default'  => 0,
            ),
            array(
                'id'      => 'select_layout_box',
                'type'    => 'slider',
                'title'   => 'Box Width',
                'min'     => 0,
                'max'     => 1500,
                'step'    => 1,
                'unit'    => 'px',
                'default' => 1100,
                'output' => false, // No output for this, used only for setting value
                'dependency' => array('select_layout', '==',  'true', '', 'invisible' ),
            ),
            array(
                'id'      => 'select_layout_bg',
                'type'    => 'background',
                'title'   => 'Body Background',
                'background_origin' => true,
                'default' => array(
                    'background-color' => '#D6EAF8',
                    'background-gradient-direction' => 'to bottom',
                    'background-size' => 'cover',
                    'background-position' => 'center center',
                    'background-repeat' => 'repeat',
                ),
                'output' => '.body__box-layout',
                'dependency' => array('select_layout', '==',  'true', '', 'invisible' ),
            ),
            array(
                'id'      => 'select_layout_container_bg',
                'type'    => 'background',
                'title'   => 'Container Color',
                'default' => array(
                    'background-color' => '#ffffff',
                ),
                'output' => '.body-inner-content',
                'dependency' => array('select_layout', '==',  'true', '', 'invisible' ),

            ),
            array(
                'id'       => 'select_layout_container_padding',
                'type'     => 'spacing',
                'title'    => 'Container Padding',
                'output' => '.elementor-section, .main-container.blog-single.post-layout-style2.single-one-bwrap, #main-content.main-container.blog-spacing, .theme_header__main, .theme-footer-wrapper.theme_footer_Widegts.hav-footer-topp, #main-content.main-container.cat-page-spacing',
                'dependency' => array('select_layout', '==',  'true', '', 'invisible' ),
            ),
        )
    ));




    /*-------------------------------------------------------
     ** Entire Site Global Color Option
   --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Global Color', 'errin'),
        'id' => 'Global_color',
        'icon' => 'fa fa-paint-brush',
        'fields' => array(

            array(
                'id' => 'color-set',
                'type' => 'tabbed',
                'title' => 'Site Colors',
                'tabs' => array(
                    array(
                        'title' => 'Body Color',
                        'icon' => 'dashicons-admin-customizer',
                        'fields' => array(
                            array(
                                'id' => 'site-bg-color-main',
                                'type' => 'color',
                                'title' => 'Site Background Color',
                                'output' => 'body',
                                'output_mode' => 'background'
                            ),

                            array(
                                'id' => 'main_text_colot',
                                'type' => 'color',
                                'title' => 'Text Color',
                                'help' => 'This is the text color of Whole Website',
                                'output' => 'body,p',
                                'output_mode' => 'color',
                            ),
                        )),
                    array(
                        'title' => 'Primary Color',
                        'icon' => 'fa fa-paint-brush',
                        'fields' => array(
                            array(
                                'id' => 'primary_color',
                                'type' => 'color',
                                'title' => 'Primary Color',
                                'default' => '#FF3366',
                                'help' => 'This is the primary color for whole website.If you change it whole site main color will be changed.',
                                'output' => '.blog-sidebar .widget_block.widget_search .wp-block-search__button, .search-popup .search-form .submit-btn, .header-one-search-btn a',
                                'output_mode' => 'background',

                            ),

                            array(
                                'id' => 'primary-text-color',
                                'type' => 'color',
                                'title' => 'Primary Text Color',
                                'default' => '#FFEBF0',
                                'help' => 'This is the text color of primary color',
                                'output' => '.pivoo-section-title.title-style-one h3:before,.pivoo-post.style-one .pivoo-category-list a,
        .pivoo-nutritional-information h5,
        span.pivoo-new-tag,.plyr__control--overlaid,.pivoo-author-follow a',
                                'output_mode' => 'color',
                                'output_important' => true,
                            ),
                        )),

                    array(
                        'title' => 'Secondary Color',
                        'icon' => 'fa fa-paint-brush',
                        'fields' => array(
                            array(
                                'id' => 'secondary-color',
                                'type' => 'teconce_color',
                                'title' => 'Secondary Color',
                                'default' => '#FFDD33',
                                'help' => 'This is the secondary color for whole website.If you change it whole site main color will be changed.',
                                'output' => '.pivoo-product-sale-tag span.onsale,.plyr--video .plyr__control.plyr__tab-focus, .plyr--video .plyr__control:hover, .plyr--video .plyr__control[aria-expanded=true]',
                                'output_mode' => 'background',

                            ),

                            array(
                                'id' => 'secondary-text-color',
                                'type' => 'teconce_color',
                                'title' => 'Secondary Text Color',
                                'default' => '#402500',
                                'output' => '.pivoo-product-sale-tag span.onsale,.plyr--video .plyr__control.plyr__tab-focus, .plyr--video .plyr__control:hover, .plyr--video .plyr__control[aria-expanded=true]',
                                'output_mode' => 'color',
                                'help' => 'This is the text color of secondary color',
                            ),

                        )),

                    array(
                        'title' => 'Input Field Color',
                        'icon' => 'fa fa-paint-brush',
                        'fields' => array(

                            array(
                                'id' => 'global_input_bg',
                                'type' => 'color',
                                'title' => 'Input Field Background Color',
                                'help' => 'This is the input field background color for whole website',
                                'output' => 'input[type="text"], input[type="email"], input[type="url"], 
            input[type="password"], input[type="search"],
            input[type="number"], input[type="tel"], input[type="range"], input[type="date"], input[type="month"], 
            input[type="week"], input[type="time"], input[type="datetime"], input[type="datetime-local"], 
            input[type="color"], select, textarea,
            .select2-container--default .select2-selection--single,
             select.lable-form-all, .sidebar_nl__form #mc4wp-form-1.mc4wp-form-fields input',
                                'output_mode' => 'background-color',

                            ),

                            array(
                                'id' => 'global_input_border',
                                'type' => 'color',
                                'title' => 'Input Field Border Color',
                                'help' => 'This is the input field border color for whole website',
                                'output' => 'input[type="text"], input[type="email"], input[type="url"], 
            input[type="password"], input[type="search"],
            input[type="number"], input[type="tel"], input[type="range"], input[type="date"], input[type="month"], 
            input[type="week"], input[type="time"], input[type="datetime"], input[type="datetime-local"], 
            input[type="color"], select, textarea,
            .select2-container--default .select2-selection--single, select.lable-form-all , .sidebar_nl__form #mc4wp-form-1.mc4wp-form-fields input',
                                'output_mode' => 'border-color',

                            ),

                            array(
                                'id' => 'global_input_text',
                                'type' => 'color',
                                'title' => 'Input Field Text Color',
                                'help' => 'This is the input field Text color for whole website',
                                'output' => 'input[type="text"], input[type="email"], input[type="url"], 
            input[type="password"], input[type="search"],
            input[type="number"], input[type="tel"], input[type="range"], input[type="date"], input[type="month"], 
            input[type="week"], input[type="time"], input[type="datetime"], input[type="datetime-local"], 
            input[type="color"], select, textarea,
            .select2-container--default .select2-selection--single,
            select.lable-form-all , .sidebar_nl__form #mc4wp-form-1.mc4wp-form-fields input',
                                'output_mode' => 'color',

                            ),


                        )),


                )),


            array(
                'id' => 'btn_color',
                'type' => 'tabbed',
                'title' => 'Site Buttons Colors',
                'tabs' => array(
                    array(
                        'title' => 'Button Normal State',
                        'icon' => 'fa fa-paint-brush',
                        'fields' => array(
                            array(
                                'id' => 'global_btn_bg',
                                'type' => 'color',
                                'title' => 'Button Background',
                                'default' => '',
                                'help' => 'Site common button background color',
                                'output' => 'button, input[type="button"], input[type="submit"], [type=button], [type=submit],
                          .post-tab-block-element.news_tab_Block ul li a.active, .post-tab-block-element.news_tab_Block ul li a , .swiper-button-next.plc_next , .tagcloud a, .wp-block-tag-cloud a, .load__more__Post__btn a , .theme-tags__wrapper a , .author__box__info .author_more_post_btn a , .blog-post-comment .comment-respond .comment-form .btn.btn-primary , .sidebar_nl__form .mc4wp-form-fields input[type="submit"], .backto a',
                                'output_mode' => 'background',

                            ),

                            array(
                                'id' => 'global_btn_border',
                                'type' => 'color',
                                'title' => 'Button Border',
                                'default' => '',
                                'help' => 'Site common button border color',
                                'output' => 'button, input[type="button"], input[type="submit"], [type=button], [type=submit],
                    ,.post-tab-block-element.news_tab_Block ul li a.active, .post-tab-block-element.news_tab_Block ul li a , .swiper-button-next.plc_next , .tagcloud a, .wp-block-tag-cloud a, .load__more__Post__btn a , .theme-tags__wrapper a , .author__box__info .author_more_post_btn a , .blog-post-comment .comment-respond .comment-form .btn.btn-primary , .sidebar_nl__form .mc4wp-form-fields input[type="submit"], .backto a',
                                'output_mode' => 'border-color',

                            ),

                            array(
                                'id' => 'global_btn_text',
                                'type' => 'color',
                                'title' => 'Button Text',
                                'default' => '',
                                'help' => 'Site common button text color',
                                'output' => 'button, input[type="button"], input[type="submit"], [type=button], [type=submit],
                    .piv-lrn-button , .post-tab-block-element.news_tab_Block ul li a.active, .post-tab-block-element.news_tab_Block ul li a , .swiper-button-next.plc_next , .tagcloud a, .wp-block-tag-cloud a, .load__more__Post__btn a , .theme-tags__wrapper a , .author__box__info .author_more_post_btn a , .blog-post-comment .comment-respond .comment-form .btn.btn-primary , .sidebar_nl__form .mc4wp-form-fields input[type="submit"], .backto a',
                                'output_mode' => 'color',


                            ),
                        )),

                    array(
                        'title' => 'Button Hover State',
                        'icon' => 'fa fa-paint-brush',
                        'fields' => array(

                            array(
                                'id' => 'global_btn_bg_hvr',
                                'type' => 'color',
                                'title' => 'Button Background',
                                'default' => '',
                                'help' => 'Site common button background color',
                                'output' => 'button:hover, input[type="button"]:hover, input[type="submit"]:hover, [type=button]:hover, [type=submit]:hover
                    ,.piv-lrn-button:hover , .post-tab-block-element.news_tab_Block ul li a.active:hover, .post-tab-block-element.news_tab_Block ul li a:hover , .swiper-button-next.plc_next:hover , .tagcloud a, .wp-block-tag-cloud a:hover, .load__more__Post__btn a:hover , .theme-tags__wrapper a:hover , .author__box__info .author_more_post_btn a:hover , .blog-post-comment .comment-respond .comment-form .btn.btn-primary:hover , .sidebar_nl__form .mc4wp-form-fields input[type="submit"]:hover, .backto a:hover',
                                'output_mode' => 'background',

                            ),

                            array(
                                'id' => 'global_btn_border_hvr',
                                'type' => 'color',
                                'title' => 'Button Border',
                                'default' => '',
                                'help' => 'Site common button border color',
                                'output' => 'button:hover, input[type="button"]:hover, input[type="submit"]:hover, [type=button]:hover, [type=submit]:hover
                    ,.piv-lrn-button:hover , .post-tab-block-element.news_tab_Block ul li a.active:hover, .post-tab-block-element.news_tab_Block ul li a:hover , .swiper-button-next.plc_next:hover , .tagcloud a, .wp-block-tag-cloud a:hover, .load__more__Post__btn a:hover , .theme-tags__wrapper a:hover , .author__box__info .author_more_post_btn a:hover , .blog-post-comment .comment-respond .comment-form .btn.btn-primary:hover , .sidebar_nl__form .mc4wp-form-fields input[type="submit"]:hover, .backto a:hover',
                                'output_mode' => 'border-color',

                            ),

                            array(
                                'id' => 'global_btn_text_hvr',
                                'type' => 'color',
                                'title' => 'Button Text',
                                'default' => '',
                                'help' => 'Site common button text color',
                                'output' => 'button:hover, input[type="button"]:hover, input[type="submit"]:hover, [type=button]:hover, [type=submit]:hover
                    ,.piv-lrn-button:hover , .post-tab-block-element.news_tab_Block ul li a.active:hover, .post-tab-block-element.news_tab_Block ul li a:hover , .swiper-button-next.plc_next:hover , .tagcloud a, .wp-block-tag-cloud a:hover, .load__more__Post__btn a:hover , .theme-tags__wrapper a:hover , .author__box__info .author_more_post_btn a:hover , .blog-post-comment .comment-respond .comment-form .btn.btn-primary:hover , .sidebar_nl__form .mc4wp-form-fields input[type="submit"]:hover, .backto a:hover',
                                'output_mode' => 'color',


                            ),

                        )),

                )),


            array(
                'id' => 'link_color',
                'type' => 'color',
                'title' => 'Link Color',
                'output' => 'a , .post_list_tabs_inner .plpn_content h4 a:hover , .post_list_tabs_inner .plpn_content h4 a:hover , .home-top-block-content h2.post-title a, .post__list__content h4.post-title a , .latest_post_block_contnt h3.post-title a, .featured_post_block_content h4.post-title a, .featured-post-block-content h3.post-title a , .post-single-custom-meta .post-author-name a , .social_widget_wrap .fsocial_content a, .social_widget_wrap .fsocial_content a i , .elementor-widget-wp-widget-archives .elementor-widget-container ul li a, .elementor-widget-wp-widget-categories .elementor-widget-container ul li a, #sidebar .widget ul li a,.elementor-widget-wp-widget-archives .elementor-widget-container ul li, .elementor-widget-wp-widget-categories .elementor-widget-container ul li, #sidebar ul.wp-block-categories-list.wp-block-categories li, #sidebar ul.wp-block-archives-list.wp-block-archives li , .rightcontent h3 a , .spepiw-content-wrap h3 a, .recent-post-list-inner.recent_post_Content h4.title a , .post-single-custom-meta .post-author-name a , .post-single-custom-meta .post-author-name a',
                'visited' => true,
            ),

            array(
                'id' => 'alter_text_color',
                'type' => 'color',
                'title' => 'Link Hover Color',
                'output' => 'a:hover , .post_list_tabs_inner .plpn_content h4 a:hover , .post_list_tabs_inner .plpn_content h4 a:hover , .home-top-block-content h2.post-title a:hover , .post__list__content h4.post-title a:hover , .latest_post_block_contnt h3.post-title a:hover, .featured_post_block_content h4.post-title a:hover, .featured-post-block-content h3.post-title a:hover , .post-single-custom-meta .post-author-name a:hover , .social_widget_wrap .fsocial_content a:hover, .social_widget_wrap .fsocial_content a:hover i , .elementor-widget-wp-widget-archives .elementor-widget-container ul li a:hover, .elementor-widget-wp-widget-categories .elementor-widget-container ul li a:hover, #sidebar .widget ul li a:hover ,.elementor-widget-wp-widget-archives .elementor-widget-container ul li:hover, .elementor-widget-wp-widget-categories .elementor-widget-container ul li:hover, #sidebar ul.wp-block-categories-list.wp-block-categories li:hover, #sidebar ul.wp-block-archives-list.wp-block-archives li:hover , .rightcontent h3 a:hover , .spepiw-content-wrap h3 a:hover , .recent-post-list-inner.recent_post_Content h4.title a:hover , .post-single-custom-meta .post-author-name a:hover , .post-single-custom-meta .post-author-name a:hover',
                'visited' => true,
            ),

        )
    ));
    /*-------------------------------------------------------
       ** Entire Site Header  Options
     --------------------------------------------------------*/

    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Header', 'errin'),
        'id' => 'header_options',
        'icon' => 'fa fa-header',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Header Layout', 'errin') . '</h3>'
            ),
            //
            // nav select
            array(
                'id' => 'nav_menu',
                'type' => 'image_select',
                'title' => esc_html__('Select Header Navigation Style', 'errin'),
                'options' => array(
                    'nav-style-one' => ERRIN_IMG . '/admin/header-style/style1.png',
                    'nav-style-two' => ERRIN_IMG . '/admin/header-style/style2.png',
                ),

                'default' => 'nav-style-two'
            ),


            array(
                'id' => 'theme_header_sticky',
                'title' => esc_html__('Sticky Header', 'errin'),
                'type' => 'switcher',
                'desc' => esc_html__('Enable Sticky Header', 'errin'),
                'default' => true,
            ),


            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Header Bar', 'errin') . '</h3>'
            ),


            array(
                'id' => 'search_bar_enable',
                'title' => esc_html__('Show Header Search Button', 'errin'),
                'type' => 'switcher',
                'desc' => esc_html__('Enable Header Search Button', 'errin'),
                'default' => 1,
            ),

            array(
                'id' => 'nesletter_enable',
                'title' => esc_html__('Show Header Newsletter Button', 'errin'),
                'type' => 'switcher',
                'desc' => esc_html__('Enable Header Newsletter Button', 'errin'),
                'default' => false,
            ),

            array(
                'id' => 'nesletter_short_code',
                'type' => 'text',
                'title' => esc_html__('Newsletter Form Shortcode', 'errin'),
                'desc' => esc_html__('Enter you newsletter form shortcode', 'errin'),
                'dependency' => array('nesletter_enable', '==', 'true'),
            ),

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Social Options', 'errin') . '</h3>'
            ),

            array(
                'id' => 'header_social_enable',
                'title' => esc_html__('Do You want to Show Header Social Icons', 'errin'),
                'type' => 'switcher',
                'desc' => esc_html__('Enable or Disable Social Bar', 'errin'),
                'default' => true,
            ),


            array(
                'id' => 'social-icon',
                'type' => 'repeater',
                'title' => esc_html__('Repeater', 'errin'),
                'dependency' => array('header_social_enable', '==', 'true'),
                'fields' => array(
                    array(
                        'id' => 'icon',
                        'type' => 'icon',
                        'title' => esc_html__('Pick Up Your Social Icon', 'errin'),
                    ),
                    array(
                        'id' => 'link',
                        'type' => 'text',
                        'title' => esc_html__('Inter Social Url', 'errin'),
                    ),

                ),
            ),


        )
    ));

    /*-------------------------------------------------------
        ** Entire Site Global Dark Light Option
      --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Dark/Light Mood', 'errin'),
        'id' => 'dark_light',
        'icon' => 'fas fa-moon',
        'fields' => array(
            array(
                'id'    => 'select_dark_light',
                'type'  => 'switcher',
                'title' => 'Show Dark/Light',
                'default' => 0,
            ),
            array(
                'id' => 'dark_logo',
                'title' => esc_html__('Dark Logo', 'errin'),
                'type' => 'media',
                'library' => 'image',
                'desc' => esc_html__('Upload Your Static Logo Image on Header Static', 'errin'),
                'dependency' => array('select_dark_light', '==',  'true', '', 'invisible' ),
            ),

            array(
                'id'      => 'select_layout_dark_bg',
                'type'    => 'background',
                'title'   => 'Body Dark Mood Background',
                'background_origin' => true,
                'default' => array(
                    'background-color' => '#121212 ',
                    'background-gradient-direction' => 'to bottom',
                    'background-size' => 'cover',
                    'background-position' => 'center center',
                    'background-repeat' => 'repeat',
                ),
                'output' => '.errin_dark-mode .body__box-layout',
                'dependency' => array('select_dark_light', '==',  'true', '', 'invisible' ),
            ),
            array(
                'id'      => 'select_layout_container_dark_bg',
                'type'    => 'background',
                'title'   => 'Container Dark Mode Color',
                'default' => array(
                    'background-color' => '#000000',
                ),
                'output' => '.errin_dark-mode .body-inner-content , .errin_dark-mode .single__bottom_author__box , .errin_dark-mode #theme-header-one.theme_header__main.header-style-one.header-one-wrapper .nav-menu-wrapper , .errin_dark-mode .plyr--audio .plyr__controls , .errin_dark-mode .playlist-item.playing , .errin_dark-mode .playlist-item:hover , .errin_dark-mode .errin-share-modal-content',
                'dependency' => array('select_dark_light', '==',  'true', '', 'invisible' ),

            ),

            array(
                'id'      => 'select_layout_container_dark_cl',
                'type'    => 'color',
                'title'   => 'Content Dark Color',
                'default' =>  '#ffffff',
                'output' => 'body.errin_dark-mode h1 , body.errin_dark-mode h2 , body.errin_dark-mode h3 , body.errin_dark-mode h4 , body.errin_dark-mode h5 , body.errin_dark-mode h6, body.errin_dark-mode p , body.errin_dark-mode span , body.errin_dark-mode a, body.errin_dark-mode li a , body.errin_dark-mode h1 a, body.errin_dark-mode h2 a, body.errin_dark-mode h3 a, body.errin_dark-mode h4 a, body.errin_dark-mode h5 a, body.errin_dark-mode h6 a, body.errin_dark-mode p a , body.errin_dark-mode div , body.errin_dark-mode ul li , body.errin_dark-mode i ,  body.errin_dark-mode div a , body.errin_dark-mode svg path , body.errin_dark-mode p strong , body.errin_dark-mode strong',
                'output_important' => 'body.errin_dark-mode h1 , body.errin_dark-mode h2 , body.errin_dark-mode h3 , body.errin_dark-mode h4 , body.errin_dark-mode h5 , body.errin_dark-mode h6, body.errin_dark-mode p , body.errin_dark-mode span , body.errin_dark-mode a, body.errin_dark-mode li a , body.errin_dark-mode h1 a, body.errin_dark-mode h2 a, body.errin_dark-mode h3 a, body.errin_dark-mode h4 a, body.errin_dark-mode h5 a, body.errin_dark-mode h6 a, body.errin_dark-mode p a , body.errin_dark-mode div , body.errin_dark-mode ul li , body.errin_dark-mode i ,  body.errin_dark-mode div a , body.errin_dark-mode svg path , body.errin_dark-mode p strong , body.errin_dark-mode strong, body.errin_dark-mode ul li::marker',
                'dependency' => array('select_dark_light', '==',  'true', '', 'invisible' ),

            ),
            array(
                'id'      => 'select_layout_container_dark_link_cl',
                'type'    => 'color',
                'title'   => 'Content Dark Hover Color',
                'default' =>  '#FF4F4F',
                'output' => ' body.errin_dark-mode a:hover, body.errin_dark-mode li a:hover , body.errin_dark-mode h1 a:hover, body.errin_dark-mode h2 a:hover, body.errin_dark-mode h3 a:hover, body.errin_dark-mode h4 a:hover, body.errin_dark-mode h5 a:hover, body.errin_dark-mode h6 a:hover, body.errin_dark-mode p a:hover ,  body.errin_dark-mode div a:hover ',
                'output_important' => 'body.errin_dark-mode a:hover, body.errin_dark-mode li a:hover , body.errin_dark-mode h1 a:hover, body.errin_dark-mode h2 a:hover, body.errin_dark-mode h3 a:hover, body.errin_dark-mode h4 a:hover, body.errin_dark-mode h5 a:hover, body.errin_dark-mode h6 a:hover, body.errin_dark-mode p a:hover ,  body.errin_dark-mode div a:hover ',
                'dependency' => array('select_dark_light', '==',  'true', '', 'invisible' ),

            ),
            array(
                'id'      => 'select_layout_container_dark_head_bg',
                'type'    => 'background',
                'title'   => 'Header Dark Color',
                'default' => array(
                    'background-color' => '#191c20',
                ),
                'output' => 'body.errin_dark-mode #theme-header-one.theme_header__main.header-style-one.header-one-wrapper , body.errin_dark-mode #theme-header-two .theme-header-area , body.errin_dark-mode .theme-nav-area , body.errin_dark-mode footer.theme-footer-wrapper.theme_footer_Widegts.hav-footer-topp , body.errin_dark-mode .nav-design-one.stick-top.sticky ,body.errin_dark-mode .nav-design-one .mainmenu li ul.sub-menu  , body.errin_dark-mode .theme-breadcrumb__Wrapper.theme-breacrumb-area , body.errin_dark-mode .player-container',
                'dependency' => array('select_dark_light', '==',  'true', '', 'invisible' ),
            ),
            array(
                'id'      => 'select_layout_container_dark_box_bg',
                'type'    => 'background',
                'title'   => 'Box Dark Background Color',
                'default' => array(
                    'background-color' => '#191C20',
                ),
                'output' => ' .errin_dark-mode .single__bottom_author__box ,.errin_dark-mode #comments #respond , .errin_dark-mode .post__list__carousel .post__list__item , .errin_dark-mode .large__block__with__list .post_list_tabs , .errin_dark-mode  .post__list__with__rounded__img , .errin_dark-mode .theme_post_Tab__content .post_list_tabs , .errin_dark-mode .featured__img__with__vertical__list',
                'dependency' => array('select_dark_light', '==',  'true', '', 'invisible' ),
            ),
        )
    ));
    /*-------------------------------------------------------
       ** Pages and Template
     --------------------------------------------------------*/

    // blog optoins
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Blog', 'errin'),
        'id' => 'blog_page',
        'icon' => 'fa fa-bookmark',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Blog Options', 'errin') . '</h3>'
            ),

            array(
                'id' => 'blog_title',
                'type' => 'text',
                'title' => esc_html__('Blog Page Title', 'errin'),
                'default' => esc_html__('Blog Page', 'errin'),
                'desc' => esc_html__('Type Blog Page Title', 'errin'),
            ),

            array(
                'id' => 'errin_blog_layout',
                'type' => 'image_select',
                'title' => esc_html__('Select Blog Archive Layout', 'errin'),
                'options' => array(
                    'layout-one' => ERRIN_IMG . '/admin/page/style1.png',
                    'layout-two' => ERRIN_IMG . '/admin/page/style2.png',
                ),
                'default' => 'catt-two'
            ),

            array(
                'id' => 'page-spacing-blog',
                'type' => 'spacing',
                'title' => esc_html__('Blog Page Spacing', 'errin'),
                'output' => '.main-container.blog-spacing',
                'output_mode' => 'padding', // or margin, relative
                'default' => array(
                    'top' => '80',
                    'right' => '0',
                    'bottom' => '80',
                    'left' => '0',
                    'unit' => 'px',
                ),
            ),

            array(
                'id' => 'blog_breadcrumb_enable',
                'title' => esc_html__('Breadcrumb', 'errin'),
                'type' => 'switcher',
                'desc' => esc_html__('Enable Breadcrumb', 'errin'),
                'default' => true,
            ),


        )
    ));


    // category 

    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Category', 'errin'),
        'id' => 'cat_page',
        'icon' => 'fa fa-list-ul',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Theme Category Options. You can Customize Each Catgeory by Editing Individually.', 'errin') . '</h3>'
            ),
            array(
                'id' => 'errin_cat_layout',
                'type' => 'image_select',
                'title' => esc_html__('Select Category Layout', 'errin'),
                'options' => array(
                    'catt-one' => ERRIN_IMG . '/admin/page/style1.png',
                    'catt-two' => ERRIN_IMG . '/admin/page/style2.png',
                ),
                'default' => 'catt-two'
            ),

            array(
                'id' => 'page-spacing-category',
                'type' => 'spacing',
                'title' => esc_html__('Category Page Spacing', 'errin'),
                'output' => '.main-container.cat-page-spacing',
                'output_mode' => 'padding', // or margin, relative
                'default' => array(
                    'top' => '80',
                    'right' => '0',
                    'bottom' => '80',
                    'left' => '0',
                    'unit' => 'px',
                ),
            ),


        )
    ));


    // blog single optoins
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Single', 'errin'),
        'id' => 'single_page',
        'icon' => 'fa fa-pencil-square-o',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Blog Single Page Option', 'errin') . '</h3>'
            ),

            array(
                'id' => 'errin_single_blog_layout',
                'type' => 'image_select',
                'title' => esc_html__('Select Single Blog Style', 'errin'),
                'options' => array(
                    'single-one' => ERRIN_IMG . '/admin/page/blog-1.png',
                    'single-two' => ERRIN_IMG . '/admin/page/blog-2.png',
                ),
                'default' => 'single-one'
            ),

            array(
                'id' => 'page-spacing-single',
                'type' => 'spacing',
                'title' => esc_html__('Single Blog Spacing', 'errin'),
                'output' => '.single-one-bwrap',
                'output_mode' => 'padding', // or margin, relative
                'default' => array(
                    'top' => '40',
                    'right' => '0',
                    'bottom' => '80',
                    'left' => '0',
                    'unit' => 'px',
                ),
            ),

            array(
                'id' => 'blog_prev_title',
                'type' => 'text',
                'title' => esc_html__('Previous Post Text', 'errin'),
                'default' => esc_html__('Previous Post', 'errin'),
                'desc' => esc_html__('Type Previous Post Link Title', 'errin'),
            ),

            array(
                'id' => 'blog_next_title',
                'type' => 'text',
                'title' => esc_html__('Next Post Text', 'errin'),
                'default' => esc_html__('Next Post', 'errin'),
                'desc' => esc_html__('Type Next Post Link Title', 'errin'),
            ),

            array(
                'id' => 'blog_single_cat',
                'title' => esc_html__('Show Catgeory', 'errin'),
                'type' => 'switcher',
                'desc' => esc_html__('Show Category Name', 'errin'),
                'default' => true,
            ),

            array(
                'id' => 'blog_single_share_button',
                'title' => esc_html__('Show Share Button', 'errin'),
                'type' => 'switcher',
                'desc' => esc_html__('Show Share Button', 'errin'),
                'default' => true,
            ),

            array(
                'id' => 'blog_single_author',
                'title' => esc_html__('Show Author', 'errin'),
                'type' => 'switcher',
                'desc' => esc_html__('Single Post Author', 'errin'),
                'default' => true,
            ),

            array(
                'id' => 'blog_nav',
                'title' => esc_html__('Show Navigation', 'errin'),
                'type' => 'switcher',
                'desc' => esc_html__('Post Navigation', 'errin'),
                'default' => true,
            ),

            array(
                'id' => 'blog_tags',
                'title' => esc_html__('Show Tags', 'errin'),
                'type' => 'switcher',
                'desc' => esc_html__('Show Post Tags', 'errin'),
                'default' => true,
            ),

            array(
                'id' => 'blog_related',
                'title' => esc_html__('Show Related Posts', 'errin'),
                'type' => 'switcher',
                'desc' => esc_html__('Related Posts', 'errin'),
                'default' => true,
            ),

            array(
                'id' => 'blog_views',
                'title' => esc_html__('Show Post Views', 'errin'),
                'type' => 'switcher',
                'desc' => esc_html__('Post views', 'errin'),
                'default' => false,
            ),


        )
    ));


    /*-------------------------------------------------------
         ** Footer  Options
    --------------------------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Footer', 'errin'),
        'id' => 'footer_options',
        'icon' => 'fa fa-copyright',
        'fields' => array(
            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Options', 'errin') . '</h3>'
            ),
            array(
                'id' => 'select_footer_blocks',
                'type' => 'select',
                'title' => esc_html__('Select Global Footer', 'prefix'),
                'placeholder' => 'Select a Footer',
                'options' => 'posts',
                'query_args' => array(
                    'post_type' => 'errin_footer',
                ),
                'desc' => esc_html__('Before select the custom menu need build footer from admin menu using "Prefixt Fotter Builder" by Elementor', 'prefix'),
            ),
            array(
                'id' => 'footer_nav',
                'title' => esc_html__('Footer Right Menu', 'errin'),
                'type' => 'switcher',
                'desc' => esc_html__('You can set Yes or No to show Footer menu', 'errin'),
                'default' => false,
            ),


            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Footer Copyright Area Options', 'errin') . '</h3>'
            ),

            array(
                'id' => 'copyright_text',
                'title' => esc_html__('Copyright Area Text', 'errin'),
                'type' => 'textarea',
                'desc' => esc_html__('Footer Copyright Text', 'errin'),
            ),


        )
    ));


    // Backup section
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Backup', 'errin'),
        'id' => 'backup_options',
        'icon' => 'fa fa-window-restore',
        'fields' => array(
            array(
                'type' => 'backup',
            ),
        )
    ));


}