<?php
/**
 * Login form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @package 	WooCommerce/Templates
 * @version     3.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( is_user_logged_in() ) {
	return;
}

?>
<form class="woocommerce-form woocommerce-form-login login ui-row ui--box" method="post" style="margin-bottom: 30px;<?php echo esc_attr($hidden ? 'display:none;' : ''); ?>">

	<?php do_action( 'woocommerce_login_form_start' ); ?>

	<div class="form-elements">
		<?php if ( $message ) echo wpautop( wptexturize( $message ) ); ?>

		<div class="ui-row row">
			<div class="span6">
				<div class="control-group">
					<label class="control-label" for="username"><?php _e( 'Username or email', 'envision' ); ?></label>
					<div class="controls"><input type="text" class="input-text" name="username" id="username" /></div>
				</div>
			</div>
			<div class="span6">
				<div class="control-group">
					<label class="control-label" for="password"><?php _e( 'Password', 'envision' ); ?></label>
					<div class="controls"><input class="input-text" type="password" name="password" id="password" /></div>
				</div>
			</div>
		</div>
		<p class="ui-row row">
			<label class="woocommerce-form__label woocommerce-form__label-for-checkbox inline">
				<input class="woocommerce-form__input woocommerce-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever" /> <span><?php esc_html_e( 'Remember me', 'envision' ); ?></span>
			</label>
		</p>
	</div>

	<?php do_action( 'woocommerce_login_form' ); ?>

    <div class="form-actions clearfix ui--gradient ui--gradient-grey">
		<div class="pull-right">
			<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>
			<button type="submit" class="btn btn-primary" name="login" value="<?php esc_attr_e( 'Login', 'envision' ); ?>"><?php esc_html_e( 'Login', 'envision' ); ?></button>
			<input type="hidden" name="redirect" value="<?php echo esc_url( $redirect ) ?>" />
		</div>
		<div class="pull-left">
			<a class="lost_password btn btn-grey" href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php esc_html_e( 'Lost your password?', 'envision' ); ?></a>
		</div>
    </div>

	<div class="clear"></div>

	<?php do_action( 'woocommerce_login_form_end' ); ?>

</form>
