<?php

/**
 *	Register Options Scheme
 *
 *	@package 	CloudFw
 *	@subpackage WooCommerce
 *	@version 	1.0
 */
add_filter( 'cloudfw_schemes_options', 'cloudfw_module_option_woocommerce_views', 100 );
function cloudfw_module_option_woocommerce_views( $schemes ) {

	if ( isset( $schemes[ 22 ] ) && is_array( $schemes[ 22 ]['data'] ) ) {
		$schemes[ 22 ]['data'][] = array(
			'type'		=>	'vertical_tabs',
			'tab_id' 	=>	'Grid/List Views',
			'tab_title' =>	__('Grid/List Views','envision'),
			'data'		=>	array(

				## Container Item
				array(
					'type'			=>	'container',
					'footer'		=>	false,
					'title'			=>	__('Grid/List Views','envision'),
					'data'			=>	array(

						array(
							'type'		=> 'module',
							'title'		=>	__('Enable','envision'),
							'data'		=> array(

								## Element
								array(
									'type'		=>	'onoff',
									'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce_views enable' ),
									'value'		=>	cloudfw_get_option( 'woocommerce_views',  'enable' ),
								)

							)
						),
						array(
							'type'      => 'module',
							'title'     => __('Product Images Aspect Ratio on List View','envision'),
							'data'      => array(

								array(
									'type'		=>	'select',
									'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce_views media_aspect_ratio' ),
									'value'		=>	cloudfw_get_option( 'woocommerce_views',  'media_aspect_ratio' ),
									'source'	=>	array(
										'type' 		=> 'function',
										'function'	=> 'cloudfw_admin_loop_aspect_ratio',
									),
									'width'		=>  250,
								),

							)
						),
					)
				),

				## Module Item
				array(
					'type'		=>	'submit',
					'layout'	=>	'fixed',
					'nomargin'	=>	true,
				),
			)
		);
	}

	return $schemes;


	$schemes[ cloudfw_id_for_sequence( $schemes, 22 ) ] = array(
		'type'		=> 'page',
		'page' 		=> 'woocommerce',
		'woocommerce' => array(
			'page_title' 	=>	__('WooCommerce','envision'),
			'page_nice_title'=>	__('woocommerce','envision'),
			'page_slug' 	=>	'woocommerce',
			'page_css_id' 	=>	'cloud_nav_woocommerce',
		),
		'form'	=> 	array(
			'enable'	=> true,
			'ajax'		=> true,
			'shortcut'	=> true,
		),

		'data'	=> array(

			## Tab Item
			array(
				'type'		=>	'vertical_tabs',
				'tab_id' 	=>	'woocommerce_catalog',
				'tab_title' =>	__('Shop / Catalog Pages','envision'),
				'data'		=>	array(

					## Container Item
					array(
						'type'			=>	'container',
						'footer'		=>	false,
						'title'			=>	__('WooCommerce General','envision'),
						'data'			=>	array(

							array(
								'type'		=> 'module',
								'title'		=>	__('Catalog Mode','envision'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'onoff',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce catalog_mode' ),
										'value'		=>	cloudfw_get_option( 'woocommerce',  'catalog_mode' ),
									)

								)

							),

							array(
								'type'		=>	'mini-section',
								'title'		=>	__('Button Colors','envision'),
								'data'		=>	array(

									array(
										'type'		=>	'module',
										'title'		=>	__('Add to Cart Button Color on the catalog pages','envision'),
										'data'		=>	array(

											array(
												'type'		=>	'select',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce_button_color add_to_cart' ),
												'value'		=>	cloudfw_get_option( 'woocommerce_button_color',  'add_to_cart' ),
												'source'	=>	array(
													'type'		=>	'function',
													'function'	=>	'cloudfw_admin_loop_button_colors',
													'vars'		=>	array( __( 'Default', 'envision' ) ),
												),
												'width'		=>	250,
											),

										)
									),

									array(
										'type'		=>	'module',
										'title'		=>	__('Add to Cart Button Color on the product pages','envision'),
										'data'		=>	array(

											array(
												'type'		=>	'select',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce_button_color add_to_cart_in_product' ),
												'value'		=>	cloudfw_get_option( 'woocommerce_button_color',  'add_to_cart_in_product' ),
												'source'	=>	array(
													'type'		=>	'function',
													'function'	=>	'cloudfw_admin_loop_button_colors',
													'vars'		=>	array( __( 'Default', 'envision' ) ),
												),
												'width'		=>	250,
											),

										)
									),

									array(
										'type'		=>	'module',
										'title'		=>	__('Price Tags/Buttons Color on the catalog pages','envision'),
										'data'		=>	array(

											array(
												'type'		=>	'select',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce_button_color price_tag' ),
												'value'		=>	cloudfw_get_option( 'woocommerce_button_color',  'price_tag' ),
												'source'	=>	array(
													'type'		=>	'function',
													'function'	=>	'cloudfw_admin_loop_button_colors',
													'vars'		=>	array( __( 'Default', 'envision' ) ),
												),
												'width'		=>	250,
											),

										)
									),
									array(
										'type'		=>	'module',
										'title'		=>	__('Quick View button color','envision'),
										'data'		=>	array(

											array(
												'type'		=>	'select',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce_button_color quick_view' ),
												'value'		=>	cloudfw_get_option( 'woocommerce_button_color',  'quick_view' ),
												'source'	=>	array(
													'type'		=>	'function',
													'function'	=>	'cloudfw_admin_loop_button_colors',
													'vars'		=>	array( __( 'Default', 'envision' ) ),
												),
												'width'		=>	250,
											),

										)
									),

								)
							),

						)

					),

					## Container Item
					array(
						'type'			=>	'container',
						'footer'		=>	false,
						'title'			=>	__('Shop / Catalog Pages','envision'),
						'data'			=>	array(

							array(
								'type'		=>	'mini-section',
								'title'		=>	__('Layout Options','envision'),
								'data'		=>	array(

									array(
										'type'		=> 'module',
										'title'		=>	__('Layout','envision'),
										'data'		=> array(

											## Element
											array(
												'type'		=>	'select',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce catalog_layout' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'catalog_layout' ),
												'source'	=>	array(
													'type'		=>	'function',
													'function'	=>	'cloudfw_admin_loop_content_layouts',
													'exclude'	=>	array( 'carousel' ),
												),
												'width'		=>	250,
											)

										)

									),

									array(
										'type'		=> 'module',
										'title'		=>	__('Columns','envision'),
										'data'		=> array(

											## Element
											array(
												'type'		=>	'select',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce catalog_column' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'catalog_column' ),
												'source'	=>	array(
													'type'		=>	'function',
													'function'	=>	'cloudfw_admin_loop_columns',
												),
												'width'		=>	250,
											)

										)

									),

									array(
										'type'		=> 'module',
										'title'		=>	__('Product Number Per Pages','envision'),
										'data'		=> array(

											## Element
											array(
												'type'		=>	'text',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce catalog_post_perpage' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'catalog_post_perpage' ),
												'width'		=>	50,
												'unit'		=>	__('product(s)','envision')
											)

										)

									),


									array(
										'type'      => 'module',
										'title'     => __('Product Images Aspect Ratio','envision'),
										'data'      => array(

											array(
												'type'		=>	'select',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce catalog_media_ratio' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'catalog_media_ratio' ),
												'source'	=>	array(
													'type' 		=> 'function',
													'function'	=> 'cloudfw_admin_loop_aspect_ratio',
												),
												'width'		=>  250,
											),

										)

									),

									array(
										'type'      => 'module',
										'title'     => __('Category Description Position on Archive Pages','envision'),
										'data'      => array(

											array(
												'type'		=>	'select',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce archive_description_position' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'archive_description_position' ),
												'source'	=>	array(
													'NULL' 		=> __('Default','envision'),
													'before_loop'	=> __('Before the Products Loop','envision'),
													'after_loop'	=> __('After the Products Loop','envision'),
													'no_description'=> __('Do not show descriptions','envision'),
												),
												'width'		=>  250,
											),

										)

									),

								)

							),

							array(
								'type'		=>	'mini-section',
								'title'		=>	__('Shadow','envision'),
								'data'		=>	array(

									array(
										'type'      => 'module',
										'title'     => __('Box Shadows','envision'),
										'data'      => array(

											## Element
											array(
												'type'      =>  'select',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce catalog_shadow' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'catalog_shadow' ),
												'source'    =>  array(
													'type'          => 'function',
													'function'      => 'cloudfw_admin_loop_shadows',
												),
												'width'     =>  250,

											), // #### element: 0

										)

									),


								)

							),


							array(
								'type'		=>	'mini-section',
								'title'		=>	__('Effects','envision'),
								'data'		=>	array(

									array(
										'type'      => 'module',
										'title'     => __('Entrance Effect for Products','envision'),
										'data'      => array(

											## Element
											array(
												'type'		=>	'select',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce catalog_effect' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'catalog_effect' ),
												'ui'		=>	true,
												'source'	=>	array(
													'type'		=>	'function',
													'function'	=>	'cloudfw_css_effect_list',
													'vars'		=>	array(''),
												),
												'width'		=>	400,
											),

										)

									),


									array(
										'type'		=> 'module',
										'title'		=>	__('Gallery Effect on Hover?','envision'),
										'data'		=> array(

											## Element
											array(
												'type'		=>	'onoff',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce catalog_hover' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'catalog_hover' ),
											)

										)

									),


									array(
										'type'      => 'module',
										'title'     => __('Hover Transition Effect','envision'),
										'data'      => array(

											## Element
											array(
												'type'      =>  'select',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce catalog_hover_effect' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'catalog_hover_effect' ),
												'source'    =>  array(
													'type'          => 'function',
													'function'      => 'cloudfw_UI_box_hover_effects',
												),
												'width'     =>  250,

											), // #### element: 0

										)

									),


								)

							),

							array(
								'type'		=>	'mini-section',
								'title'		=>	__('Quick View','envision'),
								'data'		=>	array(

									array(
										'type'		=> 'module',
										'title'		=>	__('Enable Quick View button on catalog pages','envision'),
										'data'		=> array(

											## Element
											array(
												'type'		=>	'onoff',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce quick_view' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'quick_view' ),
											)

										)

									),

									array(
										'type'		=> 'module',
										'title'		=>	array(__('Quick View Lightbox Width','envision'), __('Quick View Lightbox Height','envision')),
										'layout'	=> 'split',
										'data'		=> array(

											## Element
											array(
												'type'		=>	'text',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce quick_view_width' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'quick_view_width' ),
												'width'		=>	50,
											),

											## Element
											array(
												'type'		=>	'text',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce quick_view_height' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'quick_view_height' ),
												'width'		=>	50,
											)

										)

									),

								)

							),

						)

					),

					## Container Item
					array(
						'type'		=>	'container',
						'footer'	=>	false,
						'title'		=>	__('Specific Options for WooCommerce Category Pages','envision'),
						'data'		=>	array(

							array(
								'type'		=>	'global-scheme',
								'scheme'	=>	'woocommerce_category_settings',
								'vars'		=>	array( 'category' )
							),

						)

					),


					## Module Item
					array(
						'type'		=>	'submit',
						'layout'	=>	'fixed',
						'nomargin'	=>	true,
					),


				)

			),

			## Tab Item
			array(
				'type'		=>	'vertical_tabs',
				'tab_id' 	=>	'woocommerce_product_pages',
				'tab_title' =>	__('Product Details Pages','envision'),
				'data'		=>	array(

					## Container Item
					array(
						'type'			=>	'container',
						'footer'		=>	false,
						'title'			=>	__('Product Pages','envision'),
						'data'			=>	array(


							array(
								'type'		=> 'module',
								'title'		=>	__('Product Details Page Layout','envision'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'select',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce post_page_layout' ),
										'value'		=>	cloudfw_get_option( 'woocommerce',  'post_page_layout' ),
										'source'	=>	array(
											'type'		=>	'function',
											'function'	=>	'cloudfw_admin_loop_page_templates',
										),
										'width'		=>	250,
										'desc'		=>	__('It\'s the same with the shop page by default.','envision')
									)

								)

							),

							array(
								'type'		=> 'module',
								'title'		=>	__('Product Details Page Sidebar','envision'),
								'data'		=> array(

									## Element
									array(
										'type'      =>  'select',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce post_page_sidebar' ),
										'value'		=>	cloudfw_get_option( 'woocommerce',  'post_page_sidebar' ),
										'source'    =>  array(
												'type'      =>  'function',
												'function'  =>  'cloudfw_admin_loop_custom_sidebars'
										),
										'width'     =>  400
									), // #### element: 0

								)

							),

							array(
								'type'		=> 'module',
								'title'		=>	__('Product Details Page Skin','envision'),
								'data'		=> array(

									## Element
									array(
										'type'      =>  'select',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce post_page_skin' ),
										'value'		=>	cloudfw_get_option( 'woocommerce',  'post_page_skin' ),
										'source'    =>  array(
											'type'          => 'function',
											'function'      => 'cloudfw_module_admin_gel_all_skins_array',
											'send_data'	=>	true,
											'send_args'	=>	true,
										),
										'width'		=>	400,

									)

								)

							),

							array(
								'type'		=> 'module',
								'title'		=>	__('Product Details Page Title Bar Style','envision'),
								'data'		=> array(

									## Element
									array(
										'type'      =>  'select',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce post_page_titlebar_style' ),
										'value'		=>	cloudfw_get_option( 'woocommerce',  'post_page_titlebar_style' ),
										'source'    =>  array(
											'type'          => 'function',
											'function'      => 'cloudfw_admin_loop_titlebar_styles',
										),
										'width'		=>	300,
									)

								)

							),

							array(
								'type'		=> 'module',
								'title'		=>	__('Display Previous / Next Product Links on Product Pages?','envision'),
								'data'		=> array(

									## Element
									array(
										'type'		=>  'select',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce post_page_prev_next_links' ),
										'value'		=>	cloudfw_get_option( 'woocommerce',  'post_page_prev_next_links' ),
										'source'	=>	array(
											'NULL'	  => __('Don\'t Display','envision'),
											'before'  => __('Display Before Product Contents','envision'),
											'after'   => __('Display After Product Contents','envision'),
											'both'    => __('Display Before & After Product Contents','envision'),
										),
										'width'		=>	250,
									)

								),

							),

						)

					),

					## Container Item
					array(
						'type'			=>	'container',
						'footer'		=>	false,
						'title'			=>	__('Product Image Gallery','envision'),
						'data'			=>	array(

							array(
								'type'		=> 'module',
								'title'		=>	__('Product Image Gallery Style','envision'),
								'data'		=> array(

									## Element
									array(
										'type'		=>  'select',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce gallery_style' ),
										'value'		=>	cloudfw_get_option( 'woocommerce',  'gallery_style' ),
										'source'	=>	array(
											'NULL'		=> __('Horizontal','envision'),
											'vertical'  => __('Vertical','envision'),
										),
										'width'		=>	250,
									)

								),

							),

							array(
								'type'		=> 'module',
								'title'		=>	__('Zoom Effect for Product Image Galleries','envision'),
								'data'		=> array(

									## Element
									array(
										'type'		=>  'onoff',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce zoom' ),
										'value'		=>	cloudfw_get_option( 'woocommerce',  'zoom' ),
									)

								),
								'js'        => array(
									## Script Item
									array(
										'type'          => 'toggle',
										'related'       => 'WCZoomSettings',
										'conditions'    => array(
											array( 'val' => '1', 'e' => '.WCZoomSettings' ),
										)
									),
								)

							),


							array(
								'type'		=>	'group',
								'related'	=>	'WCZoomSettings',
								'data'		=>	array(

									array(
										'type'		=> 'module',
										'title'		=>	__('Zoom Type','envision'),
										'data'		=> array(

											## Element
											array(
												'type'		=>  'select',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce zoom_type' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'zoom_type' ),
												'source'	=>	array(
													'NULL'		=> __('Window','envision'),
													'inner'		=> __('Inner','envision'),
												),
												'width'		=>	250,
											)

										),

									),

									array(
										'type'		=> 'module',
										'title'		=>	__('Easing Effect','envision'),
										'data'		=> array(

											## Element
											array(
												'type'		=>  'onoff',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce zoom_easing' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'zoom_easing' ),
											)

										),

									),

									array(
										'type'		=> 'module',
										'title'		=>	__('Scroll Zoom','envision'),
										'data'		=> array(

											## Element
											array(
												'type'		=>  'onoff',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce zoom_scroll' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'zoom_scroll' ),
											)

										),

									),

									array(
										'type'		=> 'module',
										'title'		=>	array(__('Zoom Window Width','envision'), __('Zoom Window Height','envision')),
										'layout'	=> 'split',
										'data'		=> array(

											## Element
											array(
												'type'		=>  'text',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce zoom_window_width' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'zoom_window_width' ),
												'width'		=>	50,
												'unit'		=>	__('px','envision'),
											),

											## Element
											array(
												'type'		=>  'text',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce zoom_window_height' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'zoom_window_height' ),
												'width'		=>	50,
												'unit'		=>	__('px','envision'),
											),

										)

									),


								)

							),



						)
					),

					## Container Item
					array(
						'type'			=>	'container',
						'footer'		=>	false,
						'title'			=>	__('Up-Sells Products','envision'),
						'data'			=>	array(


							array(
								'type'		=> 'module',
								'title'		=>	__('Up-Sells Products List Columns','envision'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'select',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce up_sells_column' ),
										'value'		=>	cloudfw_get_option( 'woocommerce',  'up_sells_column' ),
										'source'	=>	array(
											'type'		=>	'function',
											'function'	=>	'cloudfw_admin_loop_columns',
										),
										'width'		=>	250,
									)

								)

							),

							array(
								'type'		=> 'module',
								'title'		=>	__('Up-Sells Products Limit','envision'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'text',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce up_sells_limit' ),
										'value'		=>	cloudfw_get_option( 'woocommerce',  'up_sells_limit' ),
										'width'		=>	50,
										'unit'		=>	__('product(s)','envision')
									)

								)

							),

							array(
								'type'		=> 'module',
								'title'		=>	__('Up-Sells Products Layout','envision'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'select',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce up_sells_layout' ),
										'value'		=>	cloudfw_get_option( 'woocommerce',  'up_sells_layout' ),
										'source'	=>	array(
											'type'		=>	'function',
											'function'	=>	'cloudfw_admin_loop_content_layouts',
										),
										'width'		=>	250,
									)

								)

							),

						)

					),

					## Container Item
					array(
						'type'			=>	'container',
						'footer'		=>	false,
						'title'			=>	__('Related Products','envision'),
						'data'			=>	array(


							array(
								'type'		=>	'mini-section',
								'title'		=>	__('Layout Options','envision'),
								'data'		=>	array(

									array(
										'type'		=> 'module',
										'title'		=>	__('Layout','envision'),
										'data'		=> array(

											## Element
											array(
												'type'		=>	'select',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce related_layout' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'related_layout' ),
												'source'	=>	array(
													'type'		=>	'function',
													'function'	=>	'cloudfw_admin_loop_content_layouts',
												),
												'width'		=>	250,
											)

										)

									),


									array(
										'type'		=> 'module',
										'title'		=>	__('Columns','envision'),
										'data'		=> array(

											## Element
											array(
												'type'		=>	'select',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce related_column' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'related_column' ),
												'source'	=>	array(
													'type'		=>	'function',
													'function'	=>	'cloudfw_admin_loop_columns',
												),
												'width'		=>	250,
											)

										)

									),


									array(
										'type'		=> 'module',
										'title'		=>	__('Product Number to Show','envision'),
										'data'		=> array(

											## Element
											array(
												'type'		=>	'text',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce related_limit' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'related_limit' ),
												'width'		=>	50,
												'unit'		=>	__('product(s)','envision')
											)

										)

									),


									array(
										'type'      => 'module',
										'title'     => __('Product Images Aspect Ratio','envision'),
										'data'      => array(

											array(
												'type'		=>	'select',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce related_media_ratio' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'related_media_ratio' ),
												'source'	=>	array(
													'type' 		=> 'function',
													'function'	=> 'cloudfw_admin_loop_aspect_ratio',
												),
												'width'		=>  250,
											),

										)

									),

								)

							),

							array(
								'type'		=>	'mini-section',
								'title'		=>	__('Shadow','envision'),
								'data'		=>	array(

									array(
										'type'      => 'module',
										'title'     => __('Box Shadows','envision'),
										'data'      => array(

											## Element
											array(
												'type'      =>  'select',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce related_shadow' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'related_shadow' ),
												'source'    =>  array(
													'type'          => 'function',
													'function'      => 'cloudfw_admin_loop_shadows',
												),
												'width'     =>  250,

											), // #### element: 0

										)

									),


								)

							),


							array(
								'type'		=>	'mini-section',
								'title'		=>	__('Effects','envision'),
								'data'		=>	array(

									array(
										'type'      => 'module',
										'title'     => __('Entrance Effect for Products','envision'),
										'data'      => array(

											## Element
											array(
												'type'		=>	'select',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce related_effect' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'related_effect' ),
												'ui'		=>	true,
												'source'	=>	array(
													'type'		=>	'function',
													'function'	=>	'cloudfw_css_effect_list',
													'vars'		=>	array(''),
												),
												'width'		=>	400,
											),

										)

									),


									array(
										'type'		=> 'module',
										'title'		=>	__('Gallery Effect on Hover?','envision'),
										'data'		=> array(

											## Element
											array(
												'type'		=>	'onoff',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce related_hover' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'related_hover' ),
											)

										)

									),


									array(
										'type'      => 'module',
										'title'     => __('Hover Transition Effect','envision'),
										'data'      => array(

											## Element
											array(
												'type'      =>  'select',
												'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce related_hover_effect' ),
												'value'		=>	cloudfw_get_option( 'woocommerce',  'related_hover_effect' ),
												'source'    =>  array(
													'type'          => 'function',
													'function'      => 'cloudfw_UI_box_hover_effects',
												),
												'width'     =>  250,

											), // #### element: 0

										)

									),


								)

							),


						)



					),


					## Module Item
					array(
						'type'		=>	'submit',
						'layout'	=>	'fixed',
						'nomargin'	=>	true,
					),


				)

			),

			## Tab Item
			array(
				'type'		=>	'vertical_tabs',
				'tab_id' 	=>	'woocommerce_cart_page',
				'tab_title' =>	__('Cart Page','envision'),
				'data'		=>	array(

					## Container Item
					array(
						'type'			=>	'container',
						'footer'		=>	false,
						'title'			=>	__('Cross-Sells Products','envision'),
						'data'			=>	array(


							array(
								'type'		=> 'module',
								'title'		=>	__('Cross-Sells Products List Columns','envision'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'select',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce cross_sells_column' ),
										'value'		=>	cloudfw_get_option( 'woocommerce',  'cross_sells_column' ),
										'source'	=>	array(
											'type'		=>	'function',
											'function'	=>	'cloudfw_admin_loop_columns',
										),
										'width'		=>	250,
									)

								)

							),

							array(
								'type'		=> 'module',
								'title'		=>	__('Cross-Sells Products Limit','envision'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'text',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce cross_sells_limit' ),
										'value'		=>	cloudfw_get_option( 'woocommerce',  'cross_sells_limit' ),
										'width'		=>	50,
										'unit'		=>	__('product(s)','envision')
									)

								)

							),

							array(
								'type'		=> 'module',
								'title'		=>	__('Cross-Sells Products Layout','envision'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'select',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce cross_sells_layout' ),
										'value'		=>	cloudfw_get_option( 'woocommerce',  'cross_sells_layout' ),
										'source'	=>	array(
											'type'		=>	'function',
											'function'	=>	'cloudfw_admin_loop_content_layouts',
										),
										'width'		=>	250,
									)

								)

							),

						)

					),

					array(
						'type'			=>	'container',
						'footer'		=>	false,
						'title'			=>	__('Button Colors on Cart Page','envision'),
						'data'			=>	array(

							array(
								'type'		=>	'module',
								'title'		=>	__('Update Cart Button','envision'),
								'data'		=>	array(

									array(
										'type'		=>	'select',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce_button_color update_cart' ),
										'value'		=>	cloudfw_get_option( 'woocommerce_button_color',  'update_cart' ),
										'source'	=>	array(
											'type'		=>	'function',
											'function'	=>	'cloudfw_admin_loop_button_colors',
											'vars'		=>	array( __( 'Default', 'envision' ) ),
										),
										'width'		=>	250,
									),

								)
							),

							array(
								'type'		=>	'module',
								'title'		=>	__('Proceed to Checkout Button','envision'),
								'data'		=>	array(

									array(
										'type'		=>	'select',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce_button_color proceed_to_checkout' ),
										'value'		=>	cloudfw_get_option( 'woocommerce_button_color',  'proceed_to_checkout' ),
										'source'	=>	array(
											'type'		=>	'function',
											'function'	=>	'cloudfw_admin_loop_button_colors',
											'vars'		=>	array( __( 'Default', 'envision' ) ),
										),
										'width'		=>	250,
									),

								)
							),

						)

					),


					## Module Item
					array(
						'type'		=>	'submit',
						'layout'	=>	'fixed',
						'nomargin'	=>	true,
					),


				)

			),


			## Tab Item
			array(
				'type'		=>	'vertical_tabs',
				'tab_id' 	=>	'woocommerce_checkout_page',
				'tab_title' =>	__('Checkout Page','envision'),
				'data'		=>	array(

					array(
						'type'			=>	'container',
						'footer'		=>	false,
						'title'			=>	__('Button Colors on Checkout Page','envision'),
						'data'			=>	array(

							array(
								'type'		=>	'module',
								'title'		=>	__('Place order Button','envision'),
								'data'		=>	array(

									array(
										'type'		=>	'select',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce_button_color place_order' ),
										'value'		=>	cloudfw_get_option( 'woocommerce_button_color',  'place_order' ),
										'source'	=>	array(
											'type'		=>	'function',
											'function'	=>	'cloudfw_admin_loop_button_colors',
											'vars'		=>	array( __( 'Default', 'envision' ) ),
										),
										'width'		=>	250,
									),

								)
							),

						)

					),


					## Module Item
					array(
						'type'		=>	'submit',
						'layout'	=>	'fixed',
						'nomargin'	=>	true,
					),


				)

			),

			## Tab Item
			array(
				'type'		=>	'vertical_tabs',
				'tab_id' 	=>	'woocommerce_login_page',
				'tab_title' =>	__('Login/Register Page','envision'),
				'data'		=>	array(

					## Container Item
					array(
						'type'			=>	'container',
						'footer'		=>	false,
						'title'			=>	__('Login / Register Form','envision'),
						'data'			=>	array(


							array(
								'type'		=> 'module',
								'title'		=>	__('Login Form Custom Message','envision'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'textarea',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce login_message' ),
										'value'		=>	cloudfw_get_option( 'woocommerce',  'login_message' ),
										'width'		=>	'90%',
										'line'		=>	5,
										'editor'	=>	true,
										'desc'		=>	__('allows <code>[shortcodes]</code>','envision'),
									)

								)

							),

							array(
								'type'		=> 'module',
								'title'		=>	__('Register Form Custom Message','envision'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'textarea',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce register_message' ),
										'value'		=>	cloudfw_get_option( 'woocommerce',  'register_message' ),
										'width'		=>	'90%',
										'line'		=>	5,
										'editor'	=>	true,
										'desc'		=>	__('allows <code>[shortcodes]</code>','envision'),
									)

								)

							),

						)

					),


					## Module Item
					array(
						'type'		=>	'submit',
						'layout'	=>	'fixed',
						'nomargin'	=>	true,
					),


				)

			),

			## Tab Item
			array(
				'type'		=>	'vertical_tabs',
				'tab_id' 	=>	'woocommerce_custom_codes',
				'tab_title' =>	__('Custom Codes','envision'),
				'data'		=>	array(

					## Container Item
					array(
						'type'			=>	'container',
						'footer'		=>	false,
						'title'			=>	__('Single Product Pages','envision'),
						'data'			=>	array(


							array(
								'type'		=> 'module',
								'title'		=>	__('Before Content','envision'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'textarea',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce code_single_before_content' ),
										'value'		=>	cloudfw_get_option( 'woocommerce',  'code_single_before_content' ),
										'width'		=>	'90%',
										'line'		=>	5,
										'editor'	=>	true,
										'desc'		=>	__('allows <code>[shortcodes]</code>','envision'),
									)

								)

							),

							array(
								'type'		=> 'module',
								'title'		=>	__('After Content','envision'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'textarea',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce code_single_after_content' ),
										'value'		=>	cloudfw_get_option( 'woocommerce',  'code_single_after_content' ),
										'width'		=>	'90%',
										'line'		=>	5,
										'editor'	=>	true,
										'desc'		=>	__('allows <code>[shortcodes]</code>','envision'),
									)

								)

							),



						)

					),


					## Module Item
					array(
						'type'		=>	'submit',
						'layout'	=>	'fixed',
						'nomargin'	=>	true,
					),


				)

			),

			## Tab Item
			array(
				'type'		=>	'vertical_tabs',
				'tab_id' 	=>	'woocommerce_others',
				'tab_title' =>	__('Other Options','envision'),
				'data'		=>	array(

					## Container Item
					array(
						'type'			=>	'container',
						'footer'		=>	false,
						'title'			=>	__('Other Options','envision'),
						'data'			=>	array(


							array(
								'type'		=> 'module',
								'title'		=>	__('Show Mini Cart Link in Sticky Navigation Menu?','envision'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'onoff',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce cart_in_navigation' ),
										'value'		=>	cloudfw_get_option( 'woocommerce',  'cart_in_navigation' ),
									)

								)

							),

							array(
								'type'		=> 'module',
								'title'		=>	__('Mini Cart Link Action','envision'),
								'data'		=> array(

									## Element
									array(
										'type'		=>	'select',
										'id'		=>	cloudfw_sanitize( PFIX.'_woocommerce cart_in_navigation_action' ),
										'value'		=>	cloudfw_get_option( 'woocommerce',  'cart_in_navigation_action' ),
										'source'	=>	array(
											'NULL'			=>	'Show the cart in the side panel',
											'goto_cart'		=>	'Go to the cart page',
										),
										'width'		=>	400,
									)

								)

							),

						)

					),


					## Module Item
					array(
						'type'		=>	'submit',
						'layout'	=>	'fixed',
						'nomargin'	=>	true,
					),


				)

			),

		)

	);

	return $schemes;
}