<?php
/**
 * 	Activate Shortcode Admin UI for Portfolio
 *
 *	@package CloudFw
 *	@since 	 1.0
 */
add_filter('cloudfw_post_thumbnails',                 'cloudfw_module_activate_shortcodes_on_portfolio');
add_filter('cloudfw_composer_default_types',          'cloudfw_module_activate_shortcodes_on_portfolio');
add_filter('cloudfw_post_types_for_core_metaboxes',   'cloudfw_module_activate_shortcodes_on_portfolio');
add_filter('cloudfw_post_types_for_composer',         'cloudfw_module_activate_shortcodes_on_portfolio');
add_filter('cloudfw_post_types_for_dummy_thumbnails', 'cloudfw_module_activate_shortcodes_on_portfolio');
function cloudfw_module_activate_shortcodes_on_portfolio( $post_types ) {
	$post_types[] = 'portfolio';
	return $post_types;
}

/**
 *    Set Category Slug for Post Type
 *
 *    @since 1.0
 */
add_filter('cloudfw_bar_category_slug_portfolio', 'cloudfw_bar_category_slug_portfolio');
function cloudfw_bar_category_slug_portfolio( $default ) {
	return 'portfolio-category';
}

add_filter('cloudfw_bar_tag_slug_portfolio', 'cloudfw_bar_tag_slug_portfolio');
function cloudfw_bar_tag_slug_portfolio( $default ) {
	return 'portfolio-filter';
}


/**
 *    Register the post type for breadcrumb trial
 */
add_filter('cloudfw_breadcrumbs_singular_portfolio_before', 'cloudfw_breadcrumbs_singular_portfolio_before');
add_filter('cloudfw_breadcrumbs_archive_portfolio-category_before', 'cloudfw_breadcrumbs_singular_portfolio_before');
function cloudfw_breadcrumbs_singular_portfolio_before( $trial ) {
	$slug = cloudfw_get_option('portfolio', 'slug');
	$parent_page = get_page_by_path( trim( $slug, '/' ) );

	if ( ! ( !empty( $parent_page ) && $parent_page->ID > 0 ) ) {
		$portfolio_page = cloudfw_get_option('portfolio', 'page');
		$portfolio_page = function_exists('icl_object_id') ? icl_object_id( $portfolio_page, 'page', false ) : $portfolio_page;

		if ( !empty($portfolio_page) && is_numeric($portfolio_page) ) {
			$page_data = get_page( $portfolio_page );
			if ( !empty($page_data->post_title) )
				$trial[] = array( 'link' => get_page_link( $portfolio_page ), 'title' => $page_data->post_title );

		}
	}

	if ( is_singular('portfolio') ){
		global $post;

		if ( $terms = wp_get_post_terms( get_the_ID(), 'portfolio-category', array( 'orderby' => 'parent', 'order' => 'DESC' ) ) ) {

			$main_term = $terms[0];

			$ancestors = get_ancestors( $main_term->term_id, 'portfolio-category' );

			$ancestors = array_reverse( $ancestors );

			foreach ( $ancestors as $ancestor ) {
				$ancestor = get_term( $ancestor, 'portfolio-category' );
				$trial[] = array( 'link' => get_term_link( $ancestor->slug, 'portfolio-category' ), 'title' => $ancestor->name );
			}

			$trial[] = array( 'link' => get_term_link( $main_term->slug, 'portfolio-category' ), 'title' => $main_term->name );

		}
	}


	return $trial;
}

/**
 *    Selects portfolio item in the navigation menu
 */
add_filter('nav_menu_css_class', 'cloudfw_nav_menu_css_class_portfolio', 10, 2);
function cloudfw_nav_menu_css_class_portfolio( $classes, $item ){

	if ( is_singular('portfolio') || is_tax( 'portfolio-category' ) || is_tax( 'portfolio-filter' ) ) {
		$portfolio_page = cloudfw_get_option('portfolio', 'page');
		$portfolio_page = function_exists('icl_object_id') ? icl_object_id( $portfolio_page, 'page', false ) : $portfolio_page;

		if ( !empty($portfolio_page) && is_numeric($portfolio_page) && isset($item->object_id) && $item->object_id == $portfolio_page ) {
			$classes[] = 'current-menu-item';
			$classes[] = 'force-for-select';
		}
	}

	return $classes;
}