<?php

/**
 * Makes CSS Animation
 *
 * @param  array  $atts
 * @param  string $content
 *
 * @return string $content
 */
function cloudfw_make_css_animation( $atts = array(), $content =  NULL ) {
	extract(shortcode_atts(array(
		'effect'      => '',
		'delay'       => NULL,
		'start_delay' => NULL,
	), $atts));

	$classes = array();
	$classes[] = 'ui--animation-in'; 
	$classes[] = 'make--' . $effect; 
	$classes[] = 'ui--pass'; 
	$classes[] = 'clearfix'; 

	if ( ! (int) $delay > 0 ) {
		$delay = 0;
	}

	return "<div ". 
		cloudfw_make_class($classes, true) .
		cloudfw_make_data_attribute( array(
			'fx'          => $effect,
			'delay'       => $delay,
			'start-delay' => $start_delay,
		), FALSE ) .
	">{$content}</div>";
}

/**
 * Gets CSS Animation Effect List 
 * 
 * @return (array)
 */
function cloudfw_css_effect_list( $no_default = false ){

	$effects = array(
		__('Attention Seekers','envision') => array(
			'fx--appear'			=> __('Appear','envision'),
			'fx--swing'				=> __('Swing','envision'),
			'fx--wobble'			=> __('Wobble','envision'),
			'fx--bounce'			=> __('Bounce','envision'),
		),

		__('Fading Entrances','envision') => array(
			'fx--fadein-ltr'		=> __('Fade In Left to Right','envision'),
			'fx--fadein-rtl'		=> __('Fade In Right to Left','envision'),
			'fx--fadein-ttb'		=> __('Fade In Top to Bottom','envision'),
			'fx--fadein-btt'		=> __('Fade In Bottom to Top','envision'),
			'fx--caption-top'		=> __('Caption Top','envision'),
			'fx--caption-bottom'	=> __('Caption Bottom','envision'),
			'fx--caption-left'		=> __('Caption Left','envision'),
			'fx--caption-right'		=> __('Caption Right','envision'),
		),

		__('Rotating Entrances','envision') => array(
			'fx--rotatein'			=> __('Rotate In','envision'),
			'fx--rotatein-downleft'	=> __('Rotate In Down Left','envision'),
			'fx--rotatein-downright'=> __('Rotate In Down Right','envision'),
		),

		__('3D Effects','envision') => array(
			'fx--flipIn-X'			=> __('Flip In X','envision'),
			'fx--flipIn-Y'			=> __('Flip In Y','envision'),
//			'fx--fly'				=> __('Fly Effect (Beta)','cloudfw'),
		),

	);

	 
	if ( ! $no_default ) {
		
 		$effects = array_merge( array( 'NULL' => __('- Use the parent option -','envision') ), $effects );
 		$effects = array_merge( $effects, array( 'fx--no-effect' =>	__('No Transition Effect','envision') ) );

	}

	return $effects;

}

$shortcode_path = trailingslashit(dirname(__FILE__)) . 'module.shortcode.php'; 
if ( file_exists( $shortcode_path ) ) {
	require_once( $shortcode_path );
}