<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see     http://docs.woothemes.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.5.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product, $post, $woocommerce_loop, $woocommerce_loop_via;

$woocommerce_is_page = cloudfw( 'get', 'woocommerce_is_page' ) == 'shop';
if ( $woocommerce_is_page && $woocommerce_loop_via !== 'shortcode'  ) {
	$column = cloudfw( 'get', 'woocommerce_catalog_column', cloudfw_get_option( 'woocommerce', 'catalog_column' ) );

	if ( !empty($column) ) {
		$woocommerce_loop['columns'] = $column;
	}

	$woocommerce_loop['shadow'] = cloudfw( 'get', 'woocommerce_catalog_shadow', cloudfw_get_option( 'woocommerce', 'catalog_shadow' ) );
	$woocommerce_loop['effect'] = cloudfw( 'get', 'woocommerce_catalog_effect', cloudfw_get_option( 'woocommerce', 'catalog_effect' ) );
	$woocommerce_loop['show_hover'] = _check_onoff( cloudfw( 'get', 'woocommerce_catalog_hover', cloudfw_get_option( 'woocommerce', 'catalog_hover' ) ) );
	$woocommerce_loop['hover_effect'] = cloudfw( 'get', 'woocommerce_catalog_hover_effect', cloudfw_get_option( 'woocommerce', 'catalog_hover_effect' ) );
	$woocommerce_loop['image_ratio'] = cloudfw( 'get', 'woocommerce_catalog_media_ratio', isset($woocommerce_loop['image_ratio']) ? $woocommerce_loop['image_ratio'] : NULL );
}

// Store loop count we're currently on
if ( empty( $woocommerce_loop['loop'] ) ) {
	$woocommerce_loop['loop'] = 0;
}

// Store column count for displaying the grid
if ( empty( $woocommerce_loop['columns'] ) ) {
	$woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 3 );
}

if ( $woocommerce_loop['columns'] > 6 ) {
	$woocommerce_loop['columns'] = 6;
}

$woocommerce_loop['columns'] = apply_filters( 'cloudfw_wc_shop_columns', $woocommerce_loop['columns'] );

// Ensure visibility
if ( ! $product || ! $product->is_visible() ) {
	return;
}

// Increase loop count
$woocommerce_loop['loop']++;

	remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail' );
	remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash' );
	$before_title_content = ''; 
	ob_start();
		do_action( 'woocommerce_before_shop_loop_item_title' );
		$before_title_content = ob_get_contents();
	ob_end_clean();

	$box = array();
	$box['title'] = $before_title_content . get_the_title();
	$box['columns'] = $woocommerce_loop['columns']; 

	$box['overlay'] = true; 
	$box['lightbox'] = false; 
	$box['link'] = get_permalink(); 
	$item_content = '';
	$box['button_text'] = cloudfw_translate( 'wc.loop.details' );
	$box['icon'] = ''; 
	$box['shadow'] = isset($woocommerce_loop['shadow']) ? $woocommerce_loop['shadow'] : NULL;
	$box['image_ratio'] = !empty($woocommerce_loop['image_ratio']) ? $woocommerce_loop['image_ratio'] : cloudfw_get_option( 'woocommerce', 'catalog_media_ratio' );

	
	if ( has_post_thumbnail() ) {
		$thumbnail_id = get_post_thumbnail_id( $post->ID );
		$large_image = wp_get_attachment_image_src( $thumbnail_id, 'large');
		$box['image'] = $large_image[0];

		if ( isset($woocommerce_loop['show_hover']) && $woocommerce_loop['show_hover'] ) {
			$attachment_ids = $product->get_gallery_attachment_ids();
			if ( !empty($attachment_ids ) && is_array($attachment_ids ) && !empty($attachment_ids[0]) ) {


				$image_hover = wp_get_attachment_image_src( $attachment_ids[0], 'large');
		
				$box['image_hover'] = $image_hover[0];
				$box['hover_effect'] = isset($woocommerce_loop['hover_effect']) ? $woocommerce_loop['hover_effect'] : NULL;
			}
		}

	} else {
		$box['image'] = woocommerce_placeholder_img_src();
	}


	ob_start();
		woocommerce_template_loop_add_to_cart(); // this adds "add to cart" button.
		$woocommerce_template_loop_add_to_cart = ob_get_contents();
	ob_end_clean();

	$box['footer'] = '';
		if ( $price_html = $product->get_price_html() ) {
			$box['footer'] .= '<div class="woocommerce-actions text-center">';
				$box['footer'] .= apply_filters( 'cloudfw_woocommerce_loop_footer_action_before', '' );
				$box['footer'] .= '<a href="'. $box['link'] .'" class="btn btn-small '. esc_attr( cloudfw_make_button_style( cloudfw_get_option('woocommerce_button_color', 'price_tag', 'btn-primary'), true ) ) . '" style="">'. $price_html .'</a>';
				$box['footer'] .= ' ';
				if ( ! cloudfw_check_onoff( 'woocommerce', 'catalog_mode' ) ) {
					$box['footer'] .= '<div class="woocommerce-loading-wrap">';
						$box['footer'] .= $woocommerce_template_loop_add_to_cart;
						$box['footer'] .= '<a class="added_to_cart btn btn-small btn-green" data-i18n-view-cart="'. esc_attr( __('View Cart','woocommerce') ) .'" style="display:none;"><i class="fontawesome-ok"></i> '. cloudfw_translate( 'wc.loop.ajax_added' ) .'</a>';
					$box['footer'] .= '</div>';
				}
				$box['footer'] .= apply_filters( 'cloudfw_woocommerce_loop_footer_action_after', '' );
			$box['footer'] .= '</div>';

		}
		$box['footer'] = apply_filters( 'cloudfw_woocommerce_loop_footer', $box['footer'] );

	if ( function_exists('cloudfw_wc_badge') ) {
		$badge = cloudfw_wc_badge( 'loop' );
		if ( $badge ) {
			$box['media_link_append'] = $badge;
		}
	}

	$column_array = array();
	$column_array['class'] = get_post_class();
	$column_array['_key'] = 'woocommerce';

	$box_content = cloudfw_UI_box( $box, $item_content );

	global $woocommerce_loop_output;
	$woocommerce_loop_output .= cloudfw_UI_column( $column_array, $box_content, '1of' . $woocommerce_loop['columns'] . ( $woocommerce_loop['loop'] % $woocommerce_loop['columns'] == 0 ? '_last' : '' ) );