// Generated by CoffeeScript 1.6.2
/*
Sticky Elements Shortcut for jQuery cloudfw_waypoints - v2.0.3
Copyright (c) 2011-2013 Caleb Troughton
Dual licensed under the MIT license and GPL license.
https://github.com/imakewebthings/jquery-cloudfw_waypoints/blob/master/licenses.txt
*/


(function() {
  (function(root, factory) {
    if (typeof define === 'function' && define.amd) {
      return define(['jquery', 'cloudfw_waypoints'], factory);
    } else {
      return factory(root.jQuery);
    }
  })(this, function($) {
    var defaults, wrap;

    defaults = {
      wrapper: '<div class="sticky-wrapper" />',
      stuckClass: 'stuck',
      noStuckClass: 'no-stuck'
    };
    wrap = function($elements, options) {
      $elements.wrap(options.wrapper);
      return $elements.parent();
    };
    $.cloudfw_waypoints('extendFn', 'sticky', function(opt) {
      var $wrap, options, originalHandler;

      options = $.extend({}, $.fn.cloudfw_waypoint.defaults, defaults, opt);
      $wrap = wrap(this, options);
      originalHandler = options.handler;
      options.handler = function(direction) {
        var $sticky, shouldBeStuck;

        $sticky = $(this).children(':first');
        shouldBeStuck = direction === 'down' || direction === 'right';
        var height = shouldBeStuck ? $sticky.outerHeight() : '';  
        $sticky.toggleClass(options.stuckClass, shouldBeStuck);
        $sticky.toggleClass(options.noStuckClass, !shouldBeStuck);
        $wrap.height( height );
        if (originalHandler != null) {
          return originalHandler.call(this, direction);
        }
      };
      $wrap.cloudfw_waypoint(options);
      return this.data('stuckClass', options.stuckClass);
    });
    return $.cloudfw_waypoints('extendFn', 'unsticky', function() {
      this.parent().cloudfw_waypoint('destroy');
      this.unwrap();
      return this.removeClass(this.data('stuckClass'));
    });
  });

}).call(this);