(function ($) {

	var CloudFw_SEOYoast = function () {
		YoastSEO.app.registerPlugin('CloudFw_SEOYoast', {status: 'ready'});

		var _init = this;
		_init.fetchData();
	};

	CloudFw_SEOYoast.prototype.fetchData = function () {
		var _self = this,
			_postData = {};

		var ajaxForm_vars = {
			action: 'cloudfw_composer_frontend_ajax_load',
			post_id: jQuery('#cloudfw-composer-post-id').val(),
			nonce: CloudFwOp.cloudfw_nonce
		};

		jQuery.ajax({
			url: CloudFwOp.ajaxUrl,
			cache: false,
			type: "POST",
			data: (jQuery.param(ajaxForm_vars, true)),
			success: function(data) {
				_self.extra_content = data;
				YoastSEO.app.pluginReady('CloudFw_SEOYoast');
				YoastSEO.app.registerModification('content', $.proxy(_self.getContent, _self), 'CloudFw_SEOYoast', 5);
			}

		});
	};

	CloudFw_SEOYoast.prototype.getContent = function (content) {
			the_content = this.extra_content ? ( this.extra_content ) : content;
			return the_content;
	};

	/**
	 * YoastSEO content analysis integration
	 */
	$(window).on('YoastSEO:ready', function () {
		new CloudFw_SEOYoast();
	});

}) (jQuery);