<?php
/* 
 * WooCommerce Account - Navigations
 */

defined('ABSPATH') or exit; // Exit if accessed directly

$menu_items = !isset($menu_items) ? wc_get_account_menu_items() : $menu_items;

if (!empty($menu_items)) :
    $class_wrap = 'woocommerce-MyAccount-navigation';
    $class_wrap .= isset($extra_class) ? ' ' . $extra_class : '';
    ?>

    <nav class="<?php echo esc_attr($class_wrap); ?>" aria-label="<?php esc_attr_e('Account pages', 'elessi-theme'); ?>">
        <ul>
            <?php foreach ($menu_items as $endpoint => $label) : ?>
                <li class="<?php echo wc_get_account_menu_item_classes($endpoint); ?>">
                    <a href="<?php echo esc_url(wc_get_account_endpoint_url($endpoint)); ?>" title="<?php echo esc_attr($label); ?>" class="nasa-flex"<?php echo (function_exists('wc_is_current_account_menu_item') && wc_is_current_account_menu_item($endpoint)) ? ' aria-current="page"' : ''; ?>>
                        <?php
                        /**
                         * SVG
                         */
                        switch ($endpoint) :
                            case 'dashboard' :
                                echo '<span class="ns-svg-wrap nasa-flex"><svg class="ns-dashboard" width="27" height="32" viewBox="0 0 27 32" fill="currentColor"><path d="M16.785 12.328h7.342v1.049h-7.342v-1.049z" /><path d="M16.784 18.623h7.343v1.049h-7.343v-1.049z" /><path d="M16.784 15.475h5.237v1.049h-5.237v-1.049z" /><path d="M15.735 6.034v-3.147h-4.196v3.147h-11.539v23.079h27.275v-23.079h-11.539zM26.226 7.083v2.098h-10.49v-2.098h10.49zM12.588 3.936h2.098v5.245h-2.098v-5.245zM1.049 7.083h10.49v2.098h-10.49v-2.098zM1.049 28.064v-17.833h25.177v17.833h-25.177z" /><path d="M15.463 23.402c-0.757-0.315-2.545-0.936-3.652-1.263-0.094-0.030-0.108-0.035-0.108-0.428 0-0.324 0.133-0.65 0.263-0.927 0.14-0.301 0.308-0.806 0.368-1.259 0.168-0.196 0.396-0.58 0.545-1.313 0.128-0.645 0.069-0.881-0.017-1.102-0.009-0.023-0.018-0.046-0.026-0.069-0.033-0.152 0.012-0.938 0.123-1.549 0.076-0.418-0.019-1.309-0.596-2.046-0.364-0.466-1.060-1.037-2.334-1.117l-0.699 0.001c-1.251 0.079-1.949 0.651-2.312 1.116-0.577 0.737-0.673 1.628-0.597 2.046 0.112 0.611 0.156 1.397 0.124 1.546-0.006 0.026-0.016 0.049-0.026 0.072-0.085 0.221-0.146 0.456-0.016 1.102 0.146 0.733 0.375 1.117 0.544 1.313 0.058 0.453 0.226 0.958 0.368 1.259 0.103 0.22 0.153 0.519 0.153 0.942 0 0.393-0.015 0.398-0.103 0.426-1.144 0.338-2.967 0.996-3.646 1.293-0.539 0.231-0.67 0.646-0.67 1.020 0 0.105 0 0.268 0 0.453h1.049v-0.453c0-0.017 0.001-0.030 0.002-0.040 0.009-0.005 0.021-0.011 0.039-0.018 0.645-0.283 2.433-0.927 3.543-1.255 0.835-0.265 0.835-1.049 0.835-1.426 0-0.581-0.080-1.022-0.252-1.389-0.105-0.224-0.235-0.621-0.277-0.946l-0.041-0.313-0.206-0.239c-0.032-0.036-0.192-0.244-0.309-0.833-0.080-0.397-0.051-0.471-0.035-0.514 0.028-0.068 0.051-0.135 0.073-0.23 0.092-0.424-0.030-1.483-0.116-1.955-0.029-0.155 0.012-0.73 0.39-1.214 0.332-0.425 0.844-0.665 1.522-0.713l0.629-0.001c0.691 0.049 1.209 0.289 1.541 0.714 0.379 0.484 0.419 1.059 0.391 1.213-0.086 0.472-0.208 1.53-0.117 1.957l0.009 0.041 0.011 0.040c0.014 0.046 0.030 0.090 0.052 0.149 0.017 0.044 0.046 0.117-0.033 0.513-0.119 0.59-0.28 0.8-0.312 0.836l-0.204 0.237-0.041 0.31c-0.043 0.326-0.172 0.725-0.277 0.949-0.17 0.36-0.364 0.841-0.364 1.375 0 0.377 0 1.162 0.861 1.434 1.048 0.309 2.805 0.916 3.535 1.221 0.111 0.047 0.151 0.105 0.162 0.127v0.424h1.049c0-0.184 0-0.348 0-0.453-0-0.374-0.259-0.831-0.797-1.063z" /></svg></span>';
                                break;
                            
                            case 'orders' :
                                echo '<span class="ns-svg-wrap nasa-flex"><svg class="ns-orders" width="25" height="32" viewBox="0 0 25 32" fill="currentColor"><path d="M6.294 14.164h12.588v1.049h-12.588v-1.049z" /><path d="M6.294 18.36h12.588v1.049h-12.588v-1.049z" /><path d="M6.294 22.557h8.392v1.049h-8.392v-1.049z" /><path d="M15.688 3.674c-0.25-1.488-1.541-2.623-3.1-2.623s-2.85 1.135-3.1 2.623h-9.489v27.275h25.176v-27.275h-9.488zM10.49 6.082v-1.884c0-1.157 0.941-2.098 2.098-2.098s2.098 0.941 2.098 2.098v1.884l0.531 0.302c1.030 0.586 1.82 1.477 2.273 2.535h-9.803c0.453-1.058 1.243-1.949 2.273-2.535l0.53-0.302zM24.128 29.9h-23.078v-25.177h8.392v0.749c-1.638 0.932-2.824 2.566-3.147 4.496h12.588c-0.322-1.93-1.509-3.563-3.147-4.496v-0.749h8.392v25.177z" /></svg></span>';
                                break;
                            
                            case 'downloads' :
                                echo '<span class="ns-svg-wrap nasa-flex"><svg width="32" height="32" viewBox="0 0 32 32" fill="currentColor"><path d="M11.335 13.315l-0.754 0.754 5.419 5.419 5.419-5.419-0.754-0.754-4.132 4.132v-16.877h-1.066v16.877z" /><path d="M18.666 5.9v1.066h6.931v18.126h-19.192v-18.126h6.931v-1.066h-7.997v20.259h21.325v-20.259z" /></svg></span>';
                                break;
                            
                            case 'edit-address' :
                                echo '<span class="ns-svg-wrap nasa-flex"><svg width="32" height="32" viewBox="0 0 32 32" fill="currentColor"><path d="M16.001 1.072c5.291 0 9.596 4.305 9.596 9.597 0 1.683-0.446 3.341-1.29 4.799l-8.307 14.394-8.308-14.395c-0.843-1.456-1.289-3.115-1.289-4.798 0-5.292 4.305-9.597 9.597-9.597zM16.001 14.4c2.058 0 3.731-1.674 3.731-3.731s-1.674-3.731-3.731-3.731c-2.058 0-3.732 1.674-3.732 3.731s1.674 3.731 3.732 3.731zM16.001 0.006c-5.889 0-10.663 4.775-10.663 10.663 0 1.945 0.523 3.762 1.432 5.332l9.23 15.994 9.23-15.994c0.909-1.57 1.432-3.387 1.432-5.332 0-5.888-4.774-10.663-10.662-10.663v0zM16.001 13.334c-1.472 0-2.666-1.193-2.666-2.665 0-1.471 1.194-2.665 2.666-2.665s2.665 1.194 2.665 2.665c0 1.472-1.193 2.665-2.665 2.665v0z" /></svg></span>';
                                break;
                            
                            case 'edit-account' :
                                echo '<span class="ns-svg-wrap nasa-flex"><svg width="32" height="32" viewBox="0 0 32 32" fill="currentColor"><path d="M16 3.205c-7.067 0-12.795 5.728-12.795 12.795s5.728 12.795 12.795 12.795 12.795-5.728 12.795-12.795c0-7.067-5.728-12.795-12.795-12.795zM16 4.271c6.467 0 11.729 5.261 11.729 11.729 0 2.845-1.019 5.457-2.711 7.49-1.169-0.488-3.93-1.446-5.638-1.951-0.146-0.046-0.169-0.053-0.169-0.66 0-0.501 0.206-1.005 0.407-1.432 0.218-0.464 0.476-1.244 0.569-1.944 0.259-0.301 0.612-0.895 0.839-2.026 0.199-0.997 0.106-1.36-0.026-1.7-0.014-0.036-0.028-0.071-0.039-0.107-0.050-0.234 0.019-1.448 0.189-2.391 0.118-0.647-0.030-2.022-0.921-3.159-0.562-0.719-1.638-1.601-3.603-1.724l-1.078 0.001c-1.932 0.122-3.008 1.004-3.57 1.723-0.89 1.137-1.038 2.513-0.92 3.159 0.172 0.943 0.239 2.157 0.191 2.387-0.010 0.040-0.025 0.075-0.040 0.111-0.131 0.341-0.225 0.703-0.025 1.7 0.226 1.131 0.579 1.725 0.839 2.026 0.092 0.7 0.35 1.48 0.569 1.944 0.159 0.339 0.234 0.801 0.234 1.454 0 0.607-0.023 0.614-0.159 0.657-1.767 0.522-4.579 1.538-5.628 1.997-1.725-2.042-2.768-4.679-2.768-7.555 0-6.467 5.261-11.729 11.729-11.729zM7.811 24.386c1.201-0.49 3.594-1.344 5.167-1.808 0.914-0.288 0.914-1.058 0.914-1.677 0-0.513-0.035-1.269-0.335-1.908-0.206-0.438-0.442-1.189-0.494-1.776-0.011-0.137-0.076-0.265-0.18-0.355-0.151-0.132-0.458-0.616-0.654-1.593-0.155-0.773-0.089-0.942-0.026-1.106 0.027-0.070 0.053-0.139 0.074-0.216 0.128-0.468-0.015-2.005-0.17-2.858-0.068-0.371 0.018-1.424 0.711-2.311 0.622-0.795 1.563-1.238 2.764-1.315l1.011-0.001c1.233 0.078 2.174 0.521 2.797 1.316 0.694 0.887 0.778 1.94 0.71 2.312-0.154 0.852-0.298 2.39-0.17 2.857 0.022 0.078 0.047 0.147 0.074 0.217 0.064 0.163 0.129 0.333-0.025 1.106-0.196 0.977-0.504 1.461-0.655 1.593-0.103 0.091-0.168 0.218-0.18 0.355-0.051 0.588-0.286 1.338-0.492 1.776-0.236 0.502-0.508 1.171-0.508 1.886 0 0.619 0 1.389 0.924 1.68 1.505 0.445 3.91 1.271 5.18 1.77-2.121 2.1-5.035 3.4-8.248 3.4-3.183 0-6.073-1.277-8.188-3.342z" /></svg></span>';
                                break;
                            
                            case 'payment-methods' :
                                echo '<span class="ns-svg-wrap nasa-flex"><svg width="32" height="32" viewBox="0 0 32 32" fill="currentColor"><path d="M28.795 6.404h-25.59c-0.883 0-1.599 0.716-1.599 1.599v15.994c0 0.884 0.716 1.599 1.599 1.599h25.59c0.883 0 1.599-0.715 1.599-1.599v-15.994c0-0.883-0.716-1.599-1.599-1.599zM2.672 10.669h26.656v2.133h-26.656v-2.133zM29.328 23.997c0 0.294-0.239 0.533-0.533 0.533h-25.59c-0.294 0-0.533-0.239-0.533-0.533v-10.129h26.656v10.129zM2.672 9.602v-1.599c0-0.294 0.239-0.533 0.533-0.533h25.59c0.294 0 0.533 0.239 0.533 0.533v1.599h-26.656z" /><path d="M4.804 21.331h10.662v1.066h-10.662v-1.066z" /><path d="M4.804 18.133h6.398v1.066h-6.397v-1.066z" /><path d="M23.981 22.398h2.165c0.579 0 1.050-0.462 1.050-1.034v-0.064c0-0.571-0.47-1.035-1.050-1.035h-2.165c-0.58 0-1.051 0.463-1.051 1.035v0.064c0 0.572 0.47 1.034 1.051 1.034z" /></svg></span>';
                                break;
                            
                            case 'customer-logout' :
                                echo '<span class="ns-svg-wrap nasa-flex"><svg width="32" height="32" viewBox="0 0 32 32" fill="currentColor"><path d="M14.389 7.956v4.374l1.056 0.010c7.335 0.071 11.466 3.333 12.543 9.944-4.029-4.661-8.675-4.663-12.532-4.664h-1.067v4.337l-9.884-7.001 9.884-7zM15.456 5.893l-12.795 9.063 12.795 9.063v-5.332c5.121 0.002 9.869 0.26 13.884 7.42 0-4.547-0.751-14.706-13.884-14.833v-5.381z" /></svg></span>';
                                break;
                            
                            default:
                                echo '<span class="ns-svg-wrap nasa-flex"><svg width="32" height="32" viewBox="0 0 32 32" fill="currentColor"><path d="M16.067 11.156c0.883 0 1.599-0.716 1.599-1.599 0-0.884-0.716-1.598-1.599-1.598s-1.599 0.714-1.599 1.598c0 0.883 0.716 1.599 1.599 1.599z" /><path d="M17.153 13.289v-1.066h-3.199v1.066h1.066v9.063h-1.066v1.066h4.265v-1.066h-1.066z" /><path d="M16 2.672c-7.361 0-13.328 5.968-13.328 13.328 0 7.362 5.968 13.328 13.328 13.328s13.328-5.966 13.328-13.328c0-7.361-5.968-13.328-13.328-13.328zM16 28.262c-6.761 0-12.262-5.501-12.262-12.262s5.5-12.262 12.262-12.262c6.761 0 12.262 5.501 12.262 12.262s-5.5 12.262-12.262 12.262z" /></svg></span>';
                                break;
                        endswitch;
                        
                        /**
                         * Label
                         */
                        echo esc_html($label);
                        ?>
                    </a>
                </li>
            <?php endforeach; ?>
        </ul>
    </nav>
<?php
endif;
