<?php 
get_header();

if (have_posts()){ while (have_posts()){ the_post(); global $post;

	/* Get Inner Header */ 
	if(function_exists('tabligh_secondary_header')) {
		tabligh_secondary_header($post->ID, esc_html__('Islamic Scholars','tabligh')); 
	} 
	
	$team_designation = get_post_meta( get_the_ID(), 'team_designation', true );
	$team_course_title = get_post_meta( get_the_ID(), 'team_course_title', true );
	$team_contact_me = get_post_meta( get_the_ID(), 'team_contact_me', true );
	$team_info_details = get_post_meta( get_the_ID(), 'wiki_test_repeat_group', true );
	$team_twitter = get_post_meta( get_the_ID(), 'team_twitter', true );
	$team_linkedin = get_post_meta( get_the_ID(), 'team_linkedin', true );
	$team_facebook = get_post_meta( get_the_ID(), 'team_facebook', true );
	$team_expertise_group = get_post_meta( get_the_ID(), 'team_expertise_group', true );
	
	?>
	<section>
		<div class="w-100 pt-100 pb-100 position-relative">
			<div class="container">
				<div class="team-detail-wrap w-100">
					<div class="row">
						<div class="col-md-12 col-sm-12 col-lg-5">
							<div class="team-detail-img w-100">
								<?php if(has_post_thumbnail()){ ?> 
									<?php echo get_the_post_thumbnail($post->ID, 'tabligh-team-detail', array( 'class' => 'img-fluid w-100' ));?>
								<?php } /*endif*/ ?>
							</div>
						</div>
						<div class="col-md-12 col-sm-12 col-lg-7">
							<div class="team-detail-inner w-100">
								<div class="team-detail-info d-flex flex-wrap justify-content-between w-100 position-relative pat-bg gray-layer2 opc85 back-blend-multiply gray-bg4" style="<?php echo tabligh_background('pattern-bg.jpg'); ?>">
									<div class="team-detail-info-inner">
										<h2 class="mb-0"><?php echo get_the_title(); ?></h2>
										<span class="d-block thm-clr"><?php echo esc_html($team_designation); ?></span>
										<div class="social-links4 text-center d-inline-flex">
											<a href="<?php echo esc_url($team_facebook); ?>" title="<?php esc_attr__('Facebook','tabligh'); ?>" target="_blank"><i class="fab fa-facebook-f"></i></a>
											<a href="<?php echo esc_url($team_linkedin); ?>" title="<?php esc_attr__('LinkedIn','tabligh'); ?>" target="_blank"><i class="fab fa-linkedin-in"></i></a>
											<a href="<?php echo esc_url($team_twitter); ?>" title="<?php esc_attr__('Twitter','tabligh'); ?>" target="_blank"><i class="fab fa-twitter"></i></a>
										</div>
										<a class="thm-btn thm-bg" href="<?php echo esc_url($team_contact_me); ?>"><?php esc_html_e('Contact Me','tabligh'); ?><span></span><span></span><span></span><span></span></a>
									</div>
									<div class="team-detail-info-inner">
										<ul class="team-detail-info-list mb-0 list-unstyled">
											<?php
											if(is_array($team_info_details)){
												foreach($team_info_details as $info){ ?>
													<li><span><?php echo esc_html($info['team_info_title']);?></span><?php echo esc_html($info['team_info_description']); ?></li>
												<?php 
												}
											} ?>
										</ul>
									</div>
								</div>
								<div class="team-detail-experties w-100">
									<div class="row">
										<div class="col-md-5 col-sm-6 col-lg-5">
											<h3 class="mb-0"><?php echo esc_html($team_course_title); ?></h3>
											<p class="mb-0"><?php echo get_the_excerpt(); ?></p>
										</div>
										<div class="col-md-7 col-sm-6 col-lg-7">
											<ul class="experties-list mb-0 list-unstyled">
												<?php
												if(is_array($team_expertise_group)){
													foreach($team_expertise_group as $experty){ ?>
														<li><a href="<?php echo esc_url($experty['team_course_link']); ?>"><?php echo esc_html($experty['team_course_title']); ?></a></li>
													<?php 
													}
												} ?>
											</ul>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="col-md-12 col-sm-12 col-lg-12">
							<div class="team-detail-desc w-100">
								<?php /* The Content */
									the_content(); 		
									wp_link_pages( array(
										'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'tabligh' ) . '</span>',
										'after'       => '</div>',
										'link_before' => '',
										'link_after'  => '',
										'pagelink'    => '<span>%</span>',
										'separator'   => '',
									) );
								?>
							</div>
						</div>
					</div>
				</div><!-- Team Detail Wrap -->
			</div>
		</div>
	</section>
	
	<?php 
	}/*end of while statement*/

} /*end of if statement*/
get_footer(); ?>