<?php 
get_header();

if (have_posts()){ while (have_posts()){ the_post(); global $post;

	$course_teacher_name = get_post_meta( get_the_ID(), 'course_teacher_name', true );
	$course_teacher_expertise = get_post_meta( get_the_ID(), 'course_teacher_expertise', true );
	$course_teacher_image = get_post_meta( get_the_ID(), 'course_teacher_image', true );
	$course_button_url = get_post_meta( get_the_ID(), 'course_button_url', true );
	$course_button_text = get_post_meta( get_the_ID(), 'course_button_text', true );
	$course_price_title = get_post_meta( get_the_ID(), 'course_price_title', true );
	$course_price_amount = get_post_meta( get_the_ID(), 'course_price_amount', true );
	$course_caption = get_post_meta( get_the_ID(), 'course_caption', true );
	$course_social_media_tags = get_post_meta( get_the_ID(), 'course_social_media_tags', true );
	$course_meta_details = get_post_meta( get_the_ID(), 'course_meta_details', true );
	$course_author_box = get_post_meta( get_the_ID(), 'course_author_box', true );
	$courses_sidebar_layout = get_post_meta( get_the_ID(), 'courses_sidebar_layout', true );
	$courses_sidebar_selected = get_post_meta( get_the_ID(), 'courses_sidebar_selected', true );
	$course_author_intro_title = get_post_meta( get_the_ID(), 'course_author_intro_title', true );
	
	
	$archive_year  = get_the_time('Y'); 
	$archive_month = get_the_time('m'); 
	$archive_day   = get_the_time('d'); 
	
	$user = wp_get_current_user($post->ID);
	$avatar_url = get_avatar_url($user->ID, array("size"=>32));
	$avatar_url_large = get_avatar_url($user->ID, array("size"=>170));
	
	/* Get Comment Count */
	$comment_count = wp_count_comments( $post->ID );
	$comment_count = $comment_count->total_comments;
	
	/* it sets the post view */
	if(function_exists('tabligh_set_post_view')){ tabligh_set_post_view(); }

	/* Get Inner Header */ 
	if(function_exists('tabligh_secondary_header')) {
		tabligh_secondary_header($post->ID, esc_html__('Course Details','tabligh')); 
	} ?>
	
	<section>
		<div class="w-100 pt-100 pb-100 position-relative">
			<div class="container">
				<div class="post-detail-wrap w-100">
					<div class="post-detail-img w-100">
						<?php if(has_post_thumbnail()){ ?> 
							<?php echo get_the_post_thumbnail($post->ID, 'tabligh-course-detail', array( 'class' => 'img-fluid w-100' ));?>
						<?php } /*endif*/ ?>
					</div>
					<div class="row">
						<?php /* Left Sidebar */
						if($courses_sidebar_layout == 'left'){ ?>
							<div class="col-md-6 col-sm-6 col-lg-3">
                                <aside class="sidebar w-100">
									<?php dynamic_sidebar( $courses_sidebar_selected ); ?>
								</aside>
							</div>
						<?php } /*endif */ ?>
						<div class="<?php if($campaign_sidebar_layout == 'no'){ echo 'col-md-12 col-sm-12 col-lg-12'; }else{ echo 'col-md-12 col-sm-12 col-lg-9'; } ?>">
							<div class="post-detail-inner w-100">
								<div class="post-detail-info position-relative w-100">
									<div class="post-info2-inner text-center">
										<div class="post-date2">
											<span class="d-block"><a href = "<?php echo get_day_link( $archive_year, $archive_month, $archive_day);?>"><?php echo get_the_date('d'); ?></a></span>
											<i class="d-block thm-bg"><a href = "<?php echo get_day_link( $archive_year, $archive_month, $archive_day);?>"><?php echo get_the_date('M Y'); ?></a></i>
										</div>
										<div class="post-meta4 w-100">
											<?php if(function_exists('tabligh_get_post_view')){ ?>
												<span class="d-block"><i class="far fa-eye"></i><?php echo tabligh_get_post_view(); ?></span>
											<?php } ?>
											<span class="d-block"><?php echo get_simple_likes_button( $post->ID ); ?></span>
											<span class="d-block"><i class="far fa-comment"></i><?php echo esc_html($comment_count); ?></span>
										</div>
									</div>
									<div class="course-detail-info-wrap w-100">
										<div class="course-detail-info d-flex flex-wrap justify-content-between w-100">
											<div class="course-detail-info-inner">
												<span class="d-block thm-clr"><?php echo get_the_term_list( $post->ID, 'courses-category', '', ', ', '' ); ?></span>
												<h2 class="mb-0"><?php echo get_the_title(); ?></h2>
											</div>
											<div class="course-detail-info-inner">
												<a class="thm-btn thm-bg" href="<?php echo esc_url($course_button_url); ?>"><?php echo esc_html($course_button_text); ?><span></span><span></span><span></span><span></span></a>
											</div>
										</div>
										
										<div class="course-detail-info-bottom d-flex flex-wrap align-items-center justify-content-between pat-bg gray-layer opc9 position-relative back-blend-multiply gray-bg w-100" style="<?php echo tabligh_background($image_name = 'pattern-bg.jpg'); ?>">
											<div class="d-inline-flex course-scholar">
												<img class="img-fluid rounded-circle" src="<?php echo esc_url($course_teacher_image); ?>">
												<div class="course-scholar-inner">
													<h5 class="mb-0"><?php echo esc_html($course_teacher_name); ?></h5>
													<span class="d-block thm-clr"><?php echo esc_html($course_teacher_expertise); ?></span>
												</div>
											</div>
											<span class="price thm-clr"><i><?php echo esc_html($course_price_title); ?></i> <?php echo esc_html($course_price_amount); ?></span>
										</div>
									</div>
									<?php /* The Content */
										the_content(); 		
										wp_link_pages( array(
											'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'tabligh' ) . '</span>',
											'after'       => '</div>',
											'link_before' => '',
											'link_after'  => '',
											'pagelink'    => '<span>%</span>',
											'separator'   => '',
										) );
									?>
								</div>
								<?php
								/* Post Tags */
								$posttags = get_the_terms( get_the_ID(), 'courses-tag' );
								$all_tags = array();
								if ($posttags || $course_social_media_tags == 'display'){ ?>
									<div class="share-tags-wrap d-flex flex-wrap w-100">
										<?php if($course_social_media_tags == 'display'){ ?>
											<div class="share-links d-inline-flex">
												<span class="d-inline-block"><?php esc_html_e('Share This: ','tabligh');?></span>
												<div class="social-links4 v2 text-center d-inline-flex">
													<?php if(function_exists('tabligh_post_social_shares')){ echo tabligh_post_social_shares($post->ID); } ?>
												</div>
											</div>
										<?php } 
										if($posttags){ ?>
											<div class="tags-links d-inline-flex">											
												<span class="d-inline-block"><?php esc_html_e('Tags: ','tabligh');?></span>
												<?php 
												foreach($posttags as $tag) {
														$all_tags[] = '<a href = "'.esc_url(get_tag_link($tag->term_id)).'">'.esc_html($tag->name).'</a>';
												}
												
												$echo_tags = implode(', ', $all_tags);
												echo html_entity_decode($echo_tags);
												echo '
											</div>';
										} ?>
									<?php echo '
									</div>';
								} ?>
								
								<?php if($course_author_box == 'false'){ ?>
										<div class="author-box-wrap w-100">
											<?php if($course_author_intro_title){ ?><h3 class="mb-0"><?php echo esc_html($course_author_intro_title); ?></h3><?php } ?>
											<div class="author-box d-flex flex-wrap pat-bg gray-layer opc8 position-relative back-blend-multiply gray-bg w-100" style="<?php echo tabligh_background('pattern-bg.jpg'); ?>">
												<div class="author-img">
													<img class="img-fluid w-100" src="<?php echo esc_url($avatar_url_large); ?>" alt="<?php esc_attr__('Author Image','tabligh'); ?>">
												</div>
												<div class="author-info">
													<h4 class="mb-0"><?php echo get_the_author_meta( 'display_name' , $post->post_author ); ?></h4> 
													<?php if(!empty(get_the_author_meta('designation'))) { ?>	
														<small class="thm-clr">(<?php echo esc_html(get_the_author_meta('designation')); ?>)</small> 
													<?php } ?>
													<p class="mb-0"><?php echo nl2br(get_the_author_meta('description')); ?></p>
													<div class="author-social d-inline-flex">
														<span class="d-inline-block"><?php echo esc_html('STAY CONNECTED:','tabligh'); ?></span>
														<div class="author-social-inner d-inline-flex">
														<?php if(!empty(get_the_author_meta('twitter'))) { ?>
															<a href="<?php echo esc_url(get_the_author_meta('twitter')); ?>" title="<?php esc_attr__('Twitter','tabligh'); ?>" target="_blank"><i class="fab fa-twitter"></i></a>
														<?php } ?>
														<?php if(!empty(get_the_author_meta('facebook'))) { ?>	
															<a href="<?php echo esc_url(get_the_author_meta('facebook')); ?>" title="<?php esc_attr__('Faceboook','tabligh'); ?>" target="_blank"><i class="fab fa-facebook-f"></i></a>
														<?php } ?>	
														<?php if(!empty(get_the_author_meta('linkedin'))) { ?>	
															<a href="<?php echo esc_url(get_the_author_meta('linkedin')); ?>" title="<?php esc_attr__('LinkedIn','tabligh'); ?>" target="_blank"><i class="fab fa-linkedin-in"></i></a>
														<?php } ?>	
														</div>
													</div>
												</div>
											</div>
										</div><!-- Author Box Wrap -->
								<?php } ?>
								<?php /* Comments list Template */ if ( comments_open() || get_comments_number() ) : comments_template(); endif; ?>
								<?php if (comments_open()){ ?> 
								<div class = "comment-reply w-100">
									<?php /* comment Form */
									$post_commenter = wp_get_current_commenter();
									$req = get_option( 'require_name_email' );
									$aria_req = ( $req ? " aria-required='true'" : '' );
									if(function_exists('tabligh_comment_form_temp')){ ?>
										<div class = "comment-reply w-100"><?php echo tabligh_comment_form_temp($post_commenter, $req, $aria_req ); ?></div>
									<?php 
									}
									?>
								</div>
								<?php } ?>
							</div>
						</div>
						<?php /* Right Sidebar */
						if($courses_sidebar_layout == 'right'){ ?>
							<div class="col-md-6 col-sm-6 col-lg-3">
                                <aside class="sidebar w-100">
									<?php dynamic_sidebar( $courses_sidebar_selected ); ?>
								</aside>
							</div>
						<?php } /*endif */ ?>
					</div>
				</div><!-- Post Detail Wrap -->
			</div>
		</div>
	</section>
	
	<?php 
	}/*end of while statement*/

} /*end of if statement*/
get_footer(); ?>