<?php
/**
 * Demo Data support.
 *
 * @package
 */

/*Disable PT branding.*/
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );

/**
 * Demo Data files.
 *
 * @since 1.0.0
 *
 * @return array Files.
 */
	
function tabligh_import_files() {
    return array(
        array(
            'import_file_name'           => 'Demo Import 1',
            'import_file_url'            => trailingslashit( get_template_directory_uri() ) . '/inc/dummy-data/dummy-data-files/elementor/content.xml',
            'import_widget_file_url'     => trailingslashit( get_template_directory_uri() ) . '/inc/dummy-data/dummy-data-files/elementor/widgets.wie',
            'import_redux'               => array(
                array(
                    'file_url'    => trailingslashit( get_template_directory_uri() ) . '/inc/dummy-data/dummy-data-files/elementor/theme-options.json',
                    'option_name' => 'tabligh_options',
                ),
            ),
            'import_preview_image_url'   => trailingslashit( get_template_directory_uri() ) . '/inc/dummy-data/dummy-data-files/elementor/screen-image.jpg',
            'import_notice'              => esc_html__( 'After you import this demo, you will have similar site like Preview Version.', 'tabligh' ),
            'preview_url'                => 'https://tabligh.nauthemes.com/',
        ),
    );
}
add_filter( 'pt-ocdi/import_files', 'tabligh_import_files' );


/**
 * Demo Data after import.
 *
 * @since 1.0.0
 */

function tabligh_after_import_setup() {

    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Primary Menu', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array(
        'header-menu' => $main_menu->term_id
    )
);


    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'HomePage 1' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );



}
add_action( 'pt-ocdi/after_import', 'tabligh_after_import_setup' );