<?php
/*
 * This file is used to generate WordPress standard archive/category pages.
 */
	get_header();
	
	/* Get Inner Header */ 
	if(function_exists('tabligh_secondary_header')) {
		tabligh_secondary_header('', ''); 
	}
	
	/* Variable Redux Options */
	global $tabligh_options;
	
	/* 1. Set Sidebar Layout */
	$default_page_layout_style = $tabligh_options['sidebar-layout']; ?>

	
	
	<section>
		<div class="gap">
			<div class="container">
				<div class="w-100 pt-100 pb-100 position-relative tt-block">
					<div class="row">	
					<!-- Content Section Start -->
					<div class="content-section <?php if(is_active_sidebar('default-sidebar')){ echo 'col-md-9 col-sm-12 col-lg-9'; }else{ echo 'col-md-12';} ?>">	
					<?php /* Loop */ if ( have_posts() ) { ?>
					    <div class="blg-pst-wrp">	
							<?php /* Loop Starts */
							while ( have_posts() ) : the_post(); global $post;
							$tabligh_post_format = get_post_format();
							/* Post Tags */
							$posttags = get_the_tags();
							/* Post Categories */
							$post_categories = wp_get_post_categories( $post->ID );
							/* Cats Array */
							$cats = array(); 
							/* Archive URL */
							$archive_year  = get_the_time('Y'); 
							$archive_month = get_the_time('m'); 
							$archive_day   = get_the_time('d'); 
							
							$user = wp_get_current_user($post->ID);
							$avatar_url = get_avatar_url($user->ID, array("size"=>32));
							/* Get Author ID */
							$author_id = $post->post_author;
							$featured_image_url = get_the_post_thumbnail_url($post->ID, 'tabligh-post-detail');
							/* Sticky Class  */
							if(is_sticky($post->ID)){ $sticky_class = 'sticky'; }else{ $sticky_class = '';} ?> 
								<!-- Post Body Controller -->
								<div <?php post_class('tt-posts'); ?>>
									<?php if(has_post_thumbnail()){ ?> 
									<div class="post-img2 post-info2">
										<div class="post-info2-inner text-center">
											<div class="post-date2">
												<span class="d-block"><?php echo get_the_date('d'); ?></span>
												<i class="d-block thm-bg"><?php echo get_the_date('M Y'); ?></i>
											</div>
										</div>
										<?php echo get_the_post_thumbnail($post->ID, 'tabligh-post-detail', array( 'class' => 'img-fluid w-100' ));?>
									</div>
									<?php } /*endif*/ ?>
									<div class="post-info2">
										<ul class="post-meta2 d-inline-flex flex-wrap align-items-center mb-0 list-unstyled">
											<?php if($avatar_url){ ?>
												<li class="thm-clr"><i class="far fa-edit"></i><?php esc_html_e('Wriiten By:','tabligh'); ?> <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php echo get_the_author_meta( 'display_name' , $post->post_author ); ?></a></li>
											<?php } ?>
										</ul>
										<h3 class="mb-0"><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h3>
										<p class="mb-0"><?php echo wp_trim_words( get_the_content(), 20, '...' ); ?></p>
										<a class="thm-btn thm-bg" href="<?php echo get_the_permalink(); ?>"><?php esc_html_e('Continue Reading','tabligh'); ?><span></span><span></span><span></span><span></span></a>
									</div>
								</div>
								
							<?php endwhile; /*endwhile */ 
							if(function_exists('tabligh_numeric_posts_nav')){ ?>
								<div class="pagination-wrap mt-60 d-flex flex-wrap justify-content-center text-center w-100">
									<ul class="pagination mb-0">
										<?php echo tabligh_numeric_posts_nav(); ?>
									</ul>
								</div>
							<?php }
						} /* endif */ ?>
						</div>
					</div>
					<?php
					/* Right Sidebar */
					  if($default_page_layout_style == 'right' || empty($default_page_layout_style)){ ?>
						<div id="right-sidebar" class="wpb_widgetised_column col-md-3">
							<aside>
								<div class="sidebar_wrapper">
									<?php 
										if(is_active_sidebar('default-sidebar')){
											dynamic_sidebar( 'default-sidebar' );
										} 
									?>
								</div>
							</aside>
						</div>
					<?php } /*endif */ ?>	      						
				</div>
			</div>
		</div>
	</section>
	
<?php get_footer(); ?>