<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage alke
 * @since 1.0
 * @version 1.0
 */
get_header(); ?>

<!-- subheader begin -->
<div class="section padding-page-top padding-bottom over-hide background-dark-2">
    <div class="container">
        <div class="row">
            <div class="col-12 section-title-wrap text-center parallax-fade-top">
                <h1><?php the_title(); ?></h1>
            </div>
        </div>  
    </div>
</div>
<!-- subheader close -->

<!-- content begin -->
<div class="section padding-bottom-big over-hide background-dark-2">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="blog-list">
                	<?php while ( have_posts() ) : the_post(); ?>
                		<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>							
    						<div class="entry-content background-dark-1 over-hide">
                                <div class="padding-in">
    							<?php
    								the_content();

    								wp_link_pages( array(
    									'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'alke' ),
    									'after'  => '</div>',
    								) );
    							?>
                                </div>
    						</div><!-- .entry-content -->
    					</article><!-- #post-## -->
    						
    					<?php 
    						// If comments are open or we have at least one comment, load up the comment template.
    						if ( comments_open() || get_comments_number() ) :
    							comments_template();
    						endif;
    					?>
    				<?php endwhile; // End of the loop. ?>      
                </div>          	                                        
            </div>
            <div class="col-lg-4 mt-4 mt-lg-0">   
                <div class="sidebar-box background-dark-1 drop-shadow rounded">                
                    <?php get_sidebar(); ?>
                </div>
            </div>
        </div>

    </div>
</div>
<!-- content close -->

<?php get_footer();
