<?php
/*
 * Template Name: Hero Slider
 * Description: A Page Template with a Page Builder design.
 */
?>
<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage alke
 * @since 1.0
 * @version 1.0
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">

<?php wp_head(); ?>
</head>
<body <?php body_class('over-hide'); ?>>
    <div class="animsition">
    <!-- Nav and Logo
    ================================================== -->
    <header class="cd-header">
        <div class="header-wrapper">
            <div class="logo-wrap">
                <a href="<?php echo esc_url( home_url('/') ); ?>" class="cursor-link animsition-link">
                    <img src="<?php echo esc_url( alke_get_option( 'logo' ) ); ?>" alt="">
                </a>
            </div>
            <div class="nav-but-wrap">
                <div class="menu-icon cursor-link">
                    <span class="menu-icon__line menu-icon__line-left"></span>
                    <span class="menu-icon__line"></span>
                    <span class="menu-icon__line menu-icon__line-right"></span>
                </div>                  
            </div>                  
        </div>              
    </header>
    <div class="nav">
        <div class="nav__content">
            <?php
                $primary = array(
                    'theme_location'  => 'primary',
                    'menu'            => '',
                    'container'       => '',
                    'container_class' => '',
                    'container_id'    => '',
                    'menu_class'      => '',
                    'menu_id'         => '',
                    'echo'            => true,
                    'fallback_cb'     => 'alke_bootstrap_navwalker::fallback',
                    'walker'          => new alke_bootstrap_navwalker(),
                    'before'          => '',
                    'after'           => '',
                    'link_before'     => '',
                    'link_after'      => '',
                    'items_wrap'      => '<ul class="nav__list">%3$s</ul>',
                    'depth'           => 0,
                );
                if ( has_nav_menu( 'primary' ) ) {
                    wp_nav_menu( $primary );
                }
            ?>
        </div>
    </div>

<?php if (have_posts()){ ?>
	
		<?php while (have_posts()) : the_post()?>
			<?php the_content(); ?>
		<?php endwhile; ?>
	
	<?php }else {
		esc_html_e('Page Canvas For Page Builder', 'alke'); 
	}?>

<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage alke
 * @since 1.0
 * @version 1.2
 */

?>
<div class="social-wrap">
    <?php esc_html_e('follow us','alke'); ?>
    <ul>
        <?php $socials = alke_get_option( 'footer_socials', array() ); ?>
        <?php foreach ( $socials as $social ) { ?>                                  
            <li><a class="cursor-link" href="<?php echo esc_url($social['social_link']); ?>"><?php echo esc_attr($social['social_name']); ?></a></li>                     
        <?php } ?>
    </ul>   
</div>

    <div class="cursor cursor-shadow"></div>
    <div class="cursor cursor-dot"></div>
</div>
    <!-- footer close -->
<?php wp_footer(); ?>

</body>
</html>
