<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage alke
 * @since 1.0
 * @version 1.0
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">

<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
    <div class="animsition">
    <!-- Nav and Logo
    ================================================== -->
    <header class="cd-header">
        <div class="header-wrapper">
            <div class="logo-wrap">
                <a href="<?php echo esc_url( home_url('/') ); ?>" class="cursor-link animsition-link">
                    <img src="<?php echo esc_url( alke_get_option( 'logo' ) ); ?>" alt="<?php echo get_bloginfo( 'name' ); ?>">
                </a>
            </div>
            <div class="nav-but-wrap">
                <div class="menu-icon cursor-link">
                    <span class="menu-icon__line menu-icon__line-left"></span>
                    <span class="menu-icon__line"></span>
                    <span class="menu-icon__line menu-icon__line-right"></span>
                </div>                  
            </div>                  
        </div>              
    </header>
    <div class="nav">
        <div class="nav__content">
            <?php
                $primary = array(
                    'theme_location'  => 'primary',
                    'menu'            => '',
                    'container'       => '',
                    'container_class' => '',
                    'container_id'    => '',
                    'menu_class'      => '',
                    'menu_id'         => '',
                    'echo'            => true,
                    'fallback_cb'     => 'alke_bootstrap_navwalker::fallback',
                    'walker'          => new alke_bootstrap_navwalker(),
                    'before'          => '',
                    'after'           => '',
                    'link_before'     => '',
                    'link_after'      => '',
                    'items_wrap'      => '<ul class="nav__list">%3$s</ul>',
                    'depth'           => 0,
                );
                if ( has_nav_menu( 'primary' ) ) {
                    wp_nav_menu( $primary );
                }
            ?>
        </div>
    </div>