<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package WordPress
 * @subpackage alke
 * @since 1.0
 */


if ( ! function_exists( 'alke_entry_meta' ) ) :
/**
 * Prints HTML with meta information for the current post-date/time and author.
 */
function alke_entry_meta() {

$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
  if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
    $time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><!--<time class="updated" datetime="%3$s">%4$s</time>-->';
  }

  $time_string = sprintf( $time_string,
    esc_attr( get_the_date( 'c' ) ),
    esc_html( get_the_date() ),
    esc_attr( get_the_modified_date( 'c' ) ),
    esc_html( get_the_modified_date() )
  );

  $posted_on = sprintf(
    esc_html_x( '%s', 'post date', 'alke' ),
    //'<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>'
        $time_string . ''
  );

    echo '' . $posted_on . ''; // WPCS: XSS OK.

}
endif;

//pagination
if ( ! function_exists( 'alke_pagination' ) ) :
function alke_pagination($prev = '<i class="fa fa-long-arrow-left" aria-hidden="true"></i>', $next = '<i class="fa fa-long-arrow-right" aria-hidden="true"></i>', $pages='') {
    global $wp_query, $wp_rewrite;
    $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;
    if($pages==''){
        global $wp_query;
         $pages = $wp_query->max_num_pages;
         if(!$pages)
         {
             $pages = 1;
         }
    }
    $pagination = array(
		'base' 			=> str_replace( 999999999, '%#%', get_pagenum_link( 999999999 ) ),
		'format' 		=> '',
		'current' 		=> max( 1, get_query_var('paged') ),
		'total' 		=> $pages,
		'prev_text' => $prev,
        'next_text' => $next,		
        'type'			=> 'list',
		'end_size'		=> 3,
		'mid_size'		=> 3
    );
    $return =  paginate_links( $pagination );
	echo str_replace( "<ul class='page-numbers'>", "<ul class='blog-pagination'>", $return );
}
endif;

if ( ! function_exists( 'alke_custom_wp_admin_style' ) ) :
function alke_custom_wp_admin_style() {

        wp_register_style( 'alke_custom_wp_admin_css', get_template_directory_uri() . '/assets/admin/admin-style.css', false, '1.0.0' );
        wp_enqueue_style( 'alke_custom_wp_admin_css' );

        wp_enqueue_script( 'alke-backend-js', get_template_directory_uri()."/assets/admin/admin-script.js", array( 'jquery' ), '1.0.0', true );
        wp_enqueue_script( 'alke-backend-js' );
}
add_action( 'admin_enqueue_scripts', 'alke_custom_wp_admin_style' );
endif;

if ( ! function_exists( 'alke_search_form' ) ) :
/* Custom form search */
function alke_search_form( $form ) {
    $form = '<form class="subscribe-box" role="search" method="get" action="' . esc_url(home_url( '/' )) . '" >  
        <input type="search" id="search" class="search-query form-control cursor-link" value="' . get_search_query() . '" name="s" placeholder="'.esc_attr__('type here here&hellip;', 'alke').'" />
        
        <button class="subscribe-1 cursor-link" type="search" data-lang="en">search</button>
    </form>';
    return $form;
}
add_filter( 'get_search_form', 'alke_search_form' );
endif;

/* Custom comment List: */
function alke_theme_comment($comment, $args, $depth) {    
   $GLOBALS['comment'] = $comment;
?>
   <div class="section">
   		<?php echo get_avatar($comment,$size='40',$default='http://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536' ); ?>
      <h6><?php printf('%s', get_comment_author()) ?> <small><?php comment_date('M d, Y'); ?> <?php esc_html_e('at','alke'); ?> <?php the_time(); ?></small></h6>
    		<?php if ($comment->comment_approved == '0'){ ?>
    			 <p><em><?php esc_html_e('Your comment is awaiting moderation.','alke') ?></em></p>
    		<?php }else{ ?>
            <?php comment_text() ?>
         <?php } ?>		
	     <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
       
    </div> 
    <div class="separator-wrap pt-4 pb-4">  
      <span class="separator"><span class="separator-line dashed"></span></span>
    </div>
<?php
}
if ( ! function_exists( 'alke_excerpt_length' ) ) :
/**** Change length of the excerpt ****/
function alke_excerpt_length() {
      global $alke_option;
      if(alke_get_option('blog_excerpt')!=''){
        $limit = alke_get_option('blog_excerpt');
      }else{
        $limit = 15;
      }  
      $excerpt = explode(' ', get_the_excerpt(), $limit);

      if (count($excerpt)>=$limit) {
        array_pop($excerpt);
        $excerpt = implode(" ",$excerpt).'...';
      } else {
        $excerpt = implode(" ",$excerpt);
      } 
      $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
      return $excerpt;
}
endif;
if ( ! function_exists( 'alke_excerpt' ) ) :
/** Excerpt Section Blog Post **/
function alke_excerpt($limit) {
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
  } else {
    $excerpt = implode(" ",$excerpt);
  }
  $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
  return $excerpt;
}
endif;

if ( ! function_exists( 'alke_tag_cloud_widget' ) ) :
/**custom function tag widgets**/
function alke_tag_cloud_widget($args) {
    $args['number'] = 0; //adding a 0 will display all tags
    $args['largest'] = 13; //largest tag
    $args['smallest'] = 13; //smallest tag
    $args['unit'] = 'px'; //tag font unit
    $args['format'] = 'list'; //ul with a class of wp-tag-cloud
    $args['exclude'] = ''; //exclude tags by ID
    return $args;
}
add_filter( 'widget_tag_cloud_args', 'alke_tag_cloud_widget' );
endif;

/** Move comment field bottom **/
function wpb_move_comment_field_to_bottom( $fields ) {
$comment_field = $fields['comment'];
unset( $fields['comment'] );
$fields['comment'] = $comment_field;
return $fields;
}
add_filter( 'comment_form_fields', 'wpb_move_comment_field_to_bottom' );

function alke_mime_types($mimes) {
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}
add_filter('upload_mimes', 'alke_mime_types');