<?php
/**
 * alke theme customizer
 *
 * @package alke
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Alke_Customize {
	/**
	 * Customize settings
	 *
	 * @var array
	 */
	protected $config = array();

	/**
	 * The class constructor
	 *
	 * @param array $config
	 */
	public function __construct( $config ) {
		$this->config = $config;

		if ( ! class_exists( 'Kirki' ) ) {
			return;
		}

		$this->register();
	}

	/**
	 * Register settings
	 */
	public function register() {
		/**
		 * Add the theme configuration
		 */
		if ( ! empty( $this->config['theme'] ) ) {
			Kirki::add_config(
				$this->config['theme'], array(
					'capability'  => 'edit_theme_options',
					'option_type' => 'theme_mod',
				)
			);
		}

		/**
		 * Add panels
		 */
		if ( ! empty( $this->config['panels'] ) ) {
			foreach ( $this->config['panels'] as $panel => $settings ) {
				Kirki::add_panel( $panel, $settings );
			}
		}

		/**
		 * Add sections
		 */
		if ( ! empty( $this->config['sections'] ) ) {
			foreach ( $this->config['sections'] as $section => $settings ) {
				Kirki::add_section( $section, $settings );
			}
		}

		/**
		 * Add fields
		 */
		if ( ! empty( $this->config['theme'] ) && ! empty( $this->config['fields'] ) ) {
			foreach ( $this->config['fields'] as $name => $settings ) {
				if ( ! isset( $settings['settings'] ) ) {
					$settings['settings'] = $name;
				}

				Kirki::add_field( $this->config['theme'], $settings );
			}
		}
	}

	/**
	 * Get config ID
	 *
	 * @return string
	 */
	public function get_theme() {
		return $this->config['theme'];
	}

	/**
	 * Get customize setting value
	 *
	 * @param string $name
	 *
	 * @return bool|string
	 */
	public function get_option( $name ) {
		if ( ! isset( $this->config['fields'][$name] ) ) {
			return false;
		}

		$default = isset( $this->config['fields'][$name]['default'] ) ? $this->config['fields'][$name]['default'] : false;

		return get_theme_mod( $name, $default );
	}
}

/**
 * This is a short hand function for getting setting value from customizer
 *
 * @param string $name
 *
 * @return bool|string
 */
function alke_get_option( $name ) {
	global $alke_customize;

	if ( empty( $alke_customize ) ) {
		return false;
	}

	if ( class_exists( 'Kirki' ) ) {
		$value = Kirki::get_option( $alke_customize->get_theme(), $name );
	} else {
		$value = $alke_customize->get_option( $name );
	}

	return apply_filters( 'alke_get_option', $value, $name );
}

/**
 * Move some default sections to `general` panel that registered by theme
 *
 * @param object $wp_customize
 */
function alke_customize_modify( $wp_customize ) {
	$wp_customize->get_section( 'title_tagline' )->panel     = 'general';
	$wp_customize->get_section( 'static_front_page' )->panel = 'general';
}
add_action( 'customize_register', 'alke_customize_modify' );

/**
 * Customizer configuration
 */
$alke_customize = new Alke_Customize(
	array(
		'theme'    => 'alke',

		'panels'   => array(
			'general' => array(
				'priority' => 10,
				'title'    => esc_attr__( 'General', 'alke' ),
			),	
			'header_panel' => array(
				'priority' => 15,
				'title'    => esc_attr__( 'Header', 'alke' ),
			),		
			'footer_panel' => array(
				'priority' => 179,
				'title'    => esc_attr__( 'Footer', 'alke' ),
			),		
		),

		'sections' => array(

			'header_logo_section' => array(
			    'title'          => esc_attr__( 'Logo', 'alke' ),
			    'description' => '',
			    'panel'          => 'header_panel', // Not typically needed.
			    'priority'       => 50,
			    'capability'     => 'edit_theme_options',
			),		

			'header_styling_section' => array(
				'title'    => esc_attr__( 'Styling', 'alke' ),
				'description' => '',
				'panel'          => 'header_panel', // Not typically needed.
				'priority'    => 61,
				'capability'  => 'edit_theme_options',
			),

			// Section Blog
			'blog_section'     => array(
				'title'       => esc_attr__( 'Blog', 'alke' ),
				'description' => '',
				'priority'    => 170,
				'capability'  => 'edit_theme_options',
			),

			// Section Footer
			'footer_section'     => array(
				'title'       => esc_attr__( 'Footer Content', 'alke' ),
				'description' => '',
				'panel'		  => 'footer_panel',
				'priority'    => 180,
				'capability'  => 'edit_theme_options',
			),
			'footer_social_section'     => array(
				'title'       => esc_attr__( 'Footer Socials', 'alke' ),
				'description' => '',
				'panel'		  => 'footer_panel',
				'priority'    => 181,
				'capability'  => 'edit_theme_options',
			),
			'footer_styling_section'     => array(
				'title'       => esc_attr__( 'Footer Styling', 'alke' ),
				'description' => '',
				'panel'		  => 'footer_panel',
				'priority'    => 182,
				'capability'  => 'edit_theme_options',
			),

			// Section Styling
			'styling_section'     => array(
				'title'       => esc_attr__( 'Styling', 'alke' ),
				'description' => '',
				'priority'    => 190,
				'capability'  => 'edit_theme_options',
			),		
		),

		'fields'   => array(

			// Header Logo
			'logo'         => array(
				'type'     => 'image',
				'label'    => esc_attr__( 'Logo Static', 'alke' ),
				'description' => esc_attr__( 'Upload your logo static here', 'alke' ),
				'section'  => 'header_logo_section',
				'default'  => trailingslashit( get_template_directory_uri() ) . 'assets/img/logo.png',
				'priority' => 51,
			),		
				
			// Header Styling
			'header_text_color'    => array(
				'type'     => 'color',
				'label'    => esc_attr__( 'Header Static Menu Item Color', 'alke' ),
				'description' => esc_attr__( 'Set your header text color.', 'alke' ),
				'section'     => 'header_styling_section',
				'default'     => 'rgba(255,255,255,1)',
				'priority'    => 10,
				'choices'     => array(
					'alpha' => true,
				),
				'output' => array(
					array(
						'element'  => '.nav__list-item a',
						'property' => 'color',
					),
				),
			),
			'header_active_hover_text_color'    => array(
				'type'     => 'color',
				'label'    => esc_attr__( 'Header Active and Hover Menu Item Color', 'alke' ),
				'description' => esc_attr__( 'Set your header active and hover text color.', 'alke' ),
				'section'     => 'header_styling_section',
				'default'     => 'rgba(255,255,255,.4)',
				'priority'    => 12,
				'choices'     => array(
					'alpha' => true,
				),
			),
			'header_bg'         => array(
				'type'     => 'color',
				'label'    => esc_attr__( 'Header Static Background Color', 'alke' ),
				'description' => esc_attr__( 'Set your header background color.', 'alke' ),
				'section'  => 'header_styling_section',
				'default'     => 'rgba(21, 21, 21,0)',
				'priority'    => 13,
				'choices'     => array(
					'alpha' => true,
				),
				'output' => array(
					array(
						'element'  => '.cd-header',
						'property' => 'background-color',
					),
				),
			),
			'header_scroll_bg' => array(
				'type'     => 'color',
				'label'    => esc_attr__( 'Header Scroll Background Color', 'alke' ),
				'description' => esc_attr__( 'Set your header background color.', 'alke' ),
				'section'  => 'header_styling_section',
				'default'     => 'rgba(21, 21, 21, 0.96)',
				'priority'    => 14,
				'choices'     => array(
					'alpha' => true,
				),
				'output' => array(
					array(
						'element'  => '.cd-header.is-fixed',
						'property' => 'background-color',
					),
				),
			),

			//Blog 
			'single_layout'     => array(
				'type'        => 'radio-image',				
				'label'       => esc_html__( 'Select Blog Single Layout', 'alke' ),
				'section'     => 'blog_section',
				'default'     => 'right-bar',
				'priority'    => 8,
				'choices'     => array(
					'no-bar'  => get_template_directory_uri() . '/assets/img/theme-options/1c.png',
					'left-bar'   => get_template_directory_uri() . '/assets/img/theme-options/2cl.png',
					'right-bar' => get_template_directory_uri() . '/assets/img/theme-options/2cr.png',					
				),
			),
			
			// Footer
			'copyright'       => array(
				'type'        => 'textarea',
				'label'       => esc_html__( 'Text Left Footer Bottom', 'alke' ),
				'section'     => 'footer_section',
				'default'     => 'Copyright 2018 - Alke by OceanThemes',
				'priority'    => 10,				
			),
			'socialfooter_switch'     => array(
				'type'        => 'toggle',
				'label'       => esc_attr__( 'Social On/Off?', 'alke' ),
				'section'     => 'footer_social_section',
				'default'     => '1',
				'priority'    => 10,
			),
			'footer_socials'     => array(
				'type'     => 'repeater',
				'label'    => esc_html__( 'Socials Network', 'alke' ),
				'section'  => 'footer_social_section',
				'priority' => 10,
				'active_callback' => array(
					array(
					  	'setting'  => 'socialfooter_switch',
					  	'operator' => '==',
					  	'value'    => 1,
				 	),
				),
				'row_label' => array(
					'type' => 'field',
					'value' => esc_attr__('social', 'alke' ),
					'field' => 'social_name',
				),
				'default'  => array(),
				'fields'   => array(
					'social_name' => array(
						'type'        => 'text',
						'label'       => esc_html__( 'Social network name', 'alke' ),
						'description' => esc_html__( 'This will be the social network name', 'alke' ),
						'default'     => '',
					),
					'social_link' => array(
						'type'        => 'text',
						'label'       => esc_html__( 'Link url', 'alke' ),
						'description' => esc_html__( 'This will be the social link', 'alke' ),
						'default'     => '',
					),
				),
			),
			'bg_color' => array(
				'type'     => 'color',
				'label'    => esc_attr__( 'Footer Background Color', 'alke' ),
				'description' => esc_attr__( 'Set your footer background color.', 'alke' ),
				'section'  => 'footer_styling_section',
				'default'     => '#000000',
				'priority'    => 11,
				'choices'     => array(
					'alpha' => true,
				),
				'output' => array(
					array(
						'element'  => '.footer',
						'property' => 'background-color',
					),
				),
			),
			'color_ft' => array(
				'type'     => 'color',
				'label'    => esc_attr__( 'Footer Color', 'alke' ),
				'description' => esc_attr__( 'Set your footer color.', 'alke' ),
				'section'  => 'footer_styling_section',
				'default'     => '#ffffff',
				'priority'    => 12,
				'choices'     => array(
					'alpha' => true,
				),
				'output' => array(
					array(
						'element'  => '.footer .rights p',
						'property' => 'color',
					),
				),
			),

			//Styling Settings		
			'body_typo_switch'     => array(
				'type'        => 'toggle',
				'label'       => esc_attr__( 'Typography On/Off?', 'alke' ),
				'section'     => 'styling_section',
				'default'     => '1',
				'priority'    => 10,
			),

			'body_typo' => array(
				'type'        => 'typography',
				'label'       => esc_attr__( 'Body Font', 'alke' ),
				'section'     => 'styling_section',
				'active_callback' => array(
					array(
					  	'setting'  => 'body_typo_switch',
					  	'operator' => '==',
					  	'value'    => 1,
				 	),
				),
				'default'     => array(
					'font-family'    => 'Open Sans',
					'variant'        => 'regular',
					'font-size'      => '13px',
					'line-height'    => '1.7em',
					'letter-spacing' => '0',
					'subsets'        => array( 'latin-ext' ),
					'color'          => '#888888',
					'text-transform' => 'none',
					'text-align'     => 'left'
				),
				'priority'    => 10,
				'output'      => array(
					array(
						'element' => 'body',
					),
				),
			),

		),
	)
);

/**
 * Add color styling from theme
 */
function alke_custom_styles_method() {
	$menu_hover_color = alke_get_option('header_active_hover_text_color');
    $custom_css = "
		.nav__list-item a:hover, .nav__list-item.current-menu-parent a{
			color: {$menu_hover_color};
		}

		
		";

    wp_add_inline_style( 'alke-style', $custom_css );
}
add_action( 'wp_enqueue_scripts', 'alke_custom_styles_method' );

