<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage alke
 * @since 1.0
 * @version 1.2
 */

?>
	
    <!-- footer close -->
	<div class="section footer padding-top-bottom-small background-black">	
		<div class="container-fluid px-5">
			<div class="row">
				<div class="col-md-6 footer text-center text-md-left">
					<p><?php echo wp_specialchars_decode(alke_get_option('copyright')) ?></p>	
				</div>
				<?php if(alke_get_option('socialfooter_switch')!=false){ ?>
				<div class="col-md-6 mt-4 mt-md-0 text-center">
					<div class="social-wrap on-footer">
						<?php esc_html_e('follow us','alke'); ?>
						<ul>
							<?php $socials = alke_get_option( 'footer_socials', array() ); ?>
					        <?php foreach ( $socials as $social ) { ?>                                  
					            <li><a class="cursor-link" href="<?php echo esc_url($social['social_link']); ?>"><?php echo esc_attr($social['social_name']); ?></a></li>                     
					        <?php } ?>
						</ul>	
					</div>
				</div>	
				<?php } ?>
			</div>	
		</div>			
	</div>
	<div class="scroll-to-top cursor-link"></div>
	<div class="cursor cursor-shadow"></div>
	<div class="cursor cursor-dot"></div>
</div>
<?php wp_footer(); ?>

</body>
</html>
