<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage alke
 * @since 1.0
 * @version 1.0
 */
get_header(); ?>

<!-- subheader begin -->
<div class="section padding-page-top padding-bottom over-hide background-dark-2">
	<div class="container">
		<div class="row">
			<div class="col-12 section-title-wrap text-center parallax-fade-top">
				<?php while ( have_posts() ) : the_post(); ?>
				<p><?php esc_html_e('by ','alke'); ?> <?php the_author(); ?></p>
				<?php endwhile; ?>	
				<h3><?php the_title(); ?></h3>
			</div>
		</div>	
	</div>
</div>
<!-- subheader close -->

<!-- content begin -->
<div class="section padding-bottom-big over-hide background-dark-2">
	<div class="container">
		<div class="row justify-content-center">
		    <?php if(alke_get_option('single_layout')== 'left-bar'){ ?>
	        <div class="col-lg-4 mb-4 mb-lg-0">   
	            <div class="sidebar-box background-white drop-shadow rounded">                
	                <?php get_sidebar(); ?>
	            </div>
	        </div>
	        <?php } ?> 
		    <div class="<?php if( alke_get_option('blog_layout') == 'no-bar' ){ echo 'col-lg-12'; }else{ echo 'col-lg-8'; } ?>">
		    	<div class="section drop-shadow rounded">
		    		<div class="post-box background-dark-1 over-hide">
						<?php 
							/* Start the Loop */
							while ( have_posts() ) : the_post(); 
						?>    
		                	<?php $link_audio = get_post_meta(get_the_ID(),'_cmb_link_audio', true); ?>
		                    <?php if ( 'audio' == get_post_format() ) { ?>
		                    	<div class="post-audio">
						            <iframe style="width:100%;border:none;" height="150" scrolling="no" src="<?php echo esc_url( $link_audio ); ?>"></iframe>
						        </div> 
		                    <?php }elseif ( 'gallery' == get_post_format() ) { ?>
		                    	<div id="owl-blog-slider" class="owl-carousel owl-theme">
						            <?php if( function_exists( 'rwmb_meta' ) ) { ?>
						              <?php $images = rwmb_meta( '_cmb_images', "type=image" ); ?>
						              <?php if($images){ ?>                  
						                  <?php foreach ( $images as $image ) { ?>
						                    <?php $img = $image['full_url']; ?>
						                    <div class="item"><img src="<?php echo esc_url($img); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>"></div> 
						                  <?php } ?>                                     
						              <?php } ?>
						            <?php } ?>
						        </div>		                    
		                    <?php }elseif ( 'video' == get_post_format() ) { ?>
		                    	<div class="post-video">
						            <?php if( function_exists( 'rwmb_meta' ) ) { ?>
								    <?php $link_video = get_post_meta(get_the_ID(),'_cmb_link_video', true); if($link_video) { ?>
								    <?php echo rwmb_meta( '_cmb_link_video', 'type=oembed' ); ?>
								<?php } } ?>      
						        </div>
		                    <?php }elseif ( 'image' == get_post_format() ) { ?>
		                    	<div class="post-image">
						            <?php if( function_exists( 'rwmb_meta' ) ) { ?>
						                <?php $images = rwmb_meta( '_cmb_image', "type=image" ); ?>
						                <?php $images_demo = rwmb_meta( '_cmb_image_demo', "type=image" ); ?>
						                <?php if($images_demo !=''){ ?>
						                	<?php  foreach ( $images_demo as $image_demo ) {  ?>
						                        <?php $img_demo = $image_demo['full_url']; ?>
						                        <img src="<?php echo esc_url($img_demo); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>" class="blog-home-img">
						                    <?php } ?>
						                <?php }elseif($images != ''){ ?>              
						                    <?php  foreach ( $images as $image ) {  ?>
						                        <?php $img = $image['full_url']; ?>
						                        <img src="<?php echo esc_url($img); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name' ) ); ?>" class="blog-home-img">
						                    <?php } ?>                
						                <?php }else{ ?>
						                    <?php 
						                        if( has_post_thumbnail() ){               
						                             the_post_thumbnail( 'full', array( 'class' => 'blog-home-img' ) ); 
						                        } 
						                    ?>
						                <?php } ?>
						            <?php } ?>
						        </div>   
		                    <?php }else{ ?>              	
		                    	<p></p>
		                    <?php } ?>

		                    <?php the_content(); ?>
 
				       	<div class="padding-in">
					       	<div class="separator-wrap pt-4 pb-4">	
								<span class="separator"><span class="separator-line dashed"></span></span>
							</div> 
							<?php
	                          if(get_the_tag_list()) {
	                              echo get_the_tag_list('<ul class="tag-list"><li>','</li><li>','</a></li></ul>');
	                          }
	                        ?>
	                        <div class="separator-wrap pt-4 pb-4">	
								<span class="separator"><span class="separator-line dashed"></span></span>
							</div>
	                    	<div class="author-wrap">
								<?php echo get_avatar($comment,$size='60',$default='http://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=180' ); ?>
								<p> <?php esc_html_e('by ','alke'); ?> <?php the_author_posts_link(); ?></p>
							</div>
                    	</div>
				       	<?php endwhile; // End of the loop. ?>  
			       </div>
		       	</div>
				<div class="section drop-shadow rounded mt-4">	
					<div class="post-comm-box background-dark-1 over-hide">
						<?php 
							// If comments are open or we have at least one comment, load up the comment template.
							if ( comments_open() || get_comments_number() ) :
								comments_template();
							endif;
						?>
					</div>
				</div>
		    </div>
		    <?php if(alke_get_option('single_layout')== 'right-bar'){ ?>
	        <div class="col-lg-4 mt-4 mt-lg-0">   
	            <div class="sidebar-box background-dark-1 drop-shadow rounded">                
	                <?php get_sidebar(); ?>
	            </div>
	        </div>
	        <?php } ?>  
	        <?php while ( have_posts() ) : the_post(); ?>
	            <div class="col-md-12 text-center padding-top" data-scroll-reveal="enter bottom move 30px over 0.5s after 0.2s">
	            <?php previous_post_link( '%link', _x( '<div class="project-link-wrap"><p>'.esc_html__('old','alke').'</p><h4>'.esc_html__('older entries','alke').'</h4></div>', '', 'alke' ) ); ?> 
	            <?php next_post_link( '%link', _x( '<div class="project-link-wrap"><p>'.esc_html__('new','alke').'</p><h4>'.esc_html__('new entries','alke').'</h4></div>', '', 'alke' ) ); ?>
	            </div>
        	<?php endwhile; ?>
        </div>    	   	
	</div>
</div> 

<!-- content close -->

<?php get_footer();
