<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package WordPress
 * @subpackage alke
 * @since 1.0
 * @version 1.0
 */
get_header(); ?>


<!-- subheader begin -->
<div class="section padding-page-top padding-bottom over-hide background-dark-2">
    <div class="container">
        <div class="row">
            <div class="col-12 section-title-wrap text-center parallax-fade-top">
                <?php if ( have_posts() ) : ?>
                <h3><?php printf( esc_html__( 'Search Results for: %s', 'alke' ), '<span>' . get_search_query() . '</span>' ); ?></h3>
                <?php else : ?>
                    <h3><?php esc_html_e( 'Nothing Found', 'alke' ); ?></h3>
                <?php endif; ?>
            </div>
        </div>  
    </div>
</div>
<!-- subheader close -->

<!-- content begin -->
<div class="section padding-bottom-big over-hide background-dark-2">
    <div class="container">
        <div class="row justify-content-center">
            <?php
            if ( have_posts() ) :
            	/* Start the Loop */
            	while ( have_posts() ) : the_post();

            		/**
            		 * Run the loop for the search to output the results.
            		 * If you want to overload this in a child theme then include a file
            		 * called content-search.php and that will be used instead.
            		 */
            		get_template_part( 'template-parts/post/content', get_post_format() );

            	endwhile; // End of the loop.

            else : ?>
                <p><?php esc_html__( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'alke' ); ?></p>
                
                <?php get_search_form(); ?>
            <?php endif; ?>  

            <?php if ($wp_query->max_num_pages > 1) { ?>
            <div class="col-md-12 text-center padding-top" data-scroll-reveal="enter bottom move 30px over 0.5s after 0.2s">
                    <?php previous_posts_link( '<div class="project-link-wrap"><p>'.esc_html__('new','alke').'</p><h4>'.esc_html__('new entries','alke').'</h4></div>' ); ?>
                    <?php next_posts_link( '<div class="project-link-wrap"><p>'.esc_html__('old','alke').'</p><h4>'.esc_html__('older entries','alke').'</h4></div>' ); ?>
            </div>
            <?php } ?>
            
        </div>
    </div>
</div>


<!-- content close -->

<!-- content close -->
<?php get_footer();
