<?php
/**
 * Template Name: Blog
 */
$sub = get_post_meta(get_the_ID(),'_cmb_subtitle', true);
get_header(); ?>
<!-- subheader begin -->
<div class="section padding-page-top padding-bottom over-hide background-dark-2">
    <div class="container">
        <div class="row">
            <div class="col-12 section-title-wrap text-center parallax-fade-top">
                <p><?php the_title(); ?></p> 
                <h1><?php esc_html_e('a place full','alke'); ?><br><?php esc_html_e('of stuff','alke'); ?></h1>
            </div>
        </div>  
    </div>
</div>
<!-- subheader close -->

<!-- content begin -->
<div class="section padding-bottom-big over-hide background-dark-2">
    <div class="container">
        <div class="row justify-content-center">
        <?php if(have_posts()) : ?>  
            <?php 
                $args = array(    
                  'paged' => $paged,
                  'post_type' => 'post',
                );
                $wp_query = new WP_Query($args);
                while ($wp_query -> have_posts()): $wp_query -> the_post();                         
                /*
                 * Include the Post-Format-specific template for the content.
                 * If you want to override this in a child theme, then include a file
                 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
                 */
                get_template_part( 'template-parts/post/content', get_post_format() );
            ?> 
        <?php endwhile;?>         
        <?php else: ?>
            <h1><?php esc_html_e('Nothing Found Here!', 'alke'); ?></h1>
        <?php endif; ?>        

        <?php if ($wp_query->max_num_pages > 1) { ?>
        <div class="col-md-12 text-center padding-top pagination-alke" data-scroll-reveal="enter bottom move 30px over 0.5s after 0.2s">
                <?php previous_posts_link( '<div class="project-link-wrap"><p>older</p><h4>news</h4></div>' ); ?>
                <?php next_posts_link( '<div class="project-link-wrap"><p>new</p><h4>news</h4></div>' ); ?>
        </div>
        <?php } ?>
        </div>
    </div>
</div>
<!-- content close -->

<?php get_footer(); ?>