<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage alke
 * @since 1.0
 * @version 1.0
 */
get_header();
?>

<!-- subheader begin -->
<div class="section padding-page-top padding-bottom over-hide background-dark-2">
    <div class="container">
        <div class="row">
            <div class="col-12 section-title-wrap text-center parallax-fade-top">
                <p><?php esc_html_e('news','alke'); ?></p> 
                <h1><?php echo get_the_title( get_option( 'page_for_posts' ) ); ?></h1>
            </div>
        </div>  
    </div>
</div>
<!-- subheader close -->

<!-- content begin -->
<div class="section padding-bottom-big over-hide background-dark-2">
    <div class="container">
        <div class="row justify-content-center">
            <?php
    			if ( have_posts() ) :

    				/* Start the Loop */
    				while ( have_posts() ) : the_post();

    					/*
    					 * Include the Post-Format-specific template for the content.
    					 * If you want to override this in a child theme, then include a file
    					 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
    					 */
                        get_template_part( 'template-parts/post/content', get_post_format() );

    				endwhile;							

    			else :

    				get_template_part( 'template-parts/post/content', 'none' );

    			endif;
    		?>    
            
            <?php if ($wp_query->max_num_pages > 1) { ?>
            <div class="col-md-12 text-center padding-top" data-scroll-reveal="enter bottom move 30px over 0.5s after 0.2s">
                    <?php previous_posts_link( '<div class="project-link-wrap"><p>'.esc_html__('new','alke').'</p><h4>'.esc_html__('new entries','alke').'</h4></div>' ); ?>
                    <?php next_posts_link( '<div class="project-link-wrap"><p>'.esc_html__('old','alke').'</p><h4>'.esc_html__('older entries','alke').'</h4></div>' ); ?>
            </div>
            <?php } ?>

        </div>
    </div>
</div>
<!-- content close -->

<?php get_footer();
