<?php
/**
 * Alke functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package WordPress
 * @subpackage alke
 * @since 1.0
 */


/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function alke_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on cubic, use a find and replace
	 * to change 'cubic' to the name of your theme in all the template files
	 */

	load_theme_textdomain( 'alke', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );

	// Set the default content width.
	$GLOBALS['content_width'] = 525;

	// This theme uses wp_nav_menu() in two locations.
	register_nav_menus( array(
		'primary'    => esc_html__( 'Main Menu', 'alke' ),	
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 *
	 * See: https://codex.wordpress.org/Post_Formats
	 */
	add_theme_support( 'post-formats', array(
		'image',
		'video',
		'gallery',
		'audio',
	) );

	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, and column width.
 	 */
	add_editor_style( array( 'assets/css/editor-style.css', alke_fonts_url() ) );
}
add_action( 'after_setup_theme', 'alke_setup' );

/**
 * Register custom fonts.
 */
if ( ! function_exists( 'alke_fonts_url' ) ) :
/**
 * Register Google fonts for Alke.
 *
 * Create your own alke_fonts_url() function to override in a child theme.
 *
 * @since Alke 1.0
 *
 * @return string Google fonts URL for the theme.
 */
function alke_fonts_url() {
	$fonts_url = '';
	$font_families     = array();
	$subsets   = 'latin,latin-ext';

	/* translators: If there are characters in your language that are not supported by Roboto, translate this to 'off'. Do not translate into your own language. */
	if ( 'off' !== _x( 'on', 'Roboto font: on or off', 'alke' ) ) {
		$font_families[] = 'Roboto:100,100i,300,300i,400,400i,500,500i,700,700i,900,900i';
	}

	/* translators: If there are characters in your language that are not supported by Poppins, translate this to 'off'. Do not translate into your own language. */
	if ( 'off' !== _x( 'on', 'Poppins  font: on or off', 'alke' ) ) {
		$font_families[] = 'Poppins:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i';
	}



	if ( $font_families ) {
		$fonts_url = add_query_arg( array(
			'family' => urlencode( implode( '|', $font_families ) ),
			'subset' => urlencode( $subsets ),
		), 'https://fonts.googleapis.com/css' );
	}
	return esc_url_raw( $fonts_url );
}
endif;

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function alke_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Primary Sidebar', 'alke' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here to appear in your sidebar on blog posts and archive pages.', 'alke' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div><div class="separator-wrap my-5">	
								<span class="separator"><span class="separator-line dashed"></span></span>
							</div>',
		'before_title'  => '<h6 class="mb-3">',
		'after_title'   => '</h6>',
	) );

}
add_action( 'widgets_init', 'alke_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function alke_scripts() {
	$protocol = is_ssl() ? 'https' : 'http';
	$mapapikey = alke_get_option('mapapikey');

	// Add custom fonts, used in the main stylesheet.
	wp_enqueue_style( 'alke-fonts', alke_fonts_url(), array(), null );
	wp_enqueue_style( 'fonts-Work+Sans', "$protocol://fonts.googleapis.com/css?family=Work+Sans:100,200,300,400,500,600,700,800,900", true);
	wp_enqueue_style( 'alke-bootstrap', get_theme_file_uri( '/assets/css/bootstrap.min.css' ), array(), '1.0' );
	wp_enqueue_style( 'alke-font-awesome', get_theme_file_uri( '/assets/css/font-awesome.min.css' ), array(), '1.0' );
	wp_enqueue_style( 'alke-fancybox', get_theme_file_uri( '/assets/css/jquery.fancybox.min.css' ), array(), '1.0' );
	wp_enqueue_style( 'alke-animsition', get_theme_file_uri( '/assets/css/animsition.min.css' ), array(), '1.0' );

	// Theme stylesheet.
	wp_enqueue_style( 'alke-style', get_stylesheet_uri() );
	
	wp_enqueue_script( 'alke-popper', get_theme_file_uri( '/assets/js/popper.min.js' ), array(), '1.0', true );
	wp_enqueue_script( 'alke-bootstrap', get_theme_file_uri( '/assets/js/bootstrap.min.js' ), array(), '1.0', true );
	wp_enqueue_script( 'alke-plugins', get_theme_file_uri( '/assets/js/plugins.js' ), array(), '1.0', true );
	wp_enqueue_script( 'alke-slider-hero', get_theme_file_uri( '/assets/js/slider-hero-plugin.js' ), array(), '1.0', true );
	wp_enqueue_script( 'alke-slider', get_theme_file_uri( '/assets/js/slider-hero.js' ), array(), '1.0', true );
	wp_enqueue_script( 'alke-custom', get_theme_file_uri( '/assets/js/custom.js' ), array(), '1.0', true );


	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'alke_scripts' );


/**
 * Custom template tags for this theme.
 */
require get_parent_theme_file_path( '/framework/template-tags.php' );

/**
 * Additional features to allow styling of the templates.
 */
require get_parent_theme_file_path( '/framework/template-functions.php' );

/**
 * Customizer additions.
 */
require get_parent_theme_file_path( '/framework/customizer.php' );

/**
 * Custom Metabox.
 */
require get_parent_theme_file_path( '/framework/meta-boxes.php' );

/**
 * Require plugins install for this theme.
 *
 * @since Alke 1.0
 */
require get_parent_theme_file_path( '/framework/plugin-requires.php' );

/**
 * Import Demo Content for this theme.
 *
 * @since Alke 1.0
 */
 require get_parent_theme_file_path( '/framework/importer.php' ); 
 /* Customizer Menu.
 */
require get_template_directory() . '/framework/wp_bootstrap_navwalker.php';