<?php
/**
 * Additional features to allow styling of the templates
 *
 * @package WordPress
 * @subpackage alke
 * @since 1.0
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @since Alke 1.0
 *
 * @param array $classes Classes for the body element.
 * @return array (Maybe) filtered body classes.
 */
function alke_body_classes( $classes ) {

	// Add a class if there is a custom header.
	return $classes;
}
add_filter( 'body_class', 'alke_body_classes' );


//Code Visual Composer.
// Add new Param in Row
if(function_exists('vc_add_param')){
	vc_add_param(
		'vc_row',
		array(
			"type" => "dropdown",
			"heading" => esc_html__('Setup Full width For Row', 'alke'),
			"param_name" => "fullwidth",
			"value" => array(   
			                esc_html__('No', 'alke') => 'no',  
			                esc_html__('Yes', 'alke') => 'yes',                                                                                
			              ),
			"description" => esc_html__("Select Full width for row : yes or not, Default: No fullwidth", 'alke'),      
        )
    );    
	vc_add_param('vc_row',array(
          "type" => "checkbox",
          "heading" => esc_html__('Use Background Image Parallax', 'alke'),
          "param_name" => "parallax_bg",
          "value" => '',
          "description" => esc_html__("If checked columns will use background parallax.", "alke"),      
        ) 
    );
	vc_add_param('vc_row',array(
	      'type' => 'attach_image',
	      'heading' => esc_html__( 'Background Parallax', 'alke' ),
	      'param_name' => 'parallax_bg_image',
	      'value' => '',
	      'description' => esc_html__( 'Select image from media library.', 'alke' ),
	      'dependency' => array(
	          'element' => 'parallax_bg',
	          'not_empty' => true,
	        ),     
	    ) 
    );
    vc_add_param(
		'vc_row',
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Content Center', 'alke' ),
			'param_name' => 'contentcenter',
			'description' => esc_html__( 'If checked row will be set to content center.', 'alke' ),
			'value' => array( esc_html__( 'Yes', 'alke' ) => 'yes' ),
		)
    ); 
    vc_add_param(
		'vc_row',
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Center Wrap', 'alke' ),
			'param_name' => 'centerwrap',
			'description' => esc_html__( 'If checked row will be set to center wrap.', 'alke' ),
			'value' => array( esc_html__( 'Yes', 'alke' ) => 'yes' ),
		)
    );      

	// Add new Param in Column	
	vc_add_param('vc_column',array(
		  "type" => "dropdown",
		  "heading" => esc_html__('Animate Column', 'alke'),
		  "param_name" => "animate",
		  "value" => array(   
							esc_html__('None', 'alke') => 'none', 
							esc_html__('Move Top', 'alke') => 'topmove',
							esc_html__('Move Bottom', 'alke') => 'bottommove', 
							esc_html__('Move Left', 'alke') => 'leftmove', 
							esc_html__('Move Right', 'alke') => 'rightmove',  
						  ),
		  "description" => esc_html__("Select Animate , Default: None", 'alke'),      
		) 
    );
	vc_add_param('vc_column',array(
		  "type" => "textfield",
		  "heading" => esc_html__('Animation Distance', 'alke'),
		  "param_name" => "distance",
		  "value" => "",
		  "description" => esc_html__("Input distance show column. Example: 50, 60, etc", 'alke'), 
		  "dependency"  => array( 'element' => 'animate', 'value' => array( 'topmove', 'bottommove', 'leftmove', 'rightmove' ) ),     
		) 
    );
    vc_add_param('vc_column',array(
		  "type" => "textfield",
		  "heading" => esc_html__('Animation Time', 'alke'),
		  "param_name" => "time",
		  "value" => "",
		  "description" => esc_html__("Input time show column. Example: 0.8, 0.9, ...", 'alke'),   
		  "dependency"  => array( 'element' => 'animate', 'value' => array('topmove', 'bottommove', 'leftmove', 'rightmove' ) ),   
		) 
    );  
    vc_add_param('vc_column',array(
		  "type" => "textfield",
		  "heading" => esc_html__('Animation Time After.', 'alke'),
		  "param_name" => "after",
		  "value" => "",
		  "description" => esc_html__("Input time show column. Example: 0.1, 0.2 ...", 'alke'),   
		  "dependency"  => array( 'element' => 'animate', 'value' => array('topmove', 'bottommove', 'leftmove', 'rightmove' ) ),   
		) 
    );  
}

if(function_exists('vc_remove_param')){
	vc_remove_param( "vc_row", "full_width" );
    vc_remove_param( "vc_row", "content_placement" ); 
    vc_remove_param( "vc_row", "equal_height" );
    vc_remove_param( "vc_row", "full_height" );
    vc_remove_param( "vc_row", "columns_placement" );
    vc_remove_param( "vc_row", "parallax" );
    vc_remove_param( "vc_row", "parallax_image" );
    vc_remove_param( "vc_row", "video_bg" );
    vc_remove_param( "vc_row", "video_bg_url" );
    vc_remove_param( "vc_row", "video_bg_parallax" );
    vc_remove_param( "vc_row", "parallax_speed_bg" );
    vc_remove_param( "vc_row", "parallax_speed_video" );
    vc_remove_param( "vc_row", "gap" );
    vc_remove_param( "vc_column", "css_animation" ); 
    vc_remove_param( "vc_column", "video_bg" ); 
    vc_remove_param( "vc_column", "video_bg_url" ); 
    vc_remove_param( "vc_column", "parallax" ); 
    vc_remove_param( "vc_column", "video_bg_parallax" ); 
    vc_remove_param( "vc_column", "parallax_image" ); 
    vc_remove_param( "vc_column", "parallax_speed_bg" ); 
    vc_remove_param( "vc_column", "parallax_speed_video" ); 
}	
