<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage alke
 * @since 1.0
 * @version 1.0
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>
<div id="comments" class="comments-area">
<?php
	// You can start editing here -- including this comment!
	if ( have_comments() ) : ?>
			<h4><?php printf( _nx( '1 Comment', '%1$s Comments', get_comments_number(), 'comments title', 'alke' ), number_format_i18n( get_comments_number() ) );?></h4>
			<div class="separator-wrap pt-3 pb-4">	
				<span class="separator"><span class="separator-line dashed"></span></span>
			</div>

			<ol class="comment-list">
				<?php wp_list_comments( 'callback=alke_theme_comment' ); ?>
			</ol>
			<?php the_comments_pagination( array(
				'prev_text' => '<span class="screen-reader-text">' . esc_html__( 'Previous', 'alke' ) . '</span>',
				'next_text' => '<span class="screen-reader-text">' . esc_html__( 'Next', 'alke' ) . '</span>',
			) );

			endif; // Check for have_comments().

			// If comments are closed and there are comments, let's leave a little note, shall we?
			if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>
				<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'alke' ); ?></p>

			<?php
			endif;

			$aria_req = ( $req ? " aria-required='true'" : '' );
		    $comment_args = array(
	            'id_form' => '',                                
	            'title_reply'=> '<h4>'.esc_html__('Leave a comment','alke').'</h4>',
	            'fields' => apply_filters( 'comment_form_default_fields', array(
	                'author' => '<div class="subscribe-box mt-3"><input class="form-control cursor-link" id="name" name="author" id="err-name" type="text" value="" placeholder="'. esc_attr__( 'Your Name *', 'alke' ) .'" /></div>',
	                'email' => '<div class="subscribe-box mt-4"><input class="form-control cursor-link" id="email" name="email" type="text" value="" placeholder="'. esc_attr__( 'Email *', 'alke' ) .'" /></div>', 
	                'url' => '<div class="subscribe-box mt-4"><input class="form-control cursor-link" id="url" name="url" type="text" value="" placeholder="'. esc_attr__( 'Website', 'alke' ) .'" /></div>',
	            ) ),                                
	             'comment_field' => '<div class="subscribe-box mt-4"><textarea class="for-textarea form-control cursor-link" name="comment"'.$aria_req.' id="message" placeholder="'. esc_attr__( 'Comment *', 'alke' ) .'" ></textarea></div>',                                                   
	             'label_submit' => esc_html__( 'submit comment', 'alke' ),
	             'class_submit'      => 'btn-long mt-4 cursor-link',
	             'comment_notes_before' => '',
	             'comment_notes_after' => '',               
		    );
			comment_form($comment_args);
			?>
</div><!-- #comments -->