<?php

/**
 * Extend Recent Posts Widget
 *
 * Adds different formatting to the default WordPress Recent Posts Widget
 */
Class Thim_Recent_Posts_Widgets extends WP_Widget_Recent_Posts {

	function widget( $args, $instance ) {

		extract( $args );

		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? esc_attr__( 'Recent Posts', 'kita' ) : $instance['title'], $instance, $this->id_base );

		if ( empty( $instance['number'] ) || ! $number = absint( $instance['number'] ) ) {
			$number = 10;
		}

		$r = new WP_Query( apply_filters( 'widget_posts_args', array(
			'posts_per_page'      => $number,
			'no_found_rows'       => true,
			'post_status'         => 'publish',
			'ignore_sticky_posts' => true
		) ) );
		if ( $r->have_posts() ) :

			echo ent2ncr( $before_widget );
			if ( $title ) {
				echo ent2ncr( $before_title . $title . $after_title );
			} ?>
			<ul class="list-unstyled">
				<?php while ( $r->have_posts() ) : $r->the_post(); ?>
					<li class="entry-wrap media">
						<div class="entry-thumbnail mr-3">
							<?php
							$postid = get_the_ID();
							echo thim_feature_image( 50, 50, true ); ?>
						</div>
						<div class="entry-body media-body">
							<h5 class="entry-title">
								<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a>
							</h5>
							<?php if ( isset( $instance['show_date'] ) ) : ?>
								<div class="entry-meta"><?php echo get_the_date(); ?></div>
							<?php endif; ?>
						</div>
					</li>
				<?php endwhile; ?>
			</ul>

			<?php
			echo ent2ncr( $after_widget );

			wp_reset_postdata();

		endif;
	}
}


function thim_recent_widget_registration() {
	unregister_widget( 'WP_Widget_Recent_Posts' );
	register_widget( 'Thim_Recent_Posts_Widgets' );
}

add_action( 'widgets_init', 'thim_recent_widget_registration' );