<?php

/**
 * Class Courses_Widget
 *
 * Widget Name: Courses
 *
 * Author: Ken
 */
class Courses_Widget extends Thim_Widget {
	function __construct() {
		parent::__construct(
			'courses',
			__( 'Thim: Courses', 'elearningwp' ),
			array(
				'description'   => __( 'Display courses', 'elearningwp' ),
				'help'          => '',
				'panels_groups' => array( 'thim_widget_group' ),
				'panels_icon'   => 'dashicons dashicons-welcome-learn-more thim_widgets_courses'
			),
			array(),
			array(
				'heading_group'    => array(
					'type'   => 'section',
					'label'  => __( 'Heading', 'elearningwp' ),
					'hide'   => true,
					'fields' => array(
						'title'               => array(
							'type'                  => 'text',
							'label'                 => __( 'Heading Text', 'elearningwp' ),
							'default'               => __( "Latest Courses", "elearningwp" ),
							'allow_html_formatting' => true
						),
						'textcolor'           => array(
							'type'    => 'color',
							'label'   => __( 'Text Heading color', 'elearningwp' ),
							'default' => '#2c3339',
							"class"   => "color-mini",
						),
						'size'                => array(
							"type"    => "select",
							"label"   => __( "Size Heading", "elearningwp" ),
							"default" => "h3",
							"options" => array(
								"h2" => __( "h2", "elearningwp" ),
								"h3" => __( "h3", "elearningwp" ),
								"h4" => __( "h4", "elearningwp" ),
								"h5" => __( "h5", "elearningwp" ),
								"h6" => __( "h6", "elearningwp" )
							),
							"class"   => "color-mini",
						),
						'font_heading'        => array(
							"type"          => "select",
							"label"         => __( "Font Heading", "elearningwp" ),
							"default"       => "default",
							"options"       => array(
								"default" => __( "Default", "elearningwp" ),
								"custom"  => __( "Custom", "elearningwp" )
							),
							"description"   => __( "Select Font heading.", "elearningwp" ),
							'state_emitter' => array(
								'callback' => 'select',
								'args'     => array( 'font_heading_type' )
							),
							"class"         => "color-mini",
						),
						'custom_font_heading' => array(
							'type'          => 'section',
							'label'         => __( 'Custom Font Heading', 'elearningwp' ),
							'hide'          => true,
							"class"         => "clear-both",
							'state_handler' => array(
								'font_heading_type[custom]'  => array( 'show' ),
								'font_heading_type[default]' => array( 'hide' ),
							),
							'fields'        => array(
								'custom_font_size'   => array(
									"type"        => "number",
									"label"       => __( "Font Size", "elearningwp" ),
									"suffix"      => "px",
									"default"     => "18",
									"description" => __( "custom font size", "elearningwp" ),
									"class"       => "color-mini",
								),
								'custom_font_weight' => array(
									"type"        => "select",
									"label"       => __( "Custom Font Weight", "elearningwp" ),
									"options"     => array(
										"normal" => __( "Normal", "elearningwp" ),
										"bold"   => __( "Bold", "elearningwp" ),
										"100"    => __( "100", "elearningwp" ),
										"200"    => __( "200", "elearningwp" ),
										"300"    => __( "300", "elearningwp" ),
										"400"    => __( "400", "elearningwp" ),
										"500"    => __( "500", "elearningwp" ),
										"600"    => __( "600", "elearningwp" ),
										"700"    => __( "700", "elearningwp" ),
										"800"    => __( "800", "elearningwp" ),
										"900"    => __( "900", "elearningwp" )
									),
									"description" => __( "Select Custom Font Weight", "elearningwp" ),
									"class"       => "color-mini",
								),
							),
						),
					),
				),
				'desc_group'       => array(
					'type'   => 'section',
					'label'  => __( 'Description', 'elearningwp' ),
					'hide'   => true,
					'fields' => array(
						'des'             => array(
							'type'                  => 'textarea',
							'label'                 => __( 'Descriptions', 'elearningwp' ),
							"description"           => __( "descriptions", "elearningwp" ),
							'allow_html_formatting' => true
						),
						'des_color'       => array(
							'type'    => 'color',
							'label'   => __( 'Description color', 'elearningwp' ),
							'default' => '',
							"class"   => "color-mini",
						),
						'des_font_size'   => array(
							"type"        => "number",
							"label"       => __( "Font Size", "elearningwp" ),
							"suffix"      => "px",
							"default"     => "16",
							"description" => __( "custom font size", "elearningwp" ),
							"class"       => "color-mini",
						),
						'des_font_weight' => array(
							"type"        => "select",
							"label"       => __( "Custom Font Weight", "elearningwp" ),
							"options"     => array(
								"normal" => __( "Normal", "elearningwp" ),
								"bold"   => __( "Bold", "elearningwp" ),
								"100"    => __( "100", "elearningwp" ),
								"200"    => __( "200", "elearningwp" ),
								"300"    => __( "300", "elearningwp" ),
								"400"    => __( "400", "elearningwp" ),
								"500"    => __( "500", "elearningwp" ),
								"600"    => __( "600", "elearningwp" ),
								"700"    => __( "700", "elearningwp" ),
								"800"    => __( "800", "elearningwp" ),
								"900"    => __( "900", "elearningwp" )
							),
							"description" => __( "Select Custom Font Weight", "elearningwp" ),
							"class"       => "color-mini",
						),
					),
				),
				'kind'             => array(
					'type'    => 'select',
					'label'   => __( 'Kind Of Courses', 'elearningwp' ),
					'options' => array(
						'latest'      => __( 'Latest courses', 'elearningwp' ),
						'popular'     => __( 'Popular courses', 'elearningwp' ),
						'commingsoon' => __( 'Commingsoon courses', 'elearningwp' )
					),
				),
				'cat'              => array(
					'type'    => 'select',
					'label'   => __( 'Select Category', 'elearningwp' ),
					'options' => self::get_categories(),
					'default' => 0,
					'state_handler' => array(
						'layout_type[layout-01]'          => array( 'show' ),
						'layout_type[layout-02]'          => array( 'show' ),
						'layout_type[layout-filter]'      => array( 'hide' ),
						'layout_type[layout-commingsoon]' => array( 'show' ),
						'layout_type[layout-media]'       => array( 'hide' ),
					),
				),
				'layout'           => array(
					'type'          => 'select',
					'label'         => __( 'Widget Layout', 'elearningwp' ),
					'options'       => array(
						'layout-01'          => __( 'Layout 01', 'elearningwp' ),
						'layout-02'          => __( 'Layout 02', 'elearningwp' ),
						'layout-filter'      => __( 'Layout Filter', 'elearningwp' ),
						'layout-commingsoon' => __( 'Layout Commingsoon Slider', 'elearningwp' ),
						'layout-media'       => __( 'Layout Media Slider', 'elearningwp' )
					),
					'default'       => 'layout-01',
					'state_emitter' => array(
						'callback' => 'select',
						'args'     => array( 'layout_type' )
					),
				),
				'image_size'       => array(
					'type'          => 'text',
					'label'         => __( 'Image size', 'elearningwp' ),
					'description'   => __( 'Other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "thumbnail" courses.', 'elearningwp' ),
					'state_handler' => array(
						'layout_type[layout-01]'          => array( 'show' ),
						'layout_type[layout-02]'          => array( 'hide' ),
						'layout_type[layout-filter]'      => array( 'hide' ),
						'layout_type[layout-commingsoon]' => array( 'hide' ),
						'layout_type[layout-media]'       => array( 'hide' ),
					),
				),
				'columns'          => array(
					'type'          => 'select',
					'label'         => __( 'Columns', 'elearningwp' ),
					'options'       => array(
						'2' => __( '2', 'elearningwp' ),
						'3' => __( '3', 'elearningwp' ),
						'4' => __( '4', 'elearningwp' )
					),
					'state_handler' => array(
						'layout_type[layout-01]'          => array( 'show' ),
						'layout_type[layout-02]'          => array( 'hide' ),
						'layout_type[layout-filter]'      => array( 'show' ),
						'layout_type[layout-commingsoon]' => array( 'hide' ),
						'layout_type[layout-media]'       => array( 'hide' ),
					),
				),
				'limit'            => array(
					'type'    => 'number',
					'label'   => __( 'Number Of Courses', 'elearningwp' ),
					'default' => '4'
				),
				'link_all_courses' => array(
					'type'          => 'checkbox',
					'label'         => __( 'Show Link All Courses', 'elearningwp' ),
					'default'       => true,
					'state_handler' => array(
						'layout_type[layout-01]'          => array( 'show' ),
						'layout_type[layout-02]'          => array( 'hide' ),
						'layout_type[layout-filter]'      => array( 'hide' ),
						'layout_type[layout-commingsoon]' => array( 'hide' ),
						'layout_type[layout-media]'       => array( 'hide' ),
					),
				),
				'social_share'     => array(
					'type'          => 'checkbox',
					'label'         => __( 'Show Social Share', 'elearningwp' ),
					'default'       => true,
					'state_handler' => array(
						'layout_type[layout-01]'          => array( 'hide' ),
						'layout_type[layout-02]'          => array( 'hide' ),
						'layout_type[layout-filter]'      => array( 'hide' ),
						'layout_type[layout-commingsoon]' => array( 'hide' ),
						'layout_type[layout-media]'       => array( 'true' ),
					),
				),
				'slider-options'   => array(
					'type'          => 'section',
					'label'         => __( 'Slider Options', 'elearningwp' ),
					'hide'          => true,
					"class"         => "clear-both",
					'state_handler' => array(
						'layout_type[layout-01]'          => array( 'show' ),
						'layout_type[layout-02]'          => array( 'hide' ),
						'layout_type[layout-filter]'      => array( 'hide' ),
						'layout_type[layout-commingsoon]' => array( 'show' ),
						'layout_type[layout-media]'       => array( 'show' ),
					),
					'state_emitter' => array(
						'callback' => 'select',
						'args'     => array( 'courses_slider_opt' )
					),
					'fields'        => array(
						'courses_slider'  => array(
							'type'    => 'radio',
							'label'   => __( 'Courses Slider', 'elearningwp' ),
							'options' => array(
								'yes' => __( 'Yes', 'elearningwp' ),
								'no'  => __( 'No', 'elearningwp' )
							),

							'default' => 'yes'
						),
						'row'             => array(
							'type'          => 'select',
							'label'         => __( 'Row of slider', 'elearningwp' ),
							'options'       => array(
								'1' => __( '1', 'elearningwp' ),
								'2' => __( '2', 'elearningwp' )
							),
							'state_handler' => array(
								'courses_slider_opt[yes]' => array( 'show' ),
								'courses_slider_opt[no]'  => array( 'hide' ),
							),
						),
						'show_page_nav'   => array(
							'type'          => 'checkbox',
							'label'         => __( 'Show Page Navigation', 'elearningwp' ),
							'state_handler' => array(
								'courses_slider_opt[yes]' => array( 'show' ),
								'courses_slider_opt[no]'  => array( 'hide' ),
							),
							'default'       => true
						),
						'show_navigation' => array(
							'type'          => 'checkbox',
							'label'         => __( 'Show Navigation Arrow', 'elearningwp' ),
							'state_handler' => array(
								'courses_slider_opt[yes]' => array( 'show' ),
								'courses_slider_opt[no]'  => array( 'hide' ),
							),
							'default'       => false
						),
					),
				),


			)
		);
	}

	function get_template_name( $instance ) {
		if ( $instance['layout'] != 'layout-01' ) {
			$layout = $instance['layout'];
		} else {
			$layout = 'base';
		}

		return $layout;
	}

	function get_categories() {

		$categories                                 = get_categories( 'taxonomy=course_category&type=lp_course' );
		$cats                                       = array();
		$cats[0] = esc_attr__( 'All', 'elearningwp' );

		if ( ! empty( $categories ) ) {
			foreach ( $categories as $key => $value ) {
				$cats[ $value->slug ] = $value->name;
			}
		}

		return $cats;
	}

	function get_style_name( $instance ) {
		return false;
	}

	function enqueue_frontend_scripts() {
		wp_enqueue_script( 'thim-owl-carousel' );
	}
}

function thim_courses_register_widget() {
	register_widget( 'Courses_Widget' );
}

add_action( 'init', 'thim_courses_register_widget', 30 );