<?php
/**
 * Create eLearning customizer
 *
 * @package eLearning
 */

/**
 * Class Thim_Customize_Options
 */
class Thim_Customize_Options {
	/**
	 * Thim_Customize_Options constructor.
	 */
	public function __construct() {
		add_action( 'customize_register', array( $this, 'thim_deregister' ) );
		add_action( 'thim_customizer_register', array( $this, 'thim_create_customize_options' ) );
	}

	/**
	 * Deregister customize default unnecessary
	 *
	 * @param $wp_customize
	 */
	public function thim_deregister( $wp_customize ) {
		$wp_customize->remove_section( 'colors' );
		$wp_customize->remove_section( 'background_image' );
		$wp_customize->remove_section( 'header_image' );
		$wp_customize->remove_control( 'blogdescription' );
		$wp_customize->remove_control( 'blogname' );
		$wp_customize->remove_control( 'display_header_text' );
		$wp_customize->remove_section( 'static_front_page' );
		// Rename existing section
		$wp_customize->add_section( 'title_tagline', array(
			'title'    => esc_html__( 'Logo', 'elearningwp' ),
			'panel'    => 'general',
			'priority' => 20,
		) );
	}

	/**
	 * Create customize
	 *
	 * @param $wp_customize
	 */
	public function thim_create_customize_options( $wp_customize ) {

//		//custom css
//		include THIM_DIR . "/inc/admin/customizer-sections/custom-css.php";
//
//		//Display
//		include THIM_DIR . "/inc/admin/customizer-sections/display.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/display-archive.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/display-postpage.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/display-sharing.php";
//
//		//Footer
//		include THIM_DIR . "/inc/admin/customizer-sections/footer.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/footer-copyright.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/footer-options.php";
//
//		//General
//		include THIM_DIR . "/inc/admin/customizer-sections/general.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/general_logo.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/general-typography.php";
//
//		//Header
//		include THIM_DIR . "/inc/admin/customizer-sections/header.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/header-mainmenu.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/header-stickymenu.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/header-submenu.php";
//
//		//Learnpress
//		include THIM_DIR . "/inc/admin/customizer-sections/learnpress.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/learnpress-archive.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/learnpress-features.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/learnpress-single.php";
//
//		//Styling
//		include THIM_DIR . "/inc/admin/customizer-sections/styling.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/styling-color.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/styling-layout.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/styling-pattern.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/styling-rtl.php";
//
//		//Woocommerce
//		include THIM_DIR . "/inc/admin/customizer-sections/woocommerce.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/woocommerce-archive.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/woocommerce-setting.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/woocommerce-sharing.php";
//		include THIM_DIR . "/inc/admin/customizer-sections/woocommerce-single.php";

		//	Auto include sections
		foreach ( glob( THIM_DIR . "inc/admin/customizer-sections/*.php" ) as $file ) {
//			var_dump($file);
			if ( file_exists( $file ) ) {
				require_once $file;
			}
		}
	}
}

$thim_customize = new Thim_Customize_Options();