<?php

/**
 * Search 
 *
 * @package bbPress
 * @subpackage Theme
 */

?>

<form role="search" method="get" id="bbp-search-form" action="<?php bbp_search_url(); ?>">
	<div>
		<label class="screen-reader-text hidden" for="bbp_search"><?php esc_attr_e( 'Search for:', 'elearningwp' ); ?></label>
		<input type="hidden" name="action" value="bbp-search-request" />
		<div class="search-icon"><i class="fa fa-search"></i></div>
		<div class="search-field"><input tabindex="<?php bbp_tab_index(); ?>" type="text" value="<?php echo esc_attr( bbp_get_search_terms() ); ?>" name="bbp_search" id="bbp_search" /></div>
		<div class="search-btn"><input tabindex="<?php bbp_tab_index(); ?>" class="button" type="submit" id="bbp_search_submit" value="<?php esc_attr_e( 'Search', 'elearningwp' ); ?>" /></div>
	</div>
</form>
