<?php

	function pixelwars_core_meta_box__title_visibility($post)
	{
		wp_nonce_field(
			'pixelwars_core_meta_box__title_visibility',
			'pixelwars_core_meta_box_nonce__title_visibility'
		);
		
		$current_screen = get_current_screen();
		
		?>
			<div class="admin-inside-box pixelwars-core--meta-box">
				<?php
					if ($current_screen->id === 'page')
					{
						?>
							<p>
								<?php
									$title_visibility = get_post_meta(get_the_ID(), 'pixelwars_core_title_visibility', true);
								?>
								<label for="pixelwars_core_title_visibility">
									<input type="checkbox" id="pixelwars_core_title_visibility" name="pixelwars_core_title_visibility" <?php if ($title_visibility) { echo 'checked="checked"'; } ?>>
									
									<?php esc_html_e('Hide Title', 'pixelwars-core'); ?>
								</label>
							</p>
							
							<hr>
						<?php
					}
				?>
				
				<p>
					<label for="pixelwars_core__hide_footer"><?php esc_html_e('Hide Footer', 'pixelwars-core'); ?></label>
					<?php
						$hide_footer = get_post_meta(get_the_ID(), 'pixelwars_core__hide_footer', true);
					?>
					
					<select id="pixelwars_core__hide_footer" name="pixelwars_core__hide_footer">
						<option <?php if ($hide_footer == 'no')  { echo 'selected="selected"'; } ?> value="no"><?php  esc_html_e('No',  'pixelwars-core'); ?></option>
						<option <?php if ($hide_footer == 'yes') { echo 'selected="selected"'; } ?> value="yes"><?php esc_html_e('Yes', 'pixelwars-core'); ?></option>
					</select>
					<span class="howto">
						<?php
							esc_html_e('Hide site footer for this page.', 'pixelwars-core');
						?>
					</span>
				</p>
				
				<hr>
				
				<p>
					<?php
						$post_header_style_label = esc_html__('Post Header Style', 'pixelwars-core');
						
						if ($current_screen->id === 'page')
						{
							$post_header_style_label = esc_html__('Page Header Style', 'pixelwars-core');
						}
					?>
					<label for="pixelwars_core_header_style"><?php echo esc_html($post_header_style_label); ?></label>
					<br>
					<?php
						$post_header_style = get_post_meta(get_the_ID(), 'pixelwars_core_header_style', true);
					?>
					<select id="pixelwars_core_header_style" name="pixelwars_core_header_style">
						<option <?php if ($post_header_style == 'inherit')                                                                                                     { echo 'selected="selected"'; } ?> value="inherit"><?php                                                                                                     esc_html_e('Inherit from Customizer',  'pixelwars-core'); ?></option>
						<option <?php if ($post_header_style == 'is-header-style-default')                                                                                     { echo 'selected="selected"'; } ?> value="is-header-style-default"><?php                                                                                     esc_html_e('Default',                  'pixelwars-core'); ?></option>
						<option <?php if ($post_header_style == 'is-header-float is-header-transparent')                                                                       { echo 'selected="selected"'; } ?> value="is-header-float is-header-transparent"><?php                                                                       esc_html_e('Transparent',              'pixelwars-core'); ?></option>
						<option <?php if ($post_header_style == 'is-header-float is-header-transparent is-header-float-margin')                                                { echo 'selected="selected"'; } ?> value="is-header-float is-header-transparent is-header-float-margin"><?php                                                esc_html_e('Transparent Margin',       'pixelwars-core'); ?></option>
						<option <?php if ($post_header_style == 'is-header-float is-header-transparent is-header-half-transparent')                                            { echo 'selected="selected"'; } ?> value="is-header-float is-header-transparent is-header-half-transparent"><?php                                            esc_html_e('Half Transparent',         'pixelwars-core'); ?></option>
						<option <?php if ($post_header_style == 'is-header-float is-header-transparent is-header-half-transparent is-header-float-box is-header-float-margin') { echo 'selected="selected"'; } ?> value="is-header-float is-header-transparent is-header-half-transparent is-header-float-box is-header-float-margin"><?php esc_html_e('Half Transparent Margin',  'pixelwars-core'); ?></option>
						<option <?php if ($post_header_style == 'is-header-float is-header-transparent-light')                                                                 { echo 'selected="selected"'; } ?> value="is-header-float is-header-transparent-light"><?php                                                                 esc_html_e('Transparent Light',        'pixelwars-core'); ?></option>
						<option <?php if ($post_header_style == 'is-header-float is-header-transparent-light is-header-float-margin')                                          { echo 'selected="selected"'; } ?> value="is-header-float is-header-transparent-light is-header-float-margin"><?php                                          esc_html_e('Transparent Light Margin', 'pixelwars-core'); ?></option>
						<option <?php if ($post_header_style == 'is-header-float is-header-float-box')                                                                         { echo 'selected="selected"'; } ?> value="is-header-float is-header-float-box"><?php                                                                         esc_html_e('Floating Box',             'pixelwars-core'); ?></option>
						<option <?php if ($post_header_style == 'is-header-float is-header-float-box is-header-float-margin')                                                  { echo 'selected="selected"'; } ?> value="is-header-float is-header-float-box is-header-float-margin"><?php                                                  esc_html_e('Floating Box Margin',      'pixelwars-core'); ?></option>
						<option <?php if ($post_header_style == 'is-header-float is-header-float-box is-header-float-box-menu')                                                { echo 'selected="selected"'; } ?> value="is-header-float is-header-float-box is-header-float-box-menu"><?php                                                esc_html_e('Floating Box Menu',        'pixelwars-core'); ?></option>
					</select>
					<span class="howto">
						<?php
							if ($current_screen->id === 'page')
							{
								esc_html_e('"Inherit from Customizer": Appearance > Customize > Pages > Page Header Style.', 'pixelwars-core');
							}
							elseif ($current_screen->id === 'post')
							{
								esc_html_e('"Inherit from Customizer": Appearance > Customize > Single Post > Post Header Style.', 'pixelwars-core');
							}
							else
							{
								esc_html_e('"Inherit from Customizer": Appearance > Customize > Portfolio > Post Header Style.', 'pixelwars-core');
							}
						?>
					</span>
				</p>
				
				<hr>
				
				<p>
					<?php
						$post_style_label = esc_html__('Post Style', 'pixelwars-core');
						
						if ($current_screen->id === 'page')
						{
							$post_style_label = esc_html__('Page Style', 'pixelwars-core');
						}
					?>
					<label for="pixelwars_core_post_style"><?php echo esc_html($post_style_label); ?></label>
					<br>
					<?php
						$post_style = get_post_meta(get_the_ID(), 'pixelwars_core_post_style', true);
					?>
					<select id="pixelwars_core_post_style" name="pixelwars_core_post_style">
						<option <?php if ($post_style == 'inherit')                                                     { echo 'selected="selected"'; } ?> value="inherit"><?php                                                     esc_html_e('Inherit from Customizer',            'pixelwars-core'); ?></option>
						<option <?php if ($post_style == 'post-header-classic')                                         { echo 'selected="selected"'; } ?> value="post-header-classic"><?php                                         esc_html_e('Classic',                            'pixelwars-core'); ?></option>
						<option <?php if ($post_style == 'is-top-content-single-medium')                                { echo 'selected="selected"'; } ?> value="is-top-content-single-medium"><?php                                esc_html_e('Classic Medium',                     'pixelwars-core'); ?></option>
						<option <?php if ($post_style == 'is-top-content-single-medium with-parallax')                  { echo 'selected="selected"'; } ?> value="is-top-content-single-medium with-parallax"><?php                  esc_html_e('Classic Medium Parallax',            'pixelwars-core'); ?></option>
						<option <?php if ($post_style == 'is-top-content-single-full')                                  { echo 'selected="selected"'; } ?> value="is-top-content-single-full"><?php                                  esc_html_e('Classic Full',                       'pixelwars-core'); ?></option>
						<option <?php if ($post_style == 'is-top-content-single-full with-parallax')                    { echo 'selected="selected"'; } ?> value="is-top-content-single-full with-parallax"><?php                    esc_html_e('Classic Full Parallax',              'pixelwars-core'); ?></option>
						<option <?php if ($post_style == 'is-top-content-single-full-margins')                          { echo 'selected="selected"'; } ?> value="is-top-content-single-full-margins"><?php                          esc_html_e('Classic Full with Margins',          'pixelwars-core'); ?></option>
						<option <?php if ($post_style == 'is-top-content-single-full-margins with-parallax')            { echo 'selected="selected"'; } ?> value="is-top-content-single-full-margins with-parallax"><?php            esc_html_e('Classic Full with Margins Parallax', 'pixelwars-core'); ?></option>
						<option <?php if ($post_style == 'post-header-overlay post-header-overlay-inline is-post-dark') { echo 'selected="selected"'; } ?> value="post-header-overlay post-header-overlay-inline is-post-dark"><?php esc_html_e('Overlay',                            'pixelwars-core'); ?></option>
						<option <?php if ($post_style == 'is-top-content-single-medium with-overlay')                   { echo 'selected="selected"'; } ?> value="is-top-content-single-medium with-overlay"><?php                   esc_html_e('Overlay Medium',                     'pixelwars-core'); ?></option>
						<option <?php if ($post_style == 'is-top-content-single-full with-overlay')                     { echo 'selected="selected"'; } ?> value="is-top-content-single-full with-overlay"><?php                     esc_html_e('Overlay Full',                       'pixelwars-core'); ?></option>
						<option <?php if ($post_style == 'is-top-content-single-full-margins with-overlay')             { echo 'selected="selected"'; } ?> value="is-top-content-single-full-margins with-overlay"><?php             esc_html_e('Overlay Full with Margins',          'pixelwars-core'); ?></option>
						<option <?php if ($post_style == 'is-top-content-single-full-screen with-overlay')              { echo 'selected="selected"'; } ?> value="is-top-content-single-full-screen with-overlay"><?php              esc_html_e('Overlay Fullscreen',                 'pixelwars-core'); ?></option>
						<option <?php if ($post_style == 'is-top-content-single-medium with-title-full')                { echo 'selected="selected"'; } ?> value="is-top-content-single-medium with-title-full"><?php                esc_html_e('Title Full',                         'pixelwars-core'); ?></option>
						<option <?php if ($post_style == 'post-header-classic is-featured-image-left')                  { echo 'selected="selected"'; } ?> value="post-header-classic is-featured-image-left"><?php                  esc_html_e('Image Left',                         'pixelwars-core'); ?></option>
						<option <?php if ($post_style == 'post-header-classic is-featured-image-right')                 { echo 'selected="selected"'; } ?> value="post-header-classic is-featured-image-right"><?php                 esc_html_e('Image Right',                        'pixelwars-core'); ?></option>
					</select>
					<span class="howto">
						<?php
							if ($current_screen->id === 'page')
							{
								esc_html_e('- "Inherit from Customizer": Appearance > Customize > Pages > Page Style.', 'pixelwars-core');
							}
							elseif ($current_screen->id === 'post')
							{
								esc_html_e('- "Inherit from Customizer": Appearance > Customize > Single Post > Post Style.', 'pixelwars-core');
							}
							else
							{
								esc_html_e('- "Inherit from Customizer": Appearance > Customize > Portfolio > Post Style.', 'pixelwars-core');
							}
						?>
						<br>
						<?php
							esc_html_e('- "Classic" style applies if there is no featured media.', 'pixelwars-core');
						?>
						<br>
						<?php
							esc_html_e('- "Image Left" and "Image Right" layouts display as classic style when featured video is present.', 'pixelwars-core');
						?>
					</span>
				</p>
				
				<hr>
				
				<?php
					if ($current_screen->id === 'page')
					{
						?>
							<p>
								<label for="pixelwars_core_select_page_featured_area"><?php esc_html_e('Featured Area', 'pixelwars-core'); ?></label>
								<br>
								<?php
									$select_page_featured_area = get_post_meta(get_the_ID(), 'pixelwars_core_select_page_featured_area', true);
								?>
								<select id="pixelwars_core_select_page_featured_area" name="pixelwars_core_select_page_featured_area">
									<option <?php if ($select_page_featured_area == 'No Featured Area')   { echo 'selected="selected"'; } ?> value="No Featured Area"><?php                                                             esc_html_e('No Featured Area', 'pixelwars-core'); ?></option>
									<option <?php if ($select_page_featured_area == 'pixelwars_core_sidebar__blog_featured_area')      { echo 'selected="selected"'; } ?> value="pixelwars_core_sidebar__blog_featured_area"><?php      esc_html_e('Blog Featured Area', 'pixelwars-core'); ?></option>
									<option <?php if ($select_page_featured_area == 'pixelwars_core_sidebar__page_featured_area')      { echo 'selected="selected"'; } ?> value="pixelwars_core_sidebar__page_featured_area"><?php      esc_html_e('Page Featured Area', 'pixelwars-core'); ?></option>
									<option <?php if ($select_page_featured_area == 'pixelwars_core_sidebar__portfolio_featured_area') { echo 'selected="selected"'; } ?> value="pixelwars_core_sidebar__portfolio_featured_area"><?php esc_html_e('Portfolio Featured Area', 'pixelwars-core'); ?></option>
									<option <?php if ($select_page_featured_area == 'pixelwars_core_sidebar__shop_featured_area')      { echo 'selected="selected"'; } ?> value="pixelwars_core_sidebar__shop_featured_area"><?php      esc_html_e('Shop Featured Area', 'pixelwars-core'); ?></option>
									<?php
										$pixelwars_core_sidebars_with_commas = get_option('pixelwars_core_sidebars_with_commas');
										
										if ($pixelwars_core_sidebars_with_commas != "")
										{
											$sidebars = preg_split("/[\s]*[,][\s]*/", $pixelwars_core_sidebars_with_commas);
											
											foreach ($sidebars as $sidebar)
											{
												$sidebar_lowercase = strtolower($sidebar);
												$sidebar_id        = str_replace(" ", '_', $sidebar_lowercase); // Parameters: Old value, New value, String.
												
												$selected = "";
												
												if ($select_page_featured_area == $sidebar_id)
												{
													$selected = 'selected="selected"';
												}
												
												echo '<option ' . $selected . ' value="' . esc_attr($sidebar_id) . '">' . esc_html($sidebar) . '</option>';
											}
										}
									?>
								</select>
								<span class="howto">
									<?php
										esc_html_e('- Add "Main Slider", "Link Box" or "Intro" widgets to your featured area. You can add many widgets to a featured area.', 'pixelwars-core');
										
										echo '<br>';
										
										esc_html_e('- Featured Area is a widget area like sidebars. So you can create new one from Appearance > Theme Options > Widget Areas.', 'pixelwars-core');
									?>
								</span>
							</p>
							
							<hr>
						<?php
					}
				?>
				
				<p>
					<label for="pixelwars_core_select_page_sidebar"><?php esc_html_e('Sidebar', 'pixelwars-core'); ?></label>
					<br>
					<?php
						$select_page_sidebar = get_post_meta(get_the_ID(), 'pixelwars_core_select_page_sidebar', true);
					?>
					<select id="pixelwars_core_select_page_sidebar" name="pixelwars_core_select_page_sidebar">
						<?php
							if (($current_screen->id === 'post') || ($current_screen->id === 'portfolio') || ($current_screen->id === 'lp_course'))
							{
								?>
									<option <?php if ($select_page_sidebar == 'inherit') { echo 'selected="selected"'; } ?> value="inherit"><?php esc_html_e('Inherit from Customizer', 'pixelwars-core'); ?></option>
								<?php
							}
						?>
						<option <?php if ($select_page_sidebar == 'No Sidebar')                                { echo 'selected="selected"'; } ?> value="No Sidebar"><?php                                esc_html_e('No Sidebar',        'pixelwars-core'); ?></option>
						<option <?php if ($select_page_sidebar == 'pixelwars_core_sidebar__blog_sidebar')      { echo 'selected="selected"'; } ?> value="pixelwars_core_sidebar__blog_sidebar"><?php      esc_html_e('Blog Sidebar',      'pixelwars-core'); ?></option>
						<option <?php if ($select_page_sidebar == 'pixelwars_core_sidebar__post_sidebar')      { echo 'selected="selected"'; } ?> value="pixelwars_core_sidebar__post_sidebar"><?php      esc_html_e('Post Sidebar',      'pixelwars-core'); ?></option>
						<option <?php if ($select_page_sidebar == 'pixelwars_core_sidebar__page_sidebar')      { echo 'selected="selected"'; } ?> value="pixelwars_core_sidebar__page_sidebar"><?php      esc_html_e('Page Sidebar',      'pixelwars-core'); ?></option>
						<option <?php if ($select_page_sidebar == 'pixelwars_core_sidebar__portfolio_sidebar') { echo 'selected="selected"'; } ?> value="pixelwars_core_sidebar__portfolio_sidebar"><?php esc_html_e('Portfolio Sidebar', 'pixelwars-core'); ?></option>
						<option <?php if ($select_page_sidebar == 'pixelwars_core_sidebar__shop_sidebar')      { echo 'selected="selected"'; } ?> value="pixelwars_core_sidebar__shop_sidebar"><?php      esc_html_e('Shop Sidebar',      'pixelwars-core'); ?></option>
						<option <?php if ($select_page_sidebar == 'pixelwars_core_sidebar__course_sidebar')    { echo 'selected="selected"'; } ?> value="pixelwars_core_sidebar__course_sidebar"><?php    esc_html_e('Course Sidebar',    'pixelwars-core'); ?></option>
						<?php
							$pixelwars_core_sidebars_with_commas = get_option('pixelwars_core_sidebars_with_commas');
							
							if ($pixelwars_core_sidebars_with_commas != "")
							{
								$sidebars = preg_split("/[\s]*[,][\s]*/", $pixelwars_core_sidebars_with_commas);
								
								foreach ($sidebars as $sidebar)
								{
									$sidebar_lowercase = strtolower($sidebar);
									$sidebar_id        = str_replace(" ", '_', $sidebar_lowercase); // Parameters: Old value, New value, String.
									
									$selected = "";
									
									if ($select_page_sidebar == $sidebar_id)
									{
										$selected = 'selected="selected"';
									}
									
									echo '<option ' . $selected . ' value="' . esc_attr($sidebar_id) . '">' . esc_html($sidebar) . '</option>';
								}
							}
						?>
					</select>
					<span class="howto">
						<?php
							if ($current_screen->id === 'post')
							{
								esc_html_e('- "Inherit from Customizer": Appearance > Customize > Sidebar > Post Sidebar.', 'pixelwars-core');
								echo '<br>';
							}
							elseif ($current_screen->id === 'portfolio')
							{
								esc_html_e('- "Inherit from Customizer": Appearance > Customize > Sidebar > Portfolio Post Sidebar.', 'pixelwars-core');
								echo '<br>';
							}
							elseif ($current_screen->id === 'lp_course')
							{
								esc_html_e('- "Inherit from Customizer": Appearance > Customize > Sidebar > Course Sidebar.', 'pixelwars-core');
								echo '<br>';
							}
							
							esc_html_e('- Sidebar is a widget area. You can find all available sidebars in your Widgets page under Appearance menu and Widgets section in Customizer.', 'pixelwars-core');
							echo '<br>';
							
							esc_html_e('- You can create new sidebars from Appearance > Theme Options > Widget Areas.', 'pixelwars-core');
						?>
					</span>
				</p>
				
				<hr>
				
				<?php
					if (($current_screen->id === 'post') || ($current_screen->id === 'page') || ($current_screen->id === 'portfolio'))
					{
						?>
							<p>
								<label for="pixelwars_core_gallery_type"><?php esc_html_e('Gallery Type', 'pixelwars-core'); ?></label>
								<br>
								<?php
									$gallery_type = get_post_meta(get_the_ID(), 'pixelwars_core_gallery_type', true);
								?>
								<select id="pixelwars_core_gallery_type" name="pixelwars_core_gallery_type">
									<option <?php if ($gallery_type == 'grid')   { echo 'selected="selected"'; } ?> value="grid"><?php   esc_html_e('Grid',   'pixelwars-core'); ?></option>
									<option <?php if ($gallery_type == 'slider') { echo 'selected="selected"'; } ?> value="slider"><?php esc_html_e('Slider', 'pixelwars-core'); ?></option>
								</select>
								<span class="howto">
									<?php
										esc_html_e('Add "Classic" block to your block editor. Use "Add Media" button of the Classic block to create a gallery.', 'pixelwars-core');
									?>
								</span>
							</p>
							
							<hr>
						<?php
					}
				?>
				
				<p>
					<label for="pixelwars_core_featured_media__url"><?php esc_html_e('Featured Media', 'pixelwars-core'); ?></label>
					
					<?php
						$pixelwars_core_featured_media__url = get_post_meta(get_the_ID(), 'pixelwars_core_featured_media__url', true);
					?>
					<input type="text" id="pixelwars_core_featured_media__url" name="pixelwars_core_featured_media__url" class="widefat" placeholder="https://" value="<?php echo esc_url($pixelwars_core_featured_media__url); ?>">
					
					<?php
						if ($current_screen->id === 'portfolio')
						{
							$pixelwars_core_featured_media__new_tab = get_post_meta(get_the_ID(), 'pixelwars_core_featured_media__new_tab', true);
							
							?>
								<br>
								<label id="pixelwars_core_featured_media__new_tab_label" for="pixelwars_core_featured_media__new_tab">
									<input type="checkbox" id="pixelwars_core_featured_media__new_tab" name="pixelwars_core_featured_media__new_tab" <?php if ($pixelwars_core_featured_media__new_tab) { echo 'checked="checked"'; } ?>> <?php esc_html_e('Open in new tab (for Link format)', 'pixelwars-core'); ?>
								</label>
								<br>
								<br>
							<?php
						}
						
					?>
					<span class="howto">
						<?php
							if ($current_screen->id === 'portfolio')
							{
								esc_html_e('Use this url field for audio, video and link format posts.', 'pixelwars-core');
								
								echo '<br>';
								
								esc_html_e('- Video: Enter a YouTube or Vimeo web page url. This video will be shown in a lightbox in your portfolio page.', 'pixelwars-core');
								
								echo '<br>';
								
								esc_html_e('- Audio: Enter a SoundCloud web page url. This audio will be shown in a lightbox in your portfolio page.', 'pixelwars-core');
								
								echo '<br>';
								
								esc_html_e('- Link: Enter your custom url.', 'pixelwars-core');
							}
							else
							{
								if ($current_screen->id === 'post')
								{
									esc_html_e('Use this url field for audio and video format posts.', 'pixelwars-core');
									
									echo '<br>';
								}
								
								esc_html_e('- Video: Enter a YouTube or Vimeo web page url. This video will be shown in place of featured image.', 'pixelwars-core');
								
								echo '<br>';
								
								esc_html_e('- Audio: Enter a SoundCloud web page url. This audio will be shown in place of featured image.', 'pixelwars-core');
							}
						?>
					</span>
				</p>
			</div>
		<?php
	}
	
	
	function pixelwars_core_save_meta_box__title_visibility($post_id)
	{
		if (! isset($_POST['pixelwars_core_meta_box_nonce__title_visibility']))
		{
			return $post_id;
		}
		
		$nonce = $_POST['pixelwars_core_meta_box_nonce__title_visibility'];
		
		if (! wp_verify_nonce($nonce, 'pixelwars_core_meta_box__title_visibility'))
        {
			return $post_id;
		}
		
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        {
			return $post_id;
		}
		
		if ('page' == $_POST['post_type'])
		{
			if (! current_user_can('edit_page', $post_id))
			{
				return $post_id;
			}
		}
		else
		{
			if (! current_user_can('edit_post', $post_id))
			{
				return $post_id;
			}
		}
		
		$current_screen = get_current_screen();
		
		if ($current_screen->id === 'page')
		{
			update_post_meta($post_id, 'pixelwars_core_title_visibility', $_POST['pixelwars_core_title_visibility']);
		}
		
		update_post_meta($post_id, 'pixelwars_core__hide_footer',              $_POST['pixelwars_core__hide_footer']);
		update_post_meta($post_id, 'pixelwars_core_header_style',              $_POST['pixelwars_core_header_style']);
		update_post_meta($post_id, 'pixelwars_core_post_style',                $_POST['pixelwars_core_post_style']);
		update_post_meta($post_id, 'pixelwars_core_select_page_featured_area', $_POST['pixelwars_core_select_page_featured_area']);
		update_post_meta($post_id, 'pixelwars_core_select_page_sidebar',       $_POST['pixelwars_core_select_page_sidebar']);
		update_post_meta($post_id, 'pixelwars_core_gallery_type',              $_POST['pixelwars_core_gallery_type']);
		update_post_meta($post_id, 'pixelwars_core_featured_media__url',       $_POST['pixelwars_core_featured_media__url']);
		
		if ($current_screen->id === 'portfolio')
		{
			update_post_meta($post_id, 'pixelwars_core_featured_media__new_tab', $_POST['pixelwars_core_featured_media__new_tab']);
		}
	}
	
	add_action('save_post', 'pixelwars_core_save_meta_box__title_visibility');
	
	
	function pixelwars_core_add_meta_boxes__title_visibility()
	{
		$post_types = get_post_types();
		unset($post_types['attachment']);
		
		add_meta_box(
			'pixelwars_core_add_meta_box__title_visibility',
			esc_html__('Page Settings', 'pixelwars-core'),
			'pixelwars_core_meta_box__title_visibility',
			$post_types,
			'side',
			'high'
		);
	}
	
	add_action('add_meta_boxes', 'pixelwars_core_add_meta_boxes__title_visibility');


/* ============================================================================================================================================= */
/* ============================================================================================================================================= */


	function pixelwars_core__get_page_id()
	{
		$page_id = "";
		
		if (is_home()) // Blog page.
		{
			$page_id = get_option('page_for_posts'); // Reading Settings > Posts page.
		}
		elseif (is_post_type_archive('product') || is_tax('product_cat') || is_singular('product')) // WooCommerce plugin pages. (shop page, product category page, product page)
		{
			$page_id = get_option('woocommerce_shop_page_id');
		}
		elseif (is_singular())
		{
			$page_id = get_the_ID(); // Pages, Posts, Custom Post Types.
		}
		
		return $page_id;
	}


/* ============================================================================================================================================= */


	function pixelwars_core_title_visibility()
	{
		$title_visibility = get_post_meta(get_the_ID(), 'pixelwars_core_title_visibility', true);
		
		if ($title_visibility)
		{
			echo 'style="display: none;"';
		}
	}


/* ============================================================================================================================================= */


	function pixelwars_core__get_hide_footer()
	{
		$page_id     = pixelwars_core__get_page_id();
		$hide_footer = get_post_meta($page_id, 'pixelwars_core__hide_footer', true);
		
		return $hide_footer;
	}
	
	
	function pixelwars_core__wp_head__hide_footer()
	{
		$hide_footer = pixelwars_core__get_hide_footer();
		
		if ($hide_footer == 'yes')
		{
			?>

				<style>
					.site-footer {
						display: none !important;
					}
				</style>

			<?php
		}
	}
	
	add_action('wp_head', 'pixelwars_core__wp_head__hide_footer');


/* ============================================================================================================================================= */


	function pixelwars_core_featured_area()
	{
		return get_post_meta(get_the_ID(), 'pixelwars_core_select_page_featured_area', true);
	}


/* ============================================================================================================================================= */


	function pixelwars_core_sidebar($post_id = "")
	{
		return get_post_meta($post_id, 'pixelwars_core_select_page_sidebar', true);
	}


/* ============================================================================================================================================= */


	function pixelwars_core_gallery_type()
	{
		return get_post_meta(get_the_ID(), 'pixelwars_core_gallery_type', true);
	}


/* ============================================================================================================================================= */


	function pixelwars_core_header_style()
	{
		$post_header_style = "";
		
		if (is_home()) // Blog page.
		{
			$blog_page_id      = get_option('page_for_posts'); // Reading Settings > Posts page: Blog.
			$post_header_style = get_post_meta($blog_page_id, 'pixelwars_core_header_style', true);
		}
		else // Pages, Posts, Custom Post Types.
		{
			$post_header_style = get_post_meta(get_the_ID(), 'pixelwars_core_header_style', true);
		}
		
		return $post_header_style;
	}

/* ============================================================================================================================================= */


	function pixelwars_core_post_style()
	{
		$post_style = get_post_meta(get_the_ID(), 'pixelwars_core_post_style', true); // Get post style class. (edit screen)
		
		return $post_style;
	}


/* ============================================================================================================================================= */


	function pixelwars_core_featured_media__url()
	{
		return get_post_meta(get_the_ID(), 'pixelwars_core_featured_media__url', true);
	}
	
	
	function pixelwars_core_featured_media__new_tab()
	{
		return get_post_meta(get_the_ID(), 'pixelwars_core_featured_media__new_tab', true);
	}
	
	
	function pixelwars_core_iframe_from_xml($browser_address_url)
	{
		$browser_address_url__type_youtube    = strpos($browser_address_url, 'youtube.com');
		$browser_address_url__type_vimeo      = strpos($browser_address_url, 'vimeo.com');
		$browser_address_url__type_soundcloud = strpos($browser_address_url, 'soundcloud.com');
		
		if ($browser_address_url__type_youtube !== false)
		{
			$xml_url 	   = 'https://www.youtube.com/oembed?url=' . $browser_address_url . '&format=xml';
			$xml_content   = simplexml_load_file($xml_url);
			$xml_attribute = $xml_content->html; // Get iframe.
			return $xml_attribute;
		}
		elseif ($browser_address_url__type_vimeo !== false)
		{
			$xml_url 	   = 'http://vimeo.com/api/oembed.xml?url=' . $browser_address_url;
			$xml_content   = simplexml_load_file($xml_url);
			$xml_attribute = $xml_content->html; // Get iframe.
			return $xml_attribute;
		}
		elseif ($browser_address_url__type_soundcloud !== false)
		{
			$xml_url 	   = 'http://soundcloud.com/oembed?url=' . $browser_address_url;
			$xml_content   = simplexml_load_file($xml_url);
			$xml_attribute = $xml_content->html; // Get iframe.
			return $xml_attribute;
		}
	}


/* ============================================================================================================================================= */

