<?php

namespace AmeliaBooking\Infrastructure\WP\Translations;

use AmeliaBooking\Domain\Services\Settings\SettingsService;
use AmeliaBooking\Infrastructure\WP\SettingsService\SettingsStorage;
use AmeliaBooking\Infrastructure\Licence;

/**
 * Class FrontendStrings
 *
 * @package AmeliaBooking\Infrastructure\WP\Translations
 *
 * @phpcs:disable
 */
class FrontendStrings
{
    /** @var SettingsService */
    private static $settings;

    /**
     * Set Settings
     *
     * @return array|mixed
     */
    public static function getLabelsFromSettings()
    {
        if (!self::$settings) {
            self::$settings = new SettingsService(new SettingsStorage());
        }

        if (self::$settings->getSetting('labels', 'enabled') === true) {
            $labels = self::$settings->getCategorySettings('labels');
            unset($labels['enabled']);

            return $labels;
        }

        return [];
    }

    /**
     * Return all strings for frontend
     *
     * @return array
     */
    public static function getAllStrings()
    {
        return array_merge(
            self::getCommonStrings(),
            self::getBookingStrings(),
            self::getBookableStrings(),
            self::getCatalogStrings(),
            self::getSearchStrings(),
            self::getLabelsFromSettings(),
            self::getEventStrings(),
            self::getCabinetStrings(),
            self::getFrontendCabinetAuthStrings()
        );
    }

    /**
     * Returns the array for the bookable strings
     *
     * @return array
     */
    public static function getBookableStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'allow_customers_to_pay_total'       => __('Check this option if you want your<br> customers to have the option to choose<br> whether they will pay a full amount<br> or just a deposit. If unchecked,<br> customers will only have deposit<br> as a payment option.', 'wpamelia'),
            'deposit_by_the_number_of_people'    => __('Check this option if you want the deposit<br> amount to be multiplied by the number<br> of people that customers add in the<br> "Bringing anyone with you" section.', 'wpamelia'),
            'allow_total_amount'                 => __('Allow customers to pay total appointment amount', 'wpamelia'),
            'allow_total_event_amount'           => __('Allow customers to pay total event amount', 'wpamelia'),
            'deposit'                            => __('Deposit', 'wpamelia'),
            'pay_now'                            => __('(Paying now)', 'wpamelia'),
            'pay_later'                          => __('Left to pay', 'wpamelia'),
            'deposit_amount'                     => __('Deposit amount', 'wpamelia'),
            'deposit_enabled'                    => __('Deposit Payment', 'wpamelia'),
            'deposit_payment'                    => __('Deposit type', 'wpamelia'),
            'deposit_payment_tooltip'            => __('Percentage deposit will be calculated on the total booking price<br>and fixed amount can be multiplied by the number of people or stay fixed on the total booking price.', 'wpamelia'),
            'deposit_info'                       => __('Remaining of total amount will be paid on site.', 'wpamelia'),
            'deposit_per_person'                 => __('Multiply deposit amount by the number of people in one booking', 'wpamelia'),
            'custom_pricing_enabled'             => __('Custom Pricing', 'wpamelia'),
            'pricing_by_date_enabled'            => __('Pricing by Date range', 'wpamelia'),
            'pricing'                            => __('Pricing', 'wpamelia'),
            'event_date_range'                   => __('Date range', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteFrontendStrings::getBookableStrings());
    }

    /**
     * Returns the array of the common frontend strings
     *
     * @return array
     */
    public static function getCommonStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'no_results_found'             => __('No results found...', 'wpamelia'),
            'add_coupon'                   => __('Add Coupon', 'wpamelia'),
            'amount_fixed'                 => __('Fixed amount', 'wpamelia'),
            'amount_percentage'            => __('Percentage', 'wpamelia'),
            'and'                          => __('and', 'wpamelia'),
            'apple_calendar'               => __('Apple Calendar', 'wpamelia'),
            'apple_calendar_personal'      => __('Apple Calendar (Personal)', 'wpamelia'),
            'apple_calendar_select'        => __('Choose Apple Calendar', 'wpamelia'),
            'apple_calendar_placeholder'   => __('Select Apple Calendar', 'wpamelia'),
            'apple_icloud_id'              => __('iCloud Email Address', 'wpamelia'),
            'apple_app_specific_password'  => __('iCloud App-specific Password', 'wpamelia'),
            'apple_connect'                => __('Connect to Apple', 'wpamelia'),
            'apple_disconnect'             => __('Disconnect from Apple', 'wpamelia'),
            'no_package_services'          => __('It seems like there are no available or visible services assigned to the packages, at this moment.', 'wpamelia'),
            'all_slots_selected'           => __('All slots are selected', 'wpamelia'),
            'appointment'                  => __('Appointment', 'wpamelia'),
            'appointments'                 => __('Appointments', 'wpamelia'),
            'appointment_info'             => __('Appointment Info', 'wpamelia'),
            'at'                           => __('at', 'wpamelia'),
            'book'                         => __('Book', 'wpamelia'),
            'booking_completed_email'      => __('An email with details of your booking has been sent to you.', 'wpamelia'),
            'booking_completed_pending'    => __('Thank you! Your booking is completed and now is pending confirmation.', 'wpamelia'),
            'client_time_colon'            => __('Client Time:', 'wpamelia'),
            'cart_info'                    => __('Summary', 'wpamelia'),
            'close'                        => __('Close', 'wpamelia'),
            'closed'                       => __('Closed', 'wpamelia'),
            'expired'                      => __('Expired', 'wpamelia'),
            'customer_blocked'             => __('Booking is currently unavailable. Please try again later.', 'wpamelia'),
            'coupon_invalid'               => __('This coupon is not valid anymore', 'wpamelia'),
            'coupon_expired'               => __('This coupon has expired', 'wpamelia'),
            'coupon_missing'               => __('Please enter coupon', 'wpamelia'),
            'coupon_send_text'             => __('You can use this coupon for next booking: ', 'wpamelia'),
            'coupon_unknown'               => __('The coupon you entered is not valid', 'wpamelia'),
            'coupon_used'                  => __('Used coupon', 'wpamelia'),
            'credit_card'                  => __('Credit Card', 'wpamelia'),
            'mollie'                       => __('Mollie', 'wpamelia'),
            'credit_or_debit_card_colon'   => __('Credit or debit card:', 'wpamelia'),
            'custom_fields'                => __('Custom Fields', 'wpamelia'),
            'customer'                     => __('Customer', 'wpamelia'),
            'customer_already_booked'      => __('Customer has already booked this appointment', 'wpamelia'),
            'date'                         => __('Date', 'wpamelia'),
            'discount_amount_colon'        => __('Discount', 'wpamelia'),
            'email_not_sent_error'         => __('Unfortunately a server error occurred and your email was not sent.', 'wpamelia'),
            'email_placeholder'            => __('example@mail.com', 'wpamelia'),
            'email_required'               => __('Email field is required', 'wpamelia'),
            'employee'                     => __('employee', 'wpamelia'),
            'employees'                    => __('employees', 'wpamelia'),
            'locations'                    => __('locations', 'wpamelia'),
            'event_booking_unavailable'    => __('Event booking is unavailable', 'wpamelia'),
            'extras_costs_colon'           => __('Extras Cost:', 'wpamelia'),
            'file_upload'                  => __('Drop file here or click to upload', 'wpamelia'),
            'file_upload_error'            => __('Please upload the file', 'wpamelia'),
            'forbidden_file_upload'        => __('This file is forbidden for upload', 'wpamelia'),
            'outlook_calendar'             => __('Outlook Calendar', 'wpamelia'),
            'incomplete_cvc'               => __('Your card\'s security code is incomplete', 'wpamelia'),
            'incomplete_expiry'            => __('Your card\'s expiration date is incomplete', 'wpamelia'),
            'incomplete_number'            => __('Your card number is incomplete', 'wpamelia'),
            'incomplete_zip'               => __('Your postal code is incomplete', 'wpamelia'),
            'invalid_expiry_year_past'     => __('Your card\'s expiration year is in the past', 'wpamelia'),
            'invalid_number'               => __('Your card number is invalid', 'wpamelia'),
            'location'                     => __('Location', 'wpamelia'),
            'location_colon'               => __('Location:', 'wpamelia'),
            'maximum_capacity_reached'     => __('Maximum capacity is reached', 'wpamelia'),
            'name'                         => __('Name', 'wpamelia'),
            'no'                           => __('No', 'wpamelia'),
            'number_of_additional_persons' => __('Number of Additional People:', 'wpamelia'),
            'on_line'                      => __('Online', 'wpamelia'),
            'opened'                       => __('Opened', 'wpamelia'),
            'out_of'                       => __('out of', 'wpamelia'),
            'package'                      => __('Package', 'wpamelia'),
            'package_info'                 => __('Package Info', 'wpamelia'),
            'packages'                     => __('Packages', 'wpamelia'),
            'paid'                         => __('Paid', 'wpamelia'),
            'partially_paid'               => __('Partially Paid', 'wpamelia'),
            'paid_deposit'                 => __('Paid deposit', 'wpamelia'),
            'paid_remaining_amount'        => __('Paid remaining amount', 'wpamelia'),
            'pay_pal'                      => __('PayPal', 'wpamelia'),
            'payment_address_error'        => __('Please fill in your address.', 'wpamelia'),
            'payment_error'                => __('Sorry, there was an error processing your payment. Please try again later.', 'wpamelia'),
            'payment_error_default'        => __('Payment error', 'wpamelia'),
            'payment_link_error'           => __('Sorry, there was an error creating a payment link. Please try again later.', 'wpamelia'),
            'payment_method_colon'         => __('Payment Method:', 'wpamelia'),
            'payment_type_colon'           => __('Payment Type:', 'wpamelia'),
            'payment_btn_stripe'           => __('Stripe', 'wpamelia'),
            'payment_btn_mollie'           => __('Online', 'wpamelia'),
            'persons'                      => __('people', 'wpamelia'),
            'people_waiting'               => __('people waiting', 'wpamelia'),
            'person_waiting'               => __('person waiting', 'wpamelia'),
            'phone'                        => __('Phone', 'wpamelia'),
            'please_wait'                  => __('Please Wait', 'wpamelia'),
            'razorpay'                     => __('Razorpay', 'wpamelia'),
            'recaptcha_error'              => __('Please confirm you are not a robot', 'wpamelia'),
            'recaptcha_invalid_error'      => __('Verification expired. Please try again.', 'wpamelia'),
            'required_field'               => __('This field is required', 'wpamelia'),
            'services'                     => __('Services', 'wpamelia'),
            'select_date'                  => __('Select Date', 'wpamelia'),
            'stripe'                       => __('Stripe', 'wpamelia'),
            'subtotal_colon'               => __('Subtotal:', 'wpamelia'),
            'text_mode'                    => __('Text Mode', 'wpamelia'),
            'html_mode'                    => __('HTML Mode', 'wpamelia'),
            'time'                         => __('Time', 'wpamelia'),
            'time_slot_unavailable_plural' => __('Time slots are unavailable', 'wpamelia'),
            'package_booking_unavailable'  => __('Booking is unavailable', 'wpamelia'),
            'waiting_for_payment'          => __('Waiting for payment', 'wpamelia'),
            'wc'                           => __('On-line', 'wpamelia'),
            'wc_appointment_is_removed'    => __('Appointment is removed from the cart.', 'wpamelia'),
            'wc_appointment_remove'        => __('On-line', 'wpamelia'),
            'wc_error'                     => __('Sorry, there was an error while adding booking to WooCommerce cart.', 'wpamelia'),
            'wc_product_name'              => __('Appointment', 'wpamelia'),
            'zoom_join'                    => __('Join Zoom Meeting', 'wpamelia'),
            'zoom_start'                   => __('Start Zoom Meeting', 'wpamelia'),
            'your_position_on_waiting_list'=> __('You are on the waiting list with position', 'wpamelia'),
            'google_meet_join'             => __('Join Google Meeting', 'wpamelia'),
            'microsoft_teams_join'         => __('Join With Microsoft Teams', 'wpamelia'),
            'day'                          => __('Day', 'wpamelia'),
            'days'                         => __('Days', 'wpamelia'),
            'waiting_list_notify_message'  => __('We\'ll notify you if a spot opens up and your booking is approved.', 'wpamelia'),
            'waiting_list_empty'           => __('Waiting list is empty', 'wpamelia'),
            'week'                         => __('Week', 'wpamelia'),
            'weeks'                        => __('Weeks', 'wpamelia'),
            'month'                        => __('Month', 'wpamelia'),
            'months'                       => __('Months', 'wpamelia'),
            'year'                         => __('Year', 'wpamelia'),
            'years'                        => __('Years', 'wpamelia'),
            'free'                         => __('Free', 'wpamelia'),
            'week_days'                    => __('Day of the Week', 'wpamelia'),
            'custom_days'                  => __('Specific Date & Time', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteFrontendStrings::getCommonStrings());
    }

    /**
     * Returns the array of the frontend strings for the search shortcode
     *
     * @return array
     */
    public static function getSearchStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'appointment_date_colon'  => __('Appointment Date:', 'wpamelia'),
            'book_package'            => __('Book Package', 'wpamelia'),
            'bringing_anyone'         => __('Bringing anyone with you?', 'wpamelia'),
            'enter_appointment_date'  => __('Please enter appointment date...', 'wpamelia'),
            'from'                    => __('From', 'wpamelia'),
            'name_asc'                => __('Name Ascending', 'wpamelia'),
            'name_desc'               => __('Name Descending', 'wpamelia'),
            'next'                    => __('Next', 'wpamelia'),
            'no_results_found'        => __('No results found...', 'wpamelia'),
            'of'                      => __('of', 'wpamelia'),
            'price_asc'               => __('Price Ascending', 'wpamelia'),
            'price_desc'              => __('Price Descending', 'wpamelia'),
            'refine_search'           => __('Please refine your search criteria', 'wpamelia'),
            'results'                 => __('results', 'wpamelia'),
            'search'                  => __('Search...', 'wpamelia'),
            'search_filters'          => __('Search Filters', 'wpamelia'),
            'search_results'          => __('Search Results', 'wpamelia'),
            'select_appointment_time' => __('Select the Appointment Time', 'wpamelia'),
            'select_extras'           => __('Select the Extras you\'d like', 'wpamelia'),
            'select_location'         => __('Select Location', 'wpamelia'),
            'showing'                 => __('Showing', 'wpamelia'),
            'time_range_colon'        => __('Time Range:', 'wpamelia'),
            'to_lower'                => __('to', 'wpamelia'),
            'to_upper'                => __('To', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteFrontendStrings::getSearchStrings());
    }

    /**
     * Returns the array of the frontend strings for the booking shortcode
     *
     * @return array
     */
    public static function getBookingStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'add_appointment'              => __('Add appointment', 'wpamelia'),
            'add_extra'                    => __('Add extra', 'wpamelia'),
            'add_people'                   => __('Number of people that are coming with you.', 'wpamelia'),
            'add_people_total'             => __('The total number of people for the booking.', 'wpamelia'),
            'any'                          => __('Any', 'wpamelia'),
            'any_employee'                 => __('Any Employee', 'wpamelia'),
            'auto_fill_your_details'       => __('Auto-fill your details using:', 'wpamelia'),
            'book_appointment'             => __('Book Appointment', 'wpamelia'),
            'bringing_anyone_with_you'     => __('Bringing anyone with you?', 'wpamelia'),
            'card_number_colon'            => __('Card number', 'wpamelia'),
            'coupons_used'                 => __('Coupon Limit Reached', 'wpamelia'),
            'coupons_used_description'     => __('Number of appointments with applied coupon is', 'wpamelia'),
            'disable_popup_blocker'        => __('Popup Blocker is enabled! To add your appointment to your calendar, please allow popups and add this site to your exception list.', 'wpamelia'),
            'employee_information'         => __('Employee information', 'wpamelia'),
            'employee_information_package' => __('Employee information', 'wpamelia'),
            'expires_after'                => __('Expires after', 'wpamelia'),
            'expires_day'                  => __('day', 'wpamelia'),
            'expires_days'                 => __('days', 'wpamelia'),
            'expires_week'                 => __('week', 'wpamelia'),
            'expires_weeks'                => __('weeks', 'wpamelia'),
            'expires_month'                => __('month', 'wpamelia'),
            'expires_months'               => __('months', 'wpamelia'),
            'expires_at'                   => __('Expires at', 'wpamelia'),
            'expires_date_colon'           => __('Expiration date', 'wpamelia'),
            'extras_available'             => __('Extras available', 'wpamelia'),
            'extra_colon'                  => __('Extra:', 'wpamelia'),
            'extra_error'                  => __('Please select the extra:', 'wpamelia'),
            'full_amount_consent'          => __('I want to pay full amount', 'wpamelia'),
            'group_booking_message'        => __('By booking this time slot you will book appointment on top of existing group appointment!', 'wpamelia'),
            'includes_colon'               => __('includes:', 'wpamelia'),
            'min_req_extras_colon'         => __('Minimum required extras:', 'wpamelia'),
            'multiple_locations'           => __('Multiple Locations', 'wpamelia'),
            'or_enter_details_below'       => __('Or enter details below', 'wpamelia'),
            'package_available'            => __('Available in package', 'wpamelia'),
            'package_list_overview'        => __('Overview', 'wpamelia'),
            'package_discount_text'        => __('Save ', 'wpamelia'),
            'package_book_service'         => __('All services are booked separately.', 'wpamelia'),
            'package_book_service_2'       => __('This package has', 'wpamelia'),
            'package_book_duration'        => __('The package is time-limited to', 'wpamelia'),
            'package_book_expire'          => __('Valid Until:', 'wpamelia'),
            'package_book_multiple'        => __('Multiple packages purchased.', 'wpamelia'),
            'package_book_first_pack_apps' => __('Appointments from the first package expire on:', 'wpamelia'),
            'package_book_expiration'      => __('Duration:', 'wpamelia'),
            'package_book_unlimited'       => __('Unlimited', 'wpamelia'),
            'package_next_service'         => __('Next Service', 'wpamelia'),
            'package_min_book'             => __('appointment is required to be booked now.', 'wpamelia'),
            'package_min_book_plural'      => __('appointments are required to be booked now.', 'wpamelia'),
            'payment_protected_policy'     => __('Payment protected by policy and powered by', 'wpamelia'),
            'payment_or_pay_with_card'     => __('Or pay with card', 'wpamelia'),
            'payment_type_deposit_only'    => __('Deposit only', 'wpamelia'),
            'payment_type_full_amount'     => __('Whole amount', 'wpamelia'),
            'payment_wc_mollie_sentence'   => __('You will be redirected to the payment checkout.', 'wpamelia'),
            'person_upper'                 => __('Person', 'wpamelia'),
            'persons_upper'                => __('People', 'wpamelia'),
            'plus_more'                    => __('+more', 'wpamelia'),
            'price_changed_message'        => __('This change will lead to a price increase for certain bookings. Do you want payment links to be created?', 'wpamelia'),
            'qty_colon'                    => __('Qty:', 'wpamelia'),
            'recurring'                    => __('Recurring', 'wpamelia'),
            'recurring_costs_colon'        => __('Recurring Appointments:', 'wpamelia'),
            'recurring_appointments'       => __('Recurring Appointments', 'wpamelia'),
            'recurring_edit'               => __('You can edit or delete each appointment', 'wpamelia'),
            'recurring_sub_message1'       => __('Some of the desired slots are busy. We offered you the nearest time slots instead.', 'wpamelia'),
            'recurring_sub_message2'       => __('Number of adjusted time slots: ', 'wpamelia'),
            'recurring_active'             => __('Repeat this appointment', 'wpamelia'),
            'recurring_type_daily'         => __('Daily', 'wpamelia'),
            'recurring_type_weekly'        => __('Weekly', 'wpamelia'),
            'recurring_type_monthly'       => __('Monthly', 'wpamelia'),
            'recurring_repeat'             => __('Repeat:', 'wpamelia'),
            'recurring_every'              => __('Every:', 'wpamelia'),
            'recurring_until'              => __('Until:', 'wpamelia'),
            'recurring_every_text'         => __('Every', 'wpamelia'),
            'recurring_from_text'          => __('from', 'wpamelia'),
            'recurring_until_text'         => __('until', 'wpamelia'),
            'recurring_on'                 => __('On:', 'wpamelia'),
            'recurring_each'               => __('Each:', 'wpamelia'),
            'recurring_substring_on'       => __('on', 'wpamelia'),
            'recurring_times'              => __('Time(s):', 'wpamelia'),
            'recurring_date_specific'      => __('Specific Date', 'wpamelia'),
            'recurring_date_first'         => __('First', 'wpamelia'),
            'recurring_date_second'        => __('Second', 'wpamelia'),
            'recurring_date_third'         => __('Third', 'wpamelia'),
            'recurring_date_fourth'        => __('Fourth', 'wpamelia'),
            'recurring_date_fifth'         => __('Fifth', 'wpamelia'),
            'recurring_date_last'          => __('Last', 'wpamelia'),
            'recurring_confirm_delete'     => __('Do you want to delete this appointment?', 'wpamelia'),
            'recurring_changed_message'    => __('List of your appointments has changed. Take one more look and continue by clicking the Save button.', 'wpamelia'),
            'remaining_amount_colon'       => __('Remaining Amount:', 'wpamelia'),
            'repeat_appointment'           => __('Repeat Appointment', 'wpamelia'),
            'repeat_appointment_quest'     => __('Do you want to repeat this appointment?', 'wpamelia'),
            'select_this_employee'         => __('Select this Employee', 'wpamelia'),
            'select_this_employee_package' => __('Select this Employee', 'wpamelia'),
            'subscribe_to_mailing_list'    => __('Subscribe to our mailing list', 'wpamelia'),
            'upload_file_here'             => __('Upload file here', 'wpamelia'),
            'without_expiration'           => __('Without expiration', 'wpamelia'),

            'select_location'              => __('Select Location', 'wpamelia'),
            'employee_colon'               => __('Employee', 'wpamelia'),
            'select_employee'              => __('Select Employee', 'wpamelia'),
            'please_select_employee'       => __('Please select employee', 'wpamelia'),
            'please_select_location'       => __('Please select location', 'wpamelia'),
            'dropdown_empty'               => __('No matching data', 'wpamelia'),

            'bringing_anyone'              => __('Bringing Anyone With You', 'wpamelia'),
            'bringing_anyone_title'        => __('Bringing anyone with you?', 'wpamelia'),
            'bringing_price'               => __('Pricing by the number of people', 'wpamelia'),
            'bringing_people'              => __('Additional people', 'wpamelia'),
            'bringing_people_total'        => __('Total people', 'wpamelia'),
            'bringing_yes'                 => __('Yes', 'wpamelia'),
            'bringing_no'                  => __('No', 'wpamelia'),

            'package_selection'            => __('Package Selection', 'wpamelia'),
            'package_heading'              => __('Hey, there are special packages with this service, check them out!', 'wpamelia'),
            'discount_save'                => __('Save', 'wpamelia'),
            'separator_or'                 => __('Or', 'wpamelia'),
            'continue_without_package'     => __('Skip packages and continue with the selected service', 'wpamelia'),

            'extras'                       => __('Extras', 'wpamelia'),
            'extras_card_open'             => __('Learn More', 'wpamelia'),
            'extras_card_close'            => __('Hide', 'wpamelia'),

            'date_time_slots_selected'     => __('All slots are selected', 'wpamelia'),

            'cart_step'                    => __('Cart', 'wpamelia'),
            'cart_add_button'              => __('Book another', 'wpamelia'),
            'cart_view_button'             => __('View Cart', 'wpamelia'),
            'cart_title'                   => __('You can find below the appointments you selected for booking. If you want to book more, click on the button below.'),

            'recurring_step'               => __('Recurring Appointment', 'wpamelia'),
            'recurrence'                   => __('Recurrence', 'wpamelia'),
            'recurrence_choosing_time'     => __('Choose time you want to repeat appointment', 'wpamelia'),
            'repeat_every'                 => __('Repeat every', 'wpamelia'),
            'recurrence_day'               => __('day', 'wpamelia'),
            'recurrence_week'              => __('week', 'wpamelia'),
            'recurrence_month'             => __('month', 'wpamelia'),
            'recurrence_days'              => __('days', 'wpamelia'),
            'recurrence_weeks'             => __('weeks', 'wpamelia'),
            'recurrence_months'            => __('months', 'wpamelia'),
            'recurrence_repeat_on'         => __('Repeat on', 'wpamelia'),
            'recurrence_specific_date'     => __('Specific date', 'wpamelia'),
            'recurrence_first'             => __('First', 'wpamelia'),
            'recurrence_second'            => __('Second', 'wpamelia'),
            'recurrence_third'             => __('Third', 'wpamelia'),
            'recurrence_fourth'            => __('Fourth', 'wpamelia'),
            'recurring_fifth'              => __('Fifth', 'wpamelia'),
            'recurrence_last'              => __('Last', 'wpamelia'),
            'recurrence_ends'              => __('Ends', 'wpamelia'),
            'recurrence_choose_ends'       => __('Choose when the repeating ends', 'wpamelia'),
            'recurrence_on'                => __('On', 'wpamelia'),
            'recurrence_each'              => __('Each', 'wpamelia'),
            'recurrence_select_date'       => __('Select Date', 'wpamelia'),
            'recurrence_after'             => __('After', 'wpamelia'),
            'occurrences'                  => __('Occurrences', 'wpamelia'),
            'appointment_repeats'          => __('Appointment Repeats', 'wpamelia'),
            'recurrence_every'             => __('Every', 'wpamelia'),
            'repeats_on'                   => __('on', 'wpamelia'),
            'repeats_at'                   => __('at', 'wpamelia'),
            'repeats_from'                 => __('from', 'wpamelia'),
            'ends_after'                   => __('Ends after', 'wpamelia'),
            'ends_on'                      => __('Ends on', 'wpamelia'),

            'recurring_summary'            => __('Recurring Summary', 'wpamelia'),
            'recurring_unavailable_slots'  => __('Unavailable Time Slots', 'wpamelia'),
            'recurring_alert_content'      => __('slots you selected are busy. We offered you the nearest time slots instead.', 'wpamelia'),
            'recurring_chose_date'         => __('Choose Date and Time', 'wpamelia'),
            'recurring_delete'             => __('Delete', 'wpamelia'),
            'number_of_recurrences'        => __('Number of Recurrences:', 'wpamelia'),
            'recurring_slots_selected'     => __('All slots are selected', 'wpamelia'),

            'package_info_step'            => __('Package', 'wpamelia'),
            'package_info_discount'        => __('Save', 'wpamelia'),
            'package_info_includes'        => __('includes', 'wpamelia'),
            'package_info_employees'       => __('Employees', 'wpamelia'),

            'package_appointment_step'            => __('Appointments', 'wpamelia'),
            'package_appointment_required'        => __('Number of appointments required for booking', 'wpamelia'),
            'package_appointment_remaining'       => __('The rest of the appointments can be booked later on the Customers panel.', 'wpamelia'),
            'package_appointment_employee'        => __('Employee', 'wpamelia'),
            'package_select_employee'             => __('Select Employee', 'wpamelia'),
            'package_appointment_location'        => __('Location', 'wpamelia'),
            'package_select_location'             => __('Select Location', 'wpamelia'),
            'package_appointments'                => __('Appointments', 'wpamelia'),
            'package_appointments_date'           => __('Date and Time', 'wpamelia'),
            'package_appointments_select'         => __('Select', 'wpamelia'),
            'package_appointments_selected'       => __('Selected', 'wpamelia'),
            'package_appointments_add_more'       => __('Add more Appointments', 'wpamelia'),
            'package_appointments_slots_selected' => __('All slots are selected', 'wpamelia'),

            'package_booking_overview'           => __('Booking Overview', 'wpamelia'),
            'package_overview_all_selected'      => __('All appointments are selected', 'wpamelia'),
            'package_overview_selected_later'    => __('All appointments will be selected later', 'wpamelia'),
            'package_overview_info'              => __('Appointment information', 'wpamelia'),
            'package_overview_date'              => __('Date', 'wpamelia'),
            'package_overview_time'              => __('Time', 'wpamelia'),
            'package_overview_employee'          => __('Employee', 'wpamelia'),
            'package_overview_location'          => __('Location', 'wpamelia'),

            'package_info'                 => __('Package', 'wpamelia'),

            'coupon'                       => __('Coupon', 'wpamelia'),
            'coupon_mandatory'             => __('The coupon field is mandatory', 'wpamelia'),
            'add_coupon_btn'               => __('Add', 'wpamelia'),
            'summary_services_subtotal'    => __('Service Subtotal', 'wpamelia'),
            'summary_persons'              => __('people', 'wpamelia'),
            'summary_recurrence'           => __('Recurrence', 'wpamelia'),
            'summary_recurrences'          => __('Recurrences', 'wpamelia'),
            'summary_extras'               => __('Extras', 'wpamelia'),
            'summary_extras_subtotal'      => __('Extras Subtotal', 'wpamelia'),
            'summary_package'              => __('Package', 'wpamelia'),
            'summary_event_subtotal'       => __('Event Subtotal', 'wpamelia'),
            'paying_now'                   => __('Paying now', 'wpamelia'),
            'paying_later'                 => __('Paying later', 'wpamelia'),

            'congrats_total_amount'        => __('Total Amount', 'wpamelia'),
            'congrats_package'             => __('Package', 'wpamelia'),
            'congrats_location'            => __('Location', 'wpamelia'),
            'congrats_panel'               => __('Customer Panel', 'wpamelia'),
            'congrats_cart'                => __('Total Services Booked', 'wpamelia'),

            'whatsapp_opt_in_text'         => __('By entering your phone number you agree to receive messages via WhatsApp', 'wpamelia'),
            'total_tax_colon'              => __('VAT', 'wpamelia'),
            'incl_tax'                     => __('Incl. VAT', 'wpamelia'),

            'location_information'         => __('Location information', 'wpamelia'),
            'any_location'                 => __('Any Location', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteFrontendStrings::getBookingStrings());
    }

    /**
     * Returns the array of the frontend strings for the event shortcode
     *
     * @return array
     */
    public static function getEventStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'add_ticket_category'       => __('Add Pricing Category', 'wpamelia'),
            'apply_to_all'              => __('Apply this to all recurring events', 'wpamelia'),
            'custom_pricing_warning'    => __('Custom pricing spots will override Maximum allowed spots value.', 'wpamelia'),
            'custom_pricing_adjustment' => __('Custom/regular pricing adjustments are not permitted for events with confirmed attendees.', 'wpamelia'),
            'custom_pricing_date_warning' => __('Set event period first to enable pricing by date range.', 'wpamelia'),
            'event'                     => __('Event', 'wpamelia'),
            'events'                    => __('Events', 'wpamelia'),
            'event_about'               => __('About this Event', 'wpamelia'),
            'event_add_date_range'      => __('Add Date Range', 'wpamelia'),
            'event_free'                => __('Free', 'wpamelia'),
            'event_book_now'            => __('Book now', 'wpamelia'),
            'ev_spot'                   => __('Spot', 'wpamelia'),
            'ev_spots'                  => __('Spots', 'wpamelia'),
            'ev_no_spots'               => __('No spots left', 'wpamelia'),
            'event_book_persons'        => __('Number of people', 'wpamelia'),
            'event_book_tickets'        => __('Number of tickets', 'wpamelia'),
            'event_date_range_warning'  => __('Date Ranges that are not defined will use default price from ticket category.', 'wpamelia'),
            'event_pick_min_date'       => __('Show from date', 'wpamelia'),
            'event_type'                => __('Event Type', 'wpamelia'),
            'event_status'              => __('Event Status', 'wpamelia'),
            'event_employee'            => __('Event Employee', 'wpamelia'),
            'event_today'               => __('Today', 'wpamelia'),
            'event_upcoming_events'     => __('Upcoming events', 'wpamelia'),
            'event_spot'                => __('spot left', 'wpamelia'),
            'event_spots_left'          => __('spots left', 'wpamelia'),
            'event_spots'               => __('Spots', 'wpamelia'),
            'event_no_spots'            => __('No spots left', 'wpamelia'),
            'event_day'                 => __('Day', 'wpamelia'),
            'event_organizer'           => __('Organizer', 'wpamelia'),
            'event_organizer_tooltip'   => __('Here you can assign yourself to be the organizer of the Google/Outlook event.<br> Otherwise you will be assigned as staff and added as a guest in the event', 'wpamelia'),
            'event_schedule'            => __('Schedule:', 'wpamelia'),
            'event_hosted_by'           => __('Hosted by:', 'wpamelia'),
            'event_many_people'         => __('How many people are coming?', 'wpamelia'),
            'event_upcoming_empty'      => __('There are no upcoming events for this period', 'wpamelia'),
            'event_ticket_name'         => __('Ticket name', 'wpamelia'),
            'event_ticket'              => __('Ticket', 'wpamelia'),
            'event_tickets'             => __('Tickets', 'wpamelia'),
            'event_tickets_context'     => __('Select the number of tickets that you want to book for each ticket type', 'wpamelia'),
            'event_ticket_types'        => __('Ticket Types', 'wpamelia'),
            'no_events'                 => __('No results found...', 'wpamelia'),
            'event_select_tickets'      => __('Select Tickets', 'wpamelia'),
            'congrats_panel'            => __('Customer Panel', 'wpamelia'),
            'join_waiting_list'         => __('Join waiting list', 'wpamelia'),
            'waiting_list'              => __('Waiting list', 'wpamelia'),
            'event_page'                => __('Page', 'wpamelia'),
            'event_calendar'            => __('Calendar', 'wpamelia'),
            'event_begins'              => __('Begins', 'wpamelia'),
            'about'                     => __('About', 'wpamelia'),
            'event_tickets_left'        => __('tickets left', 'wpamelia'),
            'event_ticket_left'         => __('ticket left', 'wpamelia'),
            'back_btn'                  => __('Go Back', 'wpamelia'),
            'evt_empty_message'         => __('There are no upcoming events for this period', 'wpamelia'),
            'upcoming'                  => __('Upcoming', 'wpamelia'),
            'waiting'                   => __('Waiting', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteFrontendStrings::getEventStrings());
    }

    /**
     * Returns the array of the frontend strings for the catalog shortcode
     *
     * @return array
     */
    public static function getCatalogStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'booking_appointment'                => __('Booking Appointment', 'wpamelia'),
            'buffer_time'                        => __('Buffer Time', 'wpamelia'),
            'description_colon'                  => __('Description:', 'wpamelia'),
            'extras'                             => __('Extras', 'wpamelia'),
            'maximum_quantity_colon'             => __('Maximum Quantity:', 'wpamelia'),
            'filter_employee'                    => __('Filter by Employee', 'wpamelia'),
            'filter_location'                    => __('Filter by Location', 'wpamelia'),
            'filter_all'                         => __('All', 'wpamelia'),
            'filter_packages'                    => __('Packages', 'wpamelia'),
            'filter_services'                    => __('Services', 'wpamelia'),
            'services'                           => __('Services', 'wpamelia'),
            'package'                            => __('Package', 'wpamelia'),
            'packages'                           => __('Packages', 'wpamelia'),
            'view_employees'                     => __('View Employees', 'wpamelia'),
            'save'                               => __('Save', 'wpamelia'),
            'free'                               => __('Free', 'wpamelia'),
            'in_package'                         => __('In Package', 'wpamelia'),
            'about_package'                      => __('About Package', 'wpamelia'),
            'service_available_in_package'       => __('This service is available in a Package', 'wpamelia'),
            'more_packages'                      => __('View More Packages', 'wpamelia'),
            'less_packages'                      => __('View Less Packages', 'wpamelia'),
            'package_includes'                   => __('Package includes', 'wpamelia'),
            'expires_day'                        => __('day', 'wpamelia'),
            'expires_days'                       => __('days', 'wpamelia'),
            'expires_week'                       => __('week', 'wpamelia'),
            'expires_weeks'                      => __('weeks', 'wpamelia'),
            'expires_month'                      => __('month', 'wpamelia'),
            'expires_months'                     => __('months', 'wpamelia'),
            'employees'                          => __('Employees', 'wpamelia'),
            'employee_info'                      => __('Employee information', 'wpamelia'),
            'book_service'                       => __('Book This Service', 'wpamelia'),
            'book_package'                       => __('Book This Package', 'wpamelia'),
            'no_search_data'                     => __('No results', 'wpamelia'),
            'tab_employees'                      => __('Employees', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteFrontendStrings::getCatalogStrings());
    }

    /**
     * Returns the array of the frontend strings for the cabinet shortcode
     *
     * @return array
     */
    public static function getFrontendCabinetAuthStrings()
    {
        return [
            'access_link_send'                       => __('Send Access Link', 'wpamelia'),
            'access_link_send_description'           => __('Enter your account email address and we will send you an access link to your inbox.', 'wpamelia'),
            'access_link_send_check'                 => __('Check your email', 'wpamelia'),
            'access_link_send_click'                 => __('Click on the activation link in the e-mail we sent to', 'wpamelia'),
            'access_link_send_inbox'                 => __('Did not receive the email? Check your spam filter, or', 'wpamelia'),
            'access_link_send_retry'                 => __('try different email', 'wpamelia'),

            'enter_credentials'                      => __('Enter your credentials to access your account.', 'wpamelia'),
            'email_or_username'                      => __('Email or Username', 'wpamelia'),
            'enter_email_or_username_warning'        => __('Please enter email or username', 'wpamelia'),
            'enter_password_warning'                 => __('Please enter password', 'wpamelia'),

            'forgot_password'                        => __('Forgot Password?', 'wpamelia'),
            'forgot_your_password'                   => __('Forgot your password?', 'wpamelia'),
            'reset_password'                         => __('Reset Password', 'wpamelia'),

            'curr_password_colon'                    => __('Current Password', 'wpamelia'),
            'curr_password_required'                 => __('Not match to your current password', 'wpamelia'),
            'new_password_set'                       => __('Set Password', 'wpamelia'),
            'new_password_set_action'                => __('Set Password', 'wpamelia'),
            'new_password_set_description'           => __('Enter, and re-enter your new password to continue', 'wpamelia'),
            'new_password_colon'                     => __('New Password:', 'wpamelia'),
            'new_password_colon_retype'              => __('Re-type New Password:', 'wpamelia'),
            'new_password_required'                  => __('Please enter new password', 'wpamelia'),
            'new_password_length'                    => __('Password must be longer than 3 characters', 'wpamelia'),
            'new_password_changed'                   => __('Password Updated!', 'wpamelia'),
            'new_password_changed_description'       => __('Your password has been changed successfully. Use your new password to log in.', 'wpamelia'),
            'or_enter_details_below'                 => __('Or Enter details below', 'wpamelia'),
            'passwords_not_match'                    => __('Passwords do not match', 'wpamelia'),

            'password'                               => __('Password', 'wpamelia'),

            'send'                                   => __('Send', 'wpamelia'),
            'sign_in'                                => __('Sign In', 'wpamelia'),

            'welcome_back'                           => __('Welcome Back', 'wpamelia'),
        ];
    }

    /**
     * Returns the array of the frontend strings for the event shortcode
     *
     * @return array
     */
    public static function getCabinetStrings()
    {
        $labels = Licence\Licence::$premium ? [
            'add_customer'                           => __('Add Customer', 'wpamelia'),
            'add_date'                               => __('Add Date', 'wpamelia'),
            'add_day_off'                            => __('Add Day Off', 'wpamelia'),
            'add_day_off_placeholder'                => __('Enter holiday or day off name', 'wpamelia'),
            'add_period'                             => __('Add Period', 'wpamelia'),
            'add_break'                              => __('Add Break', 'wpamelia'),
            'add_special_day'                        => __('Add Special Day', 'wpamelia'),
            'apply_to_all_days'                      => __('Apply to All Days', 'wpamelia'),
            'booking_added_success'                  => __('Successfully added booking', 'wpamelia'),
            'apple_calendar_tooltip'                 => __('Here you can connect employee with Apple Calendar,<br/>so once the booking is scheduled it will be<br/>automatically added to employee\'s calendar.', 'wpamelia'),
            'apple_calendar_employee_tooltip'        => __('Here, you can connect your personal Apple Calendar,<br/>so once the booking is scheduled,<br/>it will be automatically added to your calendar of choice.', 'wpamelia'),
            'apple_calendar_overridden_by_employee'  => __('Overridden by employee', 'wpamelia'),
            'apple_calendar_disconnect_employee'     => __('Disconnect Employee', 'wpamelia'),
            'appointment_canceled'                   => __('Appointment Canceled', 'wpamelia'),
            'appointment_change_time'                => __('To reschedule your appointment, select an available date time from the calendar, then click Confirm.', 'wpamelia'),
            'appointment_deleted'                    => __('Appointment has been deleted', 'wpamelia'),
            'appointment_rescheduled'                => __('Appointment has been rescheduled', 'wpamelia'),
            'appointment_saved'                      => __('Appointment has been saved', 'wpamelia'),
            'appointments'                           => __('Appointments', 'wpamelia'),
            'appointment_booked'                     => __('Appointment booked', 'wpamelia'),
            'appointments_booked'                    => __('Appointments booked', 'wpamelia'),
            'appointments_to_book'                   => __('Appointments to book', 'wpamelia'),
            'approved'                               => __('Approved', 'wpamelia'),
            'assigned_services'                      => __('Assigned Services', 'wpamelia'),
            'attendees'                              => __('Attendees', 'wpamelia'),
            'away'                                   => __('Away', 'wpamelia'),
            'booking_closes'                         => __('Booking Closes', 'wpamelia'),
            'booking_opens'                          => __('Booking Opens', 'wpamelia'),
            'booking_reschedule_exception'           => __('Appointment can\'t be rescheduled', 'wpamelia'),
            'break'                                  => __('On Break', 'wpamelia'),
            'break_hours'                            => __('Break Hours', 'wpamelia'),
            'breaks'                                 => __('Breaks', 'wpamelia'),
            'busy'                                   => __('Busy', 'wpamelia'),
            'cancel'                                 => __('Cancel', 'wpamelia'),
            'cancel_appointment'                     => __('Cancel Appointment', 'wpamelia'),
            'cancel_event'                           => __('Cancel Event', 'wpamelia'),
            'cancel_following'                       => __('Cancel following', 'wpamelia'),
            'cancel_package'                         => __('Cancel Package', 'wpamelia'),
            'canceled'                               => __('Canceled', 'wpamelia'),
            'capacity'                               => __('Capacity', 'wpamelia'),
            'category'                               => __('Category', 'wpamelia'),
            'change_group_status'                    => __('Change group status', 'wpamelia'),
            'change_password'                        => __('Change Password', 'wpamelia'),
            'choose_a_group_service'                 => __('Choose a group service', 'wpamelia'),
            'choose_appointment_date'                => __('Please choose appointment date', 'wpamelia'),
            'choose_appointment_time'                => __('Please choose appointment time', 'wpamelia'),
            'company_days_off'                       => __('Company Days off', 'wpamelia'),
            'confirm_cancel'                         => __('Are you sure you want to cancel this event?', 'wpamelia'),
            'confirm_cancel_appointment'             => __('Are you sure you want to cancel this appointment?', 'wpamelia'),
            'confirm_cancel_event'                   => __('Are you sure you want to cancel your attendance?', 'wpamelia'),
            'confirm_cancel_following'               => __('Do you want to cancel following events?', 'wpamelia'),
            'confirm_cancel_package'                 => __('Do you want to cancel this purchase?', 'wpamelia'),
            'confirm_delete'                         => __('Are you sure you want to delete this event?', 'wpamelia'),
            'confirm_delete_appointment'             => __('Are you sure you want to delete this appointment?', 'wpamelia'),
            'confirm_delete_attendee'                => __('Are you sure you want to delete selected attendee?', 'wpamelia'),
            'confirm_delete_attendees'               => __('Are you sure you want to delete selected attendees?', 'wpamelia'),
            'confirm_delete_following'               => __('Do you want to delete following canceled events?', 'wpamelia'),
            'confirm_duplicate_appointment'          => __('Are you sure you want to duplicate this appointment?', 'wpamelia'),
            'confirm_duplicate_event'                => __('Are you sure you want to duplicate this event?', 'wpamelia'),
            'confirm_open'                           => __('Are you sure you want to open this event?', 'wpamelia'),
            'confirm_open_following'                 => __('Do you want to open following events?', 'wpamelia'),
            'confirm_save_following'                 => __('Do you want to update following events?', 'wpamelia'),
            'confirm_save_following_2'               => __('Tickets for events with attendees will not be updated', 'wpamelia'),
            'confirm_save_conflict'                  => __('There is an event in Google/Outlook Calendar that overlaps this one for a specific employee, are you sure you want to create another one?', 'wpamelia'),
            'create_new'                             => __('Create New', 'wpamelia'),
            'custom_fields'                          => __('Custom Fields', 'wpamelia'),
            'customer_profile'                       => __('Customer Profile ', 'wpamelia'),
            'customers'                              => __('Customers', 'wpamelia'),
            'customers_singular_plural'              => __('Customer(s)', 'wpamelia'),
            'customers_tooltip'                      => __('Indicates the number of new and returning customers<br/>for the selected date range.', 'wpamelia'),
            'customize'                              => __('Customize', 'wpamelia'),
            'date'                                   => __('Date', 'wpamelia'),
            'date_of_birth'                          => __('Date of Birth', 'wpamelia'),
            'enter_date_of_birth'                    => __('Enter date of birth', 'wpamelia'),
            'enter_date_of_birth_warning'            => __('Please enter date of birth', 'wpamelia'),
            'day1'                                   => __('1 day', 'wpamelia'),
            'day_off_name'                           => __('Day Off name', 'wpamelia'),
            'dayoff'                                 => __('Day Off', 'wpamelia'),
            'days2'                                  => __('2 days', 'wpamelia'),
            'days3'                                  => __('3 days', 'wpamelia'),
            'days4'                                  => __('4 days', 'wpamelia'),
            'days5'                                  => __('5 days', 'wpamelia'),
            'days6'                                  => __('6 days', 'wpamelia'),
            'days_off'                               => __('Days Off', 'wpamelia'),
            'days_off_add'                           => __('Add Day Off', 'wpamelia'),
            'days_off_date_warning'                  => __('Please enter date', 'wpamelia'),
            'days_off_name_warning'                  => __('Please enter name', 'wpamelia'),
            'days_off_repeat_yearly'                 => __('Repeat Yearly', 'wpamelia'),
            'delete'                                 => __('Delete', 'wpamelia'),
            'delete_following'                       => __('Delete following', 'wpamelia'),
            'delete_profile'                         => __('Delete profile', 'wpamelia'),
            'delete_profile_confirm'                 => __('Delete profile', 'wpamelia'),
            'delete_profile_description'             => __('Are you sure you want to delete your profile? You will lose access to all your bookings and access to the customer panel.', 'wpamelia'),
            'description'                            => __('Description', 'wpamelia'),
            'details'                                => __('Details', 'wpamelia'),
            'disabled'                               => __('Disabled', 'wpamelia'),
            'discount_amount'                        => __('Discount', 'wpamelia'),
            'duration'                               => __('Duration', 'wpamelia'),
            'edit'                                   => __('Edit', 'wpamelia'),
            'edit_appointment'                       => __('Edit Appointment', 'wpamelia'),
            'edit_customer'                          => __('Edit Customer', 'wpamelia'),
            'edit_event'                             => __('Edit Event', 'wpamelia'),
            'email'                                  => __('Email', 'wpamelia'),
            'employee_days_off'                      => __('Employee Days off', 'wpamelia'),
            'enter_address'                          => __('Enter Address', 'wpamelia'),
            'enter_employee_icloud_id'               => __('Enter Apple Calendar iCloud Id', 'wpamelia'),
            'enter_employee_app_specific_pass'       => __('Enter Apple Calendar app specific password', 'wpamelia'),
            'enter_event_name'                       => __('Enter Event Name', 'wpamelia'),
            'enter_event_name_warning'               => __('Please enter name', 'wpamelia'),
            'enter_location_warning'                 => __('Please select location', 'wpamelia'),
            'enter_valid_email_warning'              => __('Please enter a valid email address', 'wpamelia'),
            'error'                                  => __('Error', 'wpamelia'),
            'event_add_attendee'                     => __('Add Attendee', 'wpamelia'),
            'event_attendee_deleted'                 => __('Attendee have been deleted', 'wpamelia'),
            'event_attendee_not_deleted'             => __('Attendee have not been deleted', 'wpamelia'),
            'event_attendee_remove'                  => __('Remove Attendee', 'wpamelia'),
            'event_attendee_saved'                   => __('Attendee has been saved', 'wpamelia'),
            'event_edit_attendees'                   => __('Edit Attendees', 'wpamelia'),
            'event_aggregated_price'                 => __('The price will multiply by the number of people/spots', 'wpamelia'),
            'event_attendees'                        => __('Attendees', 'wpamelia'),
            'event_attendees_deleted'                => __('Attendees have been deleted', 'wpamelia'),
            'event_attendees_not_deleted'            => __('Attendees have not been deleted', 'wpamelia'),
            'event_book_more_than_once'              => __('Allow the same customer to book more than once', 'wpamelia'),
            'event_attendees_search'                 => __('Find Attendees', 'wpamelia'),
            'event_booking_closes_after'             => __('Booking closes when event starts', 'wpamelia'),
            'event_booking_closes_on'                => __('Closes on:', 'wpamelia'),
            'event_booking_closes_apply'             => __('If this option is not checked the plugin will calculate the time <br> for closing the booking based on the selected time for the first event', 'wpamelia'),
            'event_booking_opens_apply'              => __('If this option is not checked the plugin will calculate the time <br> for opening the booking based on the selected time for the first event', 'wpamelia'),
            'event_booking_opens_now'                => __('Booking opens immediately', 'wpamelia'),
            'event_booking_opens_on'                 => __('Opens on:', 'wpamelia'),
            'event_bringing_anyone'                  => __('Allow bringing more people', 'wpamelia'),
            'event_cancel'                           => __('Cancel Event', 'wpamelia'),
            'event_canceled'                         => __('Event has been canceled', 'wpamelia'),
            'event_close_after_min'                  => __('Close Event after certain minimum is reached', 'wpamelia'),
            'event_close_min_total'                  => __('Minimum of attendees', 'wpamelia'),
            'event_close_min_bookings'               => __('Minimum of bookings', 'wpamelia'),
            'event_close_min_total_tt'               => __('One spot is equal to one attendee.', 'wpamelia'),
            'event_close_min_bookings_tt'            => __('One booking can have multiple attendees/spots in it.', 'wpamelia'),
            'event_close_minimum'                    => __('Set Minimum', 'wpamelia'),
            'event_colors'                           => __('Event Colors:', 'wpamelia'),
            'event_colors_custom'                    => __('Custom Color', 'wpamelia'),
            'event_colors_preset'                    => __('Preset Colors', 'wpamelia'),
            'event_custom_address'                   => __('Custom Address', 'wpamelia'),
            'event_delete'                           => __('Delete Event', 'wpamelia'),
            'event_deleted'                          => __('Event has been deleted', 'wpamelia'),
            'event_details'                          => __('Details', 'wpamelia'),
            'event_duplicate'                        => __('Duplicate', 'wpamelia'),
            'event_edit_attendee'                    => __('Edit Attendee', 'wpamelia'),
            'event_gallery'                          => __('Event Gallery:', 'wpamelia'),
            'event_max_capacity'                     => __('Maximum allowed spots', 'wpamelia'),
            'event_name'                             => __('Name:', 'wpamelia'),
            'event_open'                             => __('Open Event', 'wpamelia'),
            'event_opened'                           => __('Event has been opened', 'wpamelia'),
            'event_period_dates'                     => __('Dates:', 'wpamelia'),
            'event_period_time'                      => __('Time:', 'wpamelia'),
            'event_recurring_enabled'                => __('This is recurring event', 'wpamelia'),
            'event_recurring_check'                  => __('Enable recurring event', 'wpamelia'),
            'event_recurring_period'                 => __('Repeat Event', 'wpamelia'),
            'event_recurring_until'                  => __('Until when?', 'wpamelia'),
            'event_saved'                            => __('Event has been saved', 'wpamelia'),
            'event_select_address'                   => __('Select Address', 'wpamelia'),
            'event_show_on_site'                     => __('Show event on site', 'wpamelia'),
            'events_show_waiting_list_booking_full'  => __('Show waiting list after booking is full', 'wpamelia'),
            'event_staff'                            => __('Staff', 'wpamelia'),
            'event_status_changed'                   => __('Booking status has been changed to ', 'wpamelia'),
            'event_tags'                             => __('Tags', 'wpamelia'),
            'event_tags_create'                      => __('No Tags. Create a new one.', 'wpamelia'),
            'event_tags_select_or_create'            => __('Select or Create Tag', 'wpamelia'),
            'events_dropdown'                        => __('Event', 'wpamelia'),
            'export'                                 => __('Export', 'wpamelia'),
            'export_tooltip_attendees'               => __('You can use this option to export attendees in CSV file<br/>for the selected event.', 'wpamelia'),
            'extras'                                 => __('Extras', 'wpamelia'),
            'general'                                => __('General', 'wpamelia'),
            'google_calendar'                        => __('Google Calendar', 'wpamelia'),
            'google_calendar_tooltip'                => __('Connect your Google Calendar here so once<br/>the appointment is scheduled it can be added<br/>to your Google Calendar automatically.', 'wpamelia'),
            'google_sign_in'                         => __('Sign in with Google', 'wpamelia'),
            'google_sign_out'                        => __('Sign out from Google', 'wpamelia'),
            'h1'                                     => __('1h', 'wpamelia'),
            'h10'                                    => __('10h', 'wpamelia'),
            'h11'                                    => __('11h', 'wpamelia'),
            'h12'                                    => __('12h', 'wpamelia'),
            'h1min30'                                => __('1h 30min', 'wpamelia'),
            'h2'                                     => __('2h', 'wpamelia'),
            'h3'                                     => __('3h', 'wpamelia'),
            'h4'                                     => __('4h', 'wpamelia'),
            'h6'                                     => __('6h', 'wpamelia'),
            'h8'                                     => __('8h', 'wpamelia'),
            'h9'                                     => __('9h', 'wpamelia'),
            'invalid_credentials'                    => __('Incorrect email or password', 'wpamelia'),
            'integrations_settings'                  => __('Integrations', 'wpamelia'),
            'lesson_space'                           => __('Lesson Space', 'wpamelia'),
            'lesson_space_join'                      => __('Join Space', 'wpamelia'),
            'lesson_space_link'                      => __('Lesson Space Link', 'wpamelia'),
            'lesson_space_links'                     => __('Lesson Space Links', 'wpamelia'),
            'lesson_space_new_space'                 => __('New Space', 'wpamelia'),
            'limit_extra_people'                     => __('Limit the additional number of people', 'wpamelia'),
            'limit_extra_people_set'                 => __('Set Limit', 'wpamelia'),
            'limit_extra_people_tooltip'             => __('Limit the number of people that one customer can add during the booking', 'wpamelia'),
            'linked'                                 => __('Linked', 'wpamelia'),
            'loader_message'                         => __('Please Wait', 'wpamelia'),
            'locations_dropdown'                     => __('Location', 'wpamelia'),
            'login'                                  => __('Login', 'wpamelia'),
            'login_email_placeholder'                => __('Enter your email', 'wpamelia'),
            'login_password_placeholder'             => __('Enter your password', 'wpamelia'),
            'logout'                                 => __('Logout', 'wpamelia'),
            'mandatory_service_remove_fail_all'      => __('You are the only provider on', 'wpamelia'),
            'mandatory_service_remove_fail'          => __('You are the only provider for this service', 'wpamelia'),
            'maximum_capacity'                       => __('Max. Capacity', 'wpamelia'),
            'min1'                                   => __('1min', 'wpamelia'),
            'min10'                                  => __('10min', 'wpamelia'),
            'min12'                                  => __('12min', 'wpamelia'),
            'min15'                                  => __('15min', 'wpamelia'),
            'min2'                                   => __('2min', 'wpamelia'),
            'min20'                                  => __('20min', 'wpamelia'),
            'min30'                                  => __('30min', 'wpamelia'),
            'min45'                                  => __('45min', 'wpamelia'),
            'min5'                                   => __('5min', 'wpamelia'),
            'minimum_capacity'                       => __('Min. Capacity', 'wpamelia'),
            'minimum_time_before_canceling'          => __('Minimum time required before canceling', 'wpamelia'),
            'minimum_time_before_canceling_tooltip'  => __('Set the time before the appointment when customers<br/>will not be able to cancel the appointment.', 'wpamelia'),
            'months3'                                => __('3 months', 'wpamelia'),
            'months6'                                => __('6 months', 'wpamelia'),
            'multiple_emails'                        => __('Multiple Emails', 'wpamelia'),
            'my_profile'                             => __('My Profile', 'wpamelia'),
            'new_appointment'                        => __('New Appointment', 'wpamelia'),
            'new_event'                              => __('New Event', 'wpamelia'),
            'no_attendees_yet'                       => __('There are no attendees yet...', 'wpamelia'),
            'no_special_days_yet'                    => __('There are no special days yet...', 'wpamelia'),
            'no_days_off_yet'                        => __('There are no days off yet...', 'wpamelia'),
            'no_selected_extras_requirements'        => __('Select customer, employee and service', 'wpamelia'),
            'no_selected_slot_requirements'          => __('Select date and time', 'wpamelia'),
            'no-show'                                => __('No-show', 'wpamelia'),
            'note'                                   => __('Note', 'wpamelia'),
            'note_internal'                          => __('Note (Internal)', 'wpamelia'),
            'notify_attendees'                       => __('Notify the attendee(s)', 'wpamelia'),
            'notify_attendees_tooltip'               => __('Check this checkbox if you want your attendee(s) to<br/>receive an email about the event’s updated information.', 'wpamelia'),
            'notify_customers'                       => __('Notify the customer(s)', 'wpamelia'),
            'notify_customers_tooltip'               => __('Check this checkbox if you want your customer to<br/>receive an email about the scheduled appointment.', 'wpamelia'),
            'once_off'                               => __('Once Off', 'wpamelia'),
            'open_following'                         => __('Open following', 'wpamelia'),
            'package_back_to_appointments'           => __('Back to appointments', 'wpamelia'),
            'package_back_to_packages'               => __('Back to packages', 'wpamelia'),
            'package_total_appointments_service'     => __('Appointments in this service', 'wpamelia'),
            'package_total_appointments'             => __('Appointments in this package', 'wpamelia'),
            'package_left_appointments'              => __('appointment slots left to be booked', 'wpamelia'),
            'package_purchase_canceled'              => __('Purchase is canceled', 'wpamelia'),
            'package_book_next_appointment'          => __('Book next appointment', 'wpamelia'),
            'package_cancel_success'                 => __('Package Canceled', 'wpamelia'),
            'package_continue_booking'               => __('Continue Booking', 'wpamelia'),
            'package_booked_appointments'            => __('Booked Appointments', 'wpamelia'),
            'package_deal'                           => __('This booking is part of a package deal', 'wpamelia'),
            'package_service_info'                   => __('Service info', 'wpamelia'),
            'package_price'                          => __('Package price', 'wpamelia'),
            'packages_dropdown'                      => __('Package', 'wpamelia'),
            'partially_paid'                         => __('Partially Paid', 'wpamelia'),
            'partially_refunded'                     => __('Partially Refunded', 'wpamelia'),
            'password_has_been_changed'              => __('Password has been changed', 'wpamelia'),
            'password_is_set'                        => __('Password is set', 'wpamelia'),
            'passwords_do_not_match'                 => __('Passwords do not match', 'wpamelia'),
            'payment'                                => __('Payment', 'wpamelia'),
            'pay'                                    => __('Pay', 'wpamelia'),
            'pay_now'                                => __('Pay now', 'wpamelia'),
            'payment_method'                         => __('Payment Method', 'wpamelia'),
            'payment_status'                         => __('Payment Status', 'wpamelia'),
            'payment_links'                          => __('Enable Payment from Link', 'wpamelia'),
            'payment_links_enable'                   => __('Allow payment via Payment Link', 'wpamelia'),
            'payment_links_enable_tooltip'           => __('If this option is enabled customers will be able to pay via email notifications or through their Customer panel.', 'wpamelia'),
            'payment_links_change_status'            => __('Update booking status automatically', 'wpamelia'),
            'payment_links_change_status_tooltip'    => __('Update booking status to approved after succesfull payment from link', 'wpamelia'),
            'payment_links_redirect'                 => __('Redirect URL after Payment', 'wpamelia'),
            'payment_links_redirect_tooltip'         => __('Customer will be redirected to this URL once the payment from the link is processed.', 'wpamelia'),
            'payment_links_warning'                  => __('Please note: For this option to work you need to add new payment link placeholders to the message templates', 'wpamelia'),
            'payments'                               => __('Payments', 'wpamelia'),
            'pending'                                => __('Pending', 'wpamelia'),
            'period_location_filter1_tooltip'        => __('Select specific location for this period.', 'wpamelia'),
            'period_location_filter2_tooltip'        => __('Select specific location for each period.', 'wpamelia'),
            'period_services_filter'                 => __('Applied for all assigned services', 'wpamelia'),
            'period_services_filter1_tooltip'        => __('Select only specific services for this period.<br/>If no services are selected, then all assigned services for this employee<br/>will be available for booking in this period.', 'wpamelia'),
            'period_services_filter2_tooltip'        => __('Select specific services for each period.', 'wpamelia'),
            'periods'                                => __('Periods', 'wpamelia'),
            'pick_a_date_or_range'                   => __('Pick a date or range', 'wpamelia'),
            'pick_a_year'                            => __('Pick a year', 'wpamelia'),
            'price'                                  => __('Price', 'wpamelia'),
            'price_per_spot'                         => __('Price per Spot', 'wpamelia'),
            'profile_deleted'                        => __('Profile deleted', 'wpamelia'),
            'profile_saved'                          => __('Profile has been updated', 'wpamelia'),
            'providers_dropdown'                     => __('Employee', 'wpamelia'),
            'provider_profile'                       => __('Employee Profile', 'wpamelia'),
            'purchased'                              => __('Purchased', 'wpamelia'),
            're_type_requred'                        => __('Please enter new password again', 'wpamelia'),
            'recovery_email_sent'                    => __('Email with access link has been sent', 'wpamelia'),
            'recurring'                              => __('Recurring', 'wpamelia'),
            'recurring_active'                       => __('Repeat this appointment', 'wpamelia'),
            'recurring_active_tooltip'               => __('Check this option if you want to create recurring appointments', 'wpamelia'),
            'recurring_type_monthly'                 => __('Monthly', 'wpamelia'),
            'recurring_type_weekly'                  => __('Weekly', 'wpamelia'),
            'recurring_type_yearly'                  => __('Yearly', 'wpamelia'),
            'recurring_list'                         => __('Create Appointments list', 'wpamelia'),
            'recurring_settings'                     => __('Back to recurring settings', 'wpamelia'),
            'redirect_url_after_appointment'         => __('Redirect URL After Booking', 'wpamelia'),
            'redirect_url_after_appointment_tooltip' => __('Customer will be redirected to this URL once he schedules the appointment.', 'wpamelia'),
            'redirect_url_after_app_or_package_tt'   => __('Customer will be redirected to this URL once he schedules the appointment or package.', 'wpamelia'),
            'refunded'                               => __('Refunded', 'wpamelia'),
            'rejected'                               => __('Rejected', 'wpamelia'),
            'repeat_every_year'                      => __('Repeat Every Year', 'wpamelia'),
            'reschedule'                             => __('Reschedule', 'wpamelia'),
            'save'                                   => __('Save', 'wpamelia'),
            'duplicate'                              => __('Duplicate', 'wpamelia'),
            'save_changes'                           => __('Save Changes', 'wpamelia'),
            'save_single'                            => __('No, just this one', 'wpamelia'),
            'save_special_day'                       => __('Save Special Day', 'wpamelia'),
            'schedule'                               => __('Schedule', 'wpamelia'),
            'select'                                 => __('Select', 'wpamelia'),
            'select_customer_warning'                => __('Please select at least one customer', 'wpamelia'),
            'select_single_customer_warning'         => __('Please select customer', 'wpamelia'),
            'select_customers'                       => __('Select Customer(s)', 'wpamelia'),
            'select_date_warning'                    => __('Please select date', 'wpamelia'),
            'select_cycle_warning'                   => __('Please select repeat period', 'wpamelia'),
            'select_interval_warning'                => __('Please select repeat interval', 'wpamelia'),
            'select_employee'                        => __('Select Employee', 'wpamelia'),
            'select_employee_warning'                => __('Please select employee', 'wpamelia'),
            'select_coupon'                          => __('Select Coupon', 'wpamelia'),
            'select_location'                        => __('Select Location', 'wpamelia'),
            'select_max_customer_count_warning'      => __('Maximum number of places is', 'wpamelia'),
            'select_repeat_period'                   => __('Select Repeat Period', 'wpamelia'),
            'select_repeat_interval'                 => __('Select Repeat Interval', 'wpamelia'),
            'select_service_category'                => __('Select Service Category', 'wpamelia'),
            'select_service_warning'                 => __('Please select service', 'wpamelia'),
            'select_time'                            => __('Select Time', 'wpamelia'),
            'select_time_warning'                    => __('Please select time', 'wpamelia'),
            'selected_customers'                     => __('Selected Customers', 'wpamelia'),
            'service_category'                       => __('Service Category', 'wpamelia'),
            'services_dropdown'                      => __('Service', 'wpamelia'),
            'service_no_extras'                      => __('This service does not have any extras', 'wpamelia'),
            'service_price'                          => __('Service Price', 'wpamelia'),
            'service_provider_remove_fail'           => __('You have appointments for this service', 'wpamelia'),
            'service_provider_remove_fail_all'       => __('You have appointments for', 'wpamelia'),
            'settings'                               => __('Settings', 'wpamelia'),
            'special_day_date_warning'               => __('Please enter date', 'wpamelia'),
            'special_day_end_time_warning'           => __('Please enter end time', 'wpamelia'),
            'special_day_start_time_warning'         => __('Please enter start time', 'wpamelia'),
            'special_days'                           => __('Special Days', 'wpamelia'),
            'special_days_reflect_services'          => __('Reflect On', 'wpamelia'),
            'spots'                                  => __('Spots', 'wpamelia'),
            'status'                                 => __('Status', 'wpamelia'),
            'disconnect'                             => __('Disconnect', 'wpamelia'),
            'stripe_connect'                         => __('Stripe Connect', 'wpamelia'),
            'stripe_preview'                         => __('Dashboard', 'wpamelia'),
            'stripe_onboard'                         => __('OnBoard', 'wpamelia'),
            'stripe_account_standard'                => __('Standard Account', 'wpamelia'),
            'stripe_account_express'                 => __('Express Account', 'wpamelia'),
            'success'                                => __('Success', 'wpamelia'),
            'time'                                   => __('Time', 'wpamelia'),
            'today'                                  => __('Today', 'wpamelia'),
            'tomorrow'                               => __('Tomorrow', 'wpamelia'),
            'total'                                  => __('Total', 'wpamelia'),
            'total_price'                            => __('Total Price', 'wpamelia'),
            'created_on'                             => __('Created On', 'wpamelia'),
            'update_following'                       => __('Update following', 'wpamelia'),
            'user_profile'                           => __('User Profile', 'wpamelia'),
            'week1'                                  => __('1 week', 'wpamelia'),
            'weekday_friday'                         => __('Friday', 'wpamelia'),
            'weekday_monday'                         => __('Monday', 'wpamelia'),
            'weekday_saturday'                       => __('Saturday', 'wpamelia'),
            'weekday_sunday'                         => __('Sunday', 'wpamelia'),
            'weekday_thursday'                       => __('Thursday', 'wpamelia'),
            'weekday_tuesday'                        => __('Tuesday', 'wpamelia'),
            'weekday_wednesday'                      => __('Wednesday', 'wpamelia'),
            'weeks2'                                 => __('2 weeks', 'wpamelia'),
            'weeks3'                                 => __('3 weeks', 'wpamelia'),
            'weeks4'                                 => __('4 weeks', 'wpamelia'),
            'wc_product'                             => __('Select WooCommerce product', 'wpamelia'),
            'wc_product_tooltip'                     => __('Here you can choose the product that will be used for WooCommerce integration.', 'wpamelia'),
            'wc_service'                             => __('WooCommerce Service', 'wpamelia'),
            'work_hours'                             => __('Work Hours', 'wpamelia'),
            'working_hours'                          => __('Working Hours', 'wpamelia'),
            'timezone'                               => __('Timezone', 'wpamelia'),
            'yes'                                    => __('Yes', 'wpamelia'),
            'outlook_sign_in'                        => __('Sign in with Outlook', 'wpamelia'),
            'outlook_sign_out'                       => __('Sign out from Outlook', 'wpamelia'),
            'outlook_calendar_tooltip'               => __('Here you can connect employee with Outlook Calendar,<br/>so once the appointment is scheduled it will be<br/>automatically added to employee\'s calendar.', 'wpamelia'),
            'zoom'                                   => __('Zoom', 'wpamelia'),
            'zoom_click_to_join'                     => __('Join Zoom Meeting', 'wpamelia'),
            'zoom_click_to_start'                    => __('Start Zoom Meeting', 'wpamelia'),
            'zoom_join_link'                         => __('Zoom Join Link (Participants)', 'wpamelia'),
            'zoom_link'                              => __('Zoom Link', 'wpamelia'),
            'zoom_links'                             => __('Zoom Links', 'wpamelia'),
            'zoom_start_link'                        => __('Zoom Start Link (Host)', 'wpamelia'),
            'zoom_user'                              => __('Zoom User', 'wpamelia'),
            'zoom_user_placeholder'                  => __('Select Zoom User', 'wpamelia'),
            'zoom_user_tooltip'                      => __('Here you can select Zoom User,<br/>so once the appointment is scheduled,<br/>zoom meeting will be automatically created.', 'wpamelia'),
            'wc_order'                               => __('Order', 'wpamelia'),
            'tax'                                    => __('Tax', 'wpamelia'),
            'due'                                    => __('Due', 'wpamelia'),
            'google_meet_link'                       => __('Google Meet Link', 'wpamelia'),
            'microsoft_teams_link'                   => __('Microsoft Teams Link', 'wpamelia'),
            'personal_info'                          => __('Personal Information', 'wpamelia'),
            'password_tab'                           => __('Password', 'wpamelia'),
            'profile_data_success'                   => __('Profile data updated successfully', 'wpamelia'),
            'password_success'                       => __('Password changed successfully', 'wpamelia'),
            'menu_title'                             => __('Menu', 'wpamelia'),
            'log_out'                                => __('Log out', 'wpamelia'),
            'toggle_sidebar'                         => __('Toggle Sidebar', 'wpamelia'),
            'filters'                                => __('Filters', 'wpamelia'),
            'package_deal_expire_in'                 => __('This package deal will expire in', 'wpamelia'),
            'appointments_deal_expire'               => __('book appointments before the deal expires!', 'wpamelia'),
            'pay_now_btn'                            => __('Pay now', 'wpamelia'),
            'no_app_found'                           => __('No appointments found', 'wpamelia'),
            'have_no_app'                            => __('You don\'t have any appointments', 'wpamelia'),
            'no_pack_found'                          => __('No packages found', 'wpamelia'),
            'have_no_pack'                           => __('You don\'t have any packages', 'wpamelia'),
            'no_evt_found'                           => __('No events found', 'wpamelia'),
            'have_no_evt'                            => __('You don\'t have any events', 'wpamelia'),
            'notification_language'                  => __('Notification Language', 'wpamelia'),
            'language'                               => __('Language', 'wpamelia'),
            'select_wp_user'                         => __('Select or Create New', 'wpamelia'),
            'wp_user'                                => __('WordPress User', 'wpamelia'),
            'female'                                 => __('Female', 'wpamelia'),
            'male'                                   => __('Male', 'wpamelia'),
            'gender'                                 => __('Gender', 'wpamelia'),
            'start_date'                             => __('Start Date', 'wpamelia'),
            'end_date'                               => __('End Date', 'wpamelia'),
            'start_time'                             => __('Start Time', 'wpamelia'),
            'end_time'                               => __('End Time', 'wpamelia'),
            'delete_period'                          => __('Delete Period', 'wpamelia'),
            'new_customer'                           => __('New Customer', 'wpamelia'),
            'appointment_status_changed'             => __('Appointment status has been changed to ', 'wpamelia'),
        ] : [];

        return array_merge($labels, LiteFrontendStrings::getCabinetStrings());
    }
}
