<?php
namespace Jet_Popup\Settings;

use Jet_Dashboard\Base\Page_Module as Page_Module_Base;
use Jet_Dashboard\Dashboard as Dashboard;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

class General extends Page_Module_Base {

	/**
	 * Returns module slug
	 *
	 * @return void
	 */
	public function get_page_slug() {
		return 'jet-popup-general';
	}

	/**
	 * [get_subpage_slug description]
	 * @return [type] [description]
	 */
	public function get_parent_slug() {
		return 'settings-page';
	}

	/**
	 * [get_page_name description]
	 * @return [type] [description]
	 */
	public function get_page_name() {
		return esc_html__( 'General', 'jet-popup' );
	}

	/**
	 * [get_category description]
	 * @return [type] [description]
	 */
	public function get_category() {
		return 'jet-popup-settings';
	}

	/**
	 * [get_page_link description]
	 * @return [type] [description]
	 */
	public function get_page_link() {
		return Dashboard::get_instance()->get_dashboard_page_url( $this->get_parent_slug(), $this->get_page_slug() );
	}

	/**
	 * Enqueue module-specific assets
	 *
	 * @return void
	 */
	public function enqueue_module_assets() {

		wp_enqueue_style(
			'jet-popup-admin',
			jet_popup()->plugin_url( 'assets/css/jet-popup-admin.css' ),
			[],
			jet_popup()->get_version()
		);

		wp_enqueue_script(
			'jet-popup-admin-vue-components',
			jet_popup()->plugin_url( 'assets/js/admin-vue-components.js' ),
			array( 'jquery', 'wp-api-fetch' ),
			jet_popup()->get_version(),
			true
		);

		wp_localize_script(
			'jet-popup-admin-vue-components', 'jetPopupSettingsConfig', jet_popup()->settings->get_settings_page_config()
		);

	}

	/**
	 * License page config
	 *
	 * @param  array  $config  [description]
	 * @param  string $subpage [description]
	 * @return [type]          [description]
	 */
	public function page_config( $config = array(), $page = false, $subpage = false ) {

		$config['pageModule'] = $this->get_parent_slug();
		$config['subPageModule'] = $this->get_page_slug();

		return $config;
	}

	/**
	 * [page_templates description]
	 * @param  array  $templates [description]
	 * @param  string $subpage   [description]
	 * @return [type]            [description]
	 */
	public function page_templates( $templates = array(), $page = false, $subpage = false ) {
		$templates['jet-popup-general'] = jet_popup()->plugin_path( 'templates/vue-templates/admin/settings-templates/general.php' );

		return $templates;
	}
}
