<?php

	function pixelwars_core__dashboard_widget()
	{
		$current_directory_url = plugin_dir_url(__FILE__); // Get url directory of this file. (with trailing slash)
		
		?>
		<div class="pixelwars-core--dashboard-widget">
			<p class="pixelwars-core--dashboard-widget--logo-wrapper">
				<img alt="Pixelwars" src="<?php echo esc_url($current_directory_url); ?>img/pixelwars-logo.png">
			</p>
			
			<h2 class="pixelwars-core--dashboard-widget--title">
				<?php
					esc_html_e('Discover Our New Themes', 'pixelwars-core');
				?>
			</h2>
			
			<p>
				<?php
					esc_html_e('Check out our latest themes designed to make your site stand out! With modern designs, powerful features, and easy customization, these themes are built to impress.', 'pixelwars-core');
				?>
			</p>
			
			<p class="pixelwars-core--dashboard-widget--image-wrapper">
				<a title="<?php esc_html_e('View Themes', 'pixelwars-core'); ?>" target="_blank" href="https://themeforest.net/user/pixelwars/portfolio">
					<img style="max-width: 100%;" alt="Pixelwars Themes" src="https://themes.pixelwars.org/tf-preview/pixelwars-themes.gif">
				</a>
			</p>
			
			<p class="pixelwars-core--dashboard-widget--button-wrapper">
				<a class="button button-primary button-hero pixelwars-core--dashboard-widget--button" target="_blank" href="https://themeforest.net/user/pixelwars/portfolio">
					<?php
						esc_html_e('Explore Now', 'pixelwars-core');
					?>
				</a>
			</p>
			
			<br>
			<hr>
			<br>
			
			<h3 class="pixelwars-core--dashboard-widget--support-title">
				<?php
					esc_html_e('Support', 'pixelwars-core');
				?>
			</h3>
			<p>
				<?php
					esc_html_e('Our support team is always there to help you out with any questions or issues you may come across.', 'pixelwars-core');
				?>
			</p>
			
			<p>
				<a class="button" target="_blank" href="https://www.pixelwars.org/forums/"><?php esc_html_e('Get Support', 'pixelwars-core'); ?></a>
			</p>
		</div>
		<?php
	}
	
	
	function pixelwars_core_dashboard_setup()
	{
		wp_add_dashboard_widget(
			'pixelwars_core__add_dashboard_widget',
			esc_html__('Pixelwars', 'pixelwars-core'),
			'pixelwars_core__dashboard_widget',
			$control_callback = null,
			$callback_args    = null,
			$context          = 'normal',
			$priority         = 'high'
		); 
	}
	
	add_action('wp_dashboard_setup', 'pixelwars_core_dashboard_setup', 1);

