<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Edumodo
 */

    // Global Options
    global $edumodo_options;
    // Prefix
    $prefix = '_edumodo_';
    $post_id = edumodo_get_id();

    // social enable

    $soical_enable = edumodo_array_get($edumodo_options, 'enable-social') ? $edumodo_options['enable-social'] : '';
    // Social url
    $facebook_url = edumodo_array_get($edumodo_options, 'facebook') ? $edumodo_options['facebook'] : '';
    $twitter_url = edumodo_array_get($edumodo_options, 'twitter') ? $edumodo_options['twitter'] : '';
    $instagram_url = edumodo_array_get($edumodo_options, 'instagram') ? $edumodo_options['instagram'] : '';
    $linkedin_url = edumodo_array_get($edumodo_options, 'linkedin') ? $edumodo_options['linkedin'] : '';
    $youtube_url = edumodo_array_get($edumodo_options, 'youtube') ? $edumodo_options['youtube'] : '';
    $skype_url = edumodo_array_get($edumodo_options, 'skype') ? $edumodo_options['skype'] : '';

    // footer copyright
    $footer_option   = edumodo_array_get($edumodo_options, 'edumodo-footer-layout') ? $edumodo_options['edumodo-footer-layout'] : '';
    $edumodo_credit_switcher   = edumodo_array_get($edumodo_options, 'edumodo-credit-switcher') ? $edumodo_options['edumodo-credit-switcher'] : '';
    $edumodo_credit_text   = edumodo_array_get($edumodo_options, 'edumodo-user-credit-text') ? $edumodo_options['edumodo-user-credit-text'] : '';
    $edumodo_credit_url   = edumodo_array_get($edumodo_options, 'edumodo-user-credit-text') ? $edumodo_options['edumodo-user-credit-url'] : '';
    $edumodo_user_copyright_text   = edumodo_array_get($edumodo_options, 'edumodo-user-copyright-text') ? $edumodo_options['edumodo-user-copyright-text'] : '';


?>


        <?php
            switch ( $footer_option ) {

                case 'column-1':
                    get_template_part( 'template-parts/footer/column', 'one' );
                    break;

                case 'column-2':
                    get_template_part( 'template-parts/footer/column', 'two' );
                    break;

                case 'column-3':
                    get_template_part( 'template-parts/footer/column', 'three' );
                    break;

                case 'column-4':
                    get_template_part( 'template-parts/footer/column', 'four' );
                    break;

                default:
                    get_template_part( 'template-parts/footer/column', 'five' );
            }
        ?>
         <?php  if (!class_exists( 'ReduxFrameworkPlugin', true ) ) : ?>
            <div id="copyright" class="copyright">
                <div class="container">
                    <div class="row">
                         <div class="col-md-12 text-center">
                            <div class="edumodo-credit-wrapper">
                                <div class="copyright-info">
                                <?php printf( esc_html__( 'Powered %1$s by %2$s', 'edumodo' ), '', '<a href="https://themesgrove.com/education-wordpress-theme/">Education WordPress Theme</a>' ); ?>
                                </div><!-- .site-info -->
                            </div> 
                        </div><!-- .site-info -->
                    </div>
                </div>
            </div>
        <?php else : ?>

        <div id="copyright" class="copyright">
            <div class="container">
                <div class="row">
                    <div class="<?php echo ($edumodo_credit_switcher == '1')? 'col-md-6 col-sm-6' : 'col-md-12 text-center';?>">
                        <div class="edumodo-credit-wrapper">
                            <?php if ($edumodo_user_copyright_text) : ?>
                                <div class="copyright-info">
                                      <?php echo wp_kses($edumodo_user_copyright_text, wp_kses_allowed_html('post')); ?>
                                </div><!-- .site-info -->
                            <?php endif; ?>

                            <?php if ($edumodo_credit_switcher): ?>
                                <div class="user-credit">
                                    <a href="<?php echo  $edumodo_credit_url; ?>"><?php echo $edumodo_credit_text; ?></a>
                                </div>       
                            <?php endif; ?>
                        </div> 
                    </div><!-- .site-info -->
                    <?php if ($soical_enable == '1'):?>
                        <div class="col-md-6 col-sm-6">
                            <div class="social-icon text-right">
                                <?php if ($facebook_url):?>
                                    <a target="_blank" href="<?php echo esc_url($facebook_url); ?>">
                                        <i class="glyph-icon flaticon-facebook-logo"></i>
                                    </a>
                                <?php endif; ?>

                                <?php if ($twitter_url):?>
                                    <a target="_blank" href="<?php echo esc_url($twitter_url); ?>">
                                        <i class="glyph-icon flaticon-twitter"></i>
                                    </a>
                                <?php endif; ?>
                                    
                                <?php if ($instagram_url):?>
                                    <a target="_blank" href="<?php echo esc_url($instagram_url); ?>">
                                        <i class="glyph-icon flaticon-instagram-1"></i>
                                    </a>
                                <?php endif; ?>

                                <?php if ($linkedin_url):?>
                                    <a target="_blank" href="<?php echo esc_url($linkedin_url); ?>">
                                        <i class="glyph-icon flaticon-linkedin-logo"></i>
                                    </a>
                                <?php endif; ?>

                                <?php if ($youtube_url):?>
                                    <a target="_blank" href="<?php echo esc_url($youtube_url); ?>">
                                        <i class="glyph-icon flaticon-youtube-logo"></i>
                                    </a>
                                <?php endif; ?>                                                                                 

                                <?php if ($skype_url):?>
                                    <a target="_blank" href="<?php echo esc_url($skype_url); ?>">
                                        <i class="glyph-icon flaticon-skype-logo"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                       
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php endif; ?>

