<?php
/**
 * Template part for displaying course
  posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Edumodo
 */

    // Global Options
    global $edumodo_options;
    // Prefix
    $prefix = '_edumodo_';
    // sidebar position
    $archive_course_title_length = $edumodo_options['archive_course_title_length'];
    $archive_course_contnent_length = $edumodo_options['archive_course_contnent_length'];
    $enable_archive_page_fixed_height_course = $edumodo_options['enable_archive_page_fixed_height_course'];
    $archive_page_fixed_height_course = $edumodo_options['archive_page_fixed_height_course'];
    $enable_archive_page_date = $edumodo_options['enable_archive_page_date'];
    $enable_archive_page_views = $edumodo_options['enable_archive_page_views'];
    $archive_image_size = $edumodo_options['archive_image_size'];

?>

    <div class="edumodo-course-1">
        <div class="col-md-4 col-lg-4 col-xs-12 col-sm-6">
            <article id="post-<?php the_ID(); ?>" <?php post_class('custom-post'); ?> style="height:<?php if ($enable_archive_page_fixed_height_course == true ) : ?> <?php echo $archive_page_fixed_height_course?>px; <?php endif; ?>">

                <?php if ( has_post_thumbnail() ):?>
                    <figure class="post-thumbnail">
                        <a href="<?php the_permalink(); ?>">
                            <?php the_post_thumbnail($archive_image_size );?>
                        </a>
                    </figure>
                <?php endif; ?>

                <div class="course-details">
     
                    <?php if ( 'tx-course' === get_post_type() ) : ?>

                        <header class="entry-header">
                            <h4 class="course-entry-title">
                                  <a href="<?php the_permalink();?>"><?php echo wp_trim_words( get_the_title(), $archive_course_title_length, ''); ?></a> 
                            </h4>       
                        </header><!-- .entry-header -->
                        
                        <div class="entry-meta course-meta">
                            <?php if ($enable_archive_page_date == true): ?>
                                <span class="post-date">
                                  <i class="glyph-icon flaticon-calendar-with-spring-binder-and-date-blocks"></i> 
                                   <?php 
                                        $archive_year  = get_the_time('Y'); 
                                        $archive_month = get_the_time('m'); 
                                        $archive_day   = get_the_time('d'); 
                                    ?>
                                    <a href="<?php echo get_day_link( $archive_year, $archive_month, $archive_day); ?>"><?php echo get_the_date(); ?></a>
                                </span>
                             <?php endif ?>
                             <?php if ($enable_archive_page_views == true): ?>
                                <span class="post-view">
                                    <!-- <i class="glyph-icon flaticon-binoculars"></i>  -->
                                    <i class="glyph-icon fa fa-eye"></i> 
                                    <?php echo getPostViews(get_the_ID()); ?>
                                </span>      
                             <?php endif ?>
                        </div><!-- .entry-meta -->
                    <?php endif; ?>
                
                    <?php  
                    $post_formats = array('audio', 'image', 'video', 'link', 'gallery'); 
                    if (!in_array(get_post_format(), $post_formats)):?>
                        <div class="entry-content">
                            <p><?php echo wp_trim_words( get_the_excerpt(), $archive_course_contnent_length, ''); ?></p>
                        </div><!-- .entry-content -->
                    <?php endif; ?>

                </div><!-- .course details -->
            </article><!-- #post-## -->
        </div> <!-- /.col-md-4 -->

    </div> <!-- /.section -->



		
