<?php
$links = $args['links'];
?>

<div class="welcome-panel-content tx-wizard-welcome-panel">
    <h2><?php _e( 'Welcome to WordPress!', 'edumodo' ); ?></h2>

    <p class="about-description"><?php _e( 'We&#8217;ve assembled some links to get you started:', 'edumodo' ); ?></p>

    <div class="welcome-panel-column-container">
        <div class="welcome-panel-column">
            <h3><?php _e( 'Create a new', 'edumodo' ); ?></h3>
            <ul>
				<?php if ( current_user_can( 'edit_posts' ) ) : ?>
                    <li>
						<?php printf( '<a href="%s" class="welcome-icon welcome-add-post">' . __( 'Your first blog post', 'edumodo' ) . '</a>', admin_url( 'post-new.php?post_type=post' ) ); ?>
                    </li>
				<?php endif; ?>

				<?php if ( current_user_can( 'edit_pages' ) ) : ?>
                    <li>
						<?php printf( '<a href="%s" class="welcome-icon welcome-add-page">' . __( 'Page', 'edumodo' ) . '</a>', admin_url( 'post-new.php?post_type=page' ) ); ?>
                    </li>
				<?php endif; ?>

				<?php if ( current_user_can( 'install_plugins' ) ) : ?>
                    <li>
						<?php printf( '<a href="%s" class="welcome-icon welcome-add-plugin">' . __( 'Plugin', 'edumodo' ) . '</a>', admin_url( 'plugin-install.php' ) ); ?>
                    </li>
				<?php endif; ?>
            </ul>
        </div>

        <div class="welcome-panel-column">
            <h3><?php _e( 'Quick links', 'edumodo' ); ?></h3>

            <ul>
				<?php if ( current_theme_supports( 'widgets' ) || current_theme_supports( 'menus' ) ) : ?>
                    <li>
                        <div class="welcome-icon welcome-widgets-menus">
							<?php
							if ( current_theme_supports( 'widgets' ) && current_theme_supports( 'menus' ) ) {
								printf( __( 'Manage <a href="%1$s">widgets</a> or <a href="%2$s">menus</a>', 'edumodo' ),
									admin_url( 'widgets.php' ),
									admin_url( 'nav-menus.php' )
								);
							} elseif ( current_theme_supports( 'widgets' ) ) {
								echo '<a href="' . admin_url( 'widgets.php' ) . '">' . __( 'Manage widgets' ) . '</a>';
							} else {
								echo '<a href="' . admin_url( 'nav-menus.php' ) . '">' . __( 'Manage menus' ) . '</a>';
							}
							?>
                        </div>
                    </li>
				<?php endif; ?>

				<?php if ( current_user_can( 'edit_theme_options' ) ) : ?>
                    <li>
                        <a class="welcome-icon welcome-txw-documentation" href="<?php echo esc_url( $links['docs'] ); ?>" target="_blank"><?php esc_html_e( 'Documentation', 'edumodo' ); ?></a>
                    </li>

                    <li>
                        <a class="welcome-icon welcome-txw-support" href="<?php echo esc_url( $links['support'] ); ?>" target="_blank"><?php esc_html_e( 'Support', 'edumodo' ); ?></a>

                        <div class="sub">
							<?php esc_html_e( 'Typical replies in 24 hours - Business day - GMT+7', 'edumodo' ); ?>
                        </div>
                    </li>
				<?php endif; ?>
            </ul>

			<?php if ( current_user_can( 'customize' ) ) : ?>
                <a class="button button-primary button-hero load-customize hide-if-no-customize" href="<?php echo wp_customize_url(); ?>"><?php _e( 'Customize Your Site', 'edumodo' ); ?></a>
			<?php endif; ?>

            <a class="button button-primary button-hero hide-if-customize" href="<?php echo admin_url( 'themes.php' ); ?>"><?php _e( 'Customize Your Site', 'edumodo' ); ?></a>

			<?php
			$args_themes = array(
				'allowed' => true,
			);
			if ( current_user_can( 'install_themes' ) || ( current_user_can( 'switch_themes' ) && count( wp_get_themes( $args_themes ) ) > 1 ) ) :
				?>
                <p class="hide-if-no-customize"><?php printf( __( 'or, <a href="%s">change your theme completely</a>', 'edumodo' ), admin_url( 'themes.php' ) ); ?></p>
			<?php endif; ?>
        </div>
    </div>
</div>
