<?php

$colors = $args['colors'];
if ( count( $colors ) < 4 ) {
	return;
}
$background_color = $colors[0];
$base_color       = $colors[2];
?>

<style id="tx-wizard-admin-styles">
    .txw-base-color {
        color: <?php echo esc_attr( $base_color ); ?>
    }

    .txw-base-color:hover {
        background-color: <?php echo esc_attr( $base_color ); ?>;
        color: #fff;
    }

    .txw-background-color {
        background-color: <?php echo esc_attr( $base_color ); ?> !important;
    }

    /* Getting started */
    .txw-controls .step.active:before {
        border-color: <?php echo esc_attr( $base_color ); ?> !important;
        background-color: <?php echo esc_attr( $base_color ); ?> !important;
    }

    .txw-controls li .active ~ .label {
        color: <?php echo esc_attr( $base_color ); ?> !important;
    }

    .txw-controls .step.active {
        background-color: <?php echo esc_attr( $base_color ); ?> !important;;
    }

    /* Import demo */
    .txw-importer-wrapper .tx-demo .status {
        background-color: <?php echo esc_attr( $base_color ); ?> !important;
    }

    .txw-importer-wrapper .tx-demo .status:hover {
        background-color: <?php echo esc_attr( $background_color ); ?> !important;
    }

    /* Mega menu */
    .tx-wrapper-mega-menu .field-tx-sub-align input:checked {
        color: <?php echo esc_attr( $base_color ); ?> !important;
    }

    #txw-megamenu-choose-icons .txw-icon:hover, #txw-megamenu-choose-icons .txw-icon.active {
        border-color: <?php echo esc_attr( $base_color ); ?> !important;
        color: <?php echo esc_attr( $base_color ); ?> !important;
    }

    .txw-modal-importer .main .options .package .package-progress-bar {
        background-color: <?php echo esc_attr( $base_color ); ?> !important;
    }
</style>
