<?php

/**
 * Class TX_Template_Helper.
 *
 */
if ( ! class_exists( 'TX_Template_Helper' ) ) {
	class TX_Template_Helper {
		/**
		 * Get template path.
		 */
		private static function get_template_path() {
			return apply_filters( 'tx_wizard_template_path', 'tx-core/' );
		}

		/**
		 * Get template part.
		 *
		 * @param $path
		 * @param $args
		 * @param $render
		 *
		 * @return bool|string
		 */
		public static function template( $path, $args = array(), $render = false ) {
			$template = locate_template( self::get_template_path() . $path );

			if ( ! $template ) {
				$template = TX_WIZARD_PATH . '/templates/' . $path;
			}

			if ( $render ) {
				return self::render_template( $template, $args );
			}

			return self::get_template( $template, $args );
		}

		/**
		 * Render template.
		 *
		 * @param $file
		 * @param $args
		 *
		 * @return bool
		 */
		private static function render_template( $file, $args = array() ) {
			if ( ! is_file( $file ) || ! is_readable( $file ) ) {
				return false;
			}

			include $file;

			return true;
		}

		/**
		 * Get template.
		 *
		 * @param $file
		 * @param $args
		 *
		 * @return bool|string
		 */
		private static function get_template( $file, $args = array() ) {
			if ( ! is_file( $file ) || ! is_readable( $file ) ) {
				return false;
			}

			ob_start();
			include $file;

			return ob_get_clean();
		}
	}
}
