<?php

Redux::setSection( $opt_name, array(
    'title' => __( 'TX Course', 'edumodo' ),
    'id'    => 'tx_courses',
    'desc'  => __( '', 'edumodo' ),
    'icon'  => 'el el-screen'
) );

Redux::setSection( $opt_name, array(
    'title'  => esc_html__( 'Archive Page', 'edumodo' ),
    'id'     => 'tx_course',
    'subsection' => true,
    'fields' => array(

        array(
             'id'      => 'tx_course_change_slag',
             'title'   => __( 'Course Slag', 'edumodo' ),
              'subtitle' => esc_html__('After changing slug you must flash permalink', 'edumodo'),
             'type'    => 'text',
             'default' => 'tx-course',
         ),   

        array(
             'id'      => 'tx_course_change_category_slag',
             'title'   => __( 'Category Slag', 'edumodo' ),
            'subtitle' => esc_html__('After changing category slug you must flash permalink ', 'edumodo'),
             'type'    => 'text',
             'default' => 'tx-course-category',
         ),   

        array(
             'id'      => 'tx_course_archive_page_title',
             'title'   => __( 'Archive Page Title', 'edumodo' ),
             'type'    => 'text',
             'default' => 'All Courses',
         ),   

        array(
            'id'      => 'tx_course_per_page',
            'type'    => 'spinner',
            'title'   => __( 'Course Per Page', 'edumodo' ),
            'default' => '6',
            'min'     => '1',
            'step'    => '1',
            'max'     => '50',
        ),

        array(
            'id'       => 'enable_archive_page_fixed_height_course',
            'type'     => 'switch',
            'title'    => esc_html__('Courses Fixed Height', 'edumodo'),
            'default'  => 0,
            'on'       => 'Enabled',
            'off'      => 'Disabled',
        ),

        array(
            'id'            => 'archive_page_fixed_height_course',
            'type'          => 'slider',
            'title'         => __( 'Courses Fixed Height', 'edumodo' ),
            'default'       => 450,
            'min'           => 300,
            'step'          => 1,
            'max'           => 700,
            'display_value' => 'label',
            'required' => array('enable_archive_page_fixed_height_course','=', true)
        ),
        
        array( 
            'id' => 'archive_image_size',
            'title'    => esc_html__('Image Size', 'edumodo'),
            'type' => 'select', 
            'default'  => 'tx_course_archive',
            'options' => edumodo_image_sizes_by_array(),
        ), 

        array(
            'id'      => 'archive_course_title_length',
            'type'    => 'spinner',
            'title'   => __( 'Courses Title Length', 'edumodo' ),
            'default' => '8',
            'min'     => '1',
            'step'    => '1',
            'max'     => '50',
        ),

        array(
            'id'      => 'archive_course_contnent_length',
            'type'    => 'spinner',
            'title'   => __( 'Courses Content Length', 'edumodo' ),
            'default' => '15',
            'min'     => '1',
            'step'    => '1',
            'max'     => '150',
        ),
        array(
            'id'       => 'enable_archive_page_date',
            'type'     => 'switch',
            'title'    => esc_html__('Archive Courses Date', 'edumodo'),
            'default'  => 1,
            'on'       => 'Enabled',
            'off'      => 'Disabled',
        ),

        array(
            'id'       => 'enable_archive_page_views',
            'type'     => 'switch',
            'title'    => esc_html__('Archive Courses Views', 'edumodo'),
            'default'  => 1,
            'on'       => 'Enabled',
            'off'      => 'Disabled',
        ),
      
    )
) );

Redux::setSection( $opt_name, array(
    'title'  => esc_html__( 'Single Page', 'edumodo' ),
    'id'     => 'tx_course_single',
    'subsection' => true,
    'fields' => array(

        array(
             'id'      => 'course_from_shortcode',
             'title'   => __( 'weForms Shortcode', 'edumodo' ),
             'type'    => 'text',
             'default' => '[weforms id="3751"]',
         ), 
        array(
            'id'       => 'enable_single_page_date',
            'type'     => 'switch',
            'title'    => esc_html__('Courses Date', 'edumodo'),
            'default'  => 1,
            'on'       => 'Enabled',
            'off'      => 'Disabled',
        ),

        array(
            'id'       => 'enable_single_page_views',
            'type'     => 'switch',
            'title'    => esc_html__('Course Views', 'edumodo'),
            'default'  => 1,
            'on'       => 'Enabled',
            'off'      => 'Disabled',
        ),  

        array(
            'id'       => 'enable_single_page_cat',
            'type'     => 'switch',
            'title'    => esc_html__('Course Category', 'edumodo'),
            'default'  => 1,
            'on'       => 'Enabled',
            'off'      => 'Disabled',
        ),

        array( 
            'id' => 'single_course_image_size',
            'title'    => esc_html__('Image Size', 'edumodo'),
            'type' => 'select', 
            'default'  => 'full',
            'options' => edumodo_image_sizes_by_array(),
        ),
    )

) );



